/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.listeners;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BackpackProtectionListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        ItemStack cursor = event.getCursor();
        ItemStack current = event.getCurrentItem();
        String title = event.getView().getTitle();
        boolean topIsBackpack = this.isBackpackTitle(title);
        if (topIsBackpack && clickedInventory == topInventory && cursor != null && BackpackItem.isBackpack(cursor)) {
            event.setCancelled(true);
            event.getWhoClicked().sendMessage("\u00a7cYou cannot put a backpack inside another backpack!");
            return;
        }
        if (event.isShiftClick() && current != null && BackpackItem.isBackpack(current) && topIsBackpack && clickedInventory != topInventory) {
            event.setCancelled(true);
            event.getWhoClicked().sendMessage("\u00a7cYou cannot put a backpack inside another backpack!");
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        String title = event.getView().getTitle();
        if (!this.isBackpackTitle(title)) {
            return;
        }
        ItemStack draggedItem = event.getOldCursor();
        if (draggedItem != null && BackpackItem.isBackpack(draggedItem)) {
            event.setCancelled(true);
            event.getWhoClicked().sendMessage("\u00a7cYou cannot put a backpack inside another backpack!");
        }
    }

    private boolean isBackpackTitle(String title) {
        if (title == null) {
            return false;
        }
        for (BackpackTier tier : BackpackTier.values()) {
            if (!title.contains(tier.getDisplayName())) continue;
            return true;
        }
        return false;
    }
}

