/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BackpackManager {
    private final Plugin plugin;
    private final File backpacksFile;
    private YamlConfiguration backpacksConfig;
    private final Map<UUID, Inventory> loadedInventories;

    public BackpackManager(Plugin plugin) {
        boolean created;
        this.plugin = plugin;
        this.loadedInventories = new HashMap<UUID, Inventory>();
        if (!plugin.getDataFolder().exists() && !(created = plugin.getDataFolder().mkdirs())) {
            plugin.getLogger().warning("Could not create data folder!");
        }
        this.backpacksFile = new File(plugin.getDataFolder(), "backpacks.yml");
        this.loadBackpacksFile();
    }

    private void loadBackpacksFile() {
        if (!this.backpacksFile.exists()) {
            try {
                this.backpacksFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create backpacks.yml!", e);
            }
        }
        this.backpacksConfig = YamlConfiguration.loadConfiguration((File)this.backpacksFile);
    }

    private void saveBackpacksFile() {
        try {
            this.backpacksConfig.save(this.backpacksFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save backpacks.yml!", e);
        }
    }

    public Inventory getInventory(UUID backpackUuid, String title, int slots) {
        Object contentsObj;
        UUID backpackUUID = backpackUuid;
        if (this.loadedInventories.containsKey(backpackUUID)) {
            Inventory cached = this.loadedInventories.get(backpackUUID);
            if (cached.getSize() == slots) {
                return cached;
            }
            this.plugin.getLogger().info("Resizing backpack " + String.valueOf(backpackUUID) + " from " + cached.getSize() + " to " + slots + " slots");
            Inventory newInventory = Bukkit.createInventory(null, (int)slots, (String)title);
            ItemStack[] oldContents = cached.getContents();
            if (oldContents != null) {
                for (int i = 0; i < oldContents.length && i < slots; ++i) {
                    if (oldContents[i] == null) continue;
                    newInventory.setItem(i, oldContents[i]);
                }
            }
            this.loadedInventories.put(backpackUUID, newInventory);
            this.saveInventory(backpackUUID, newInventory);
            return newInventory;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)slots, (String)title);
        String path = backpackUUID.toString() + ".contents";
        if (this.backpacksConfig.contains(path) && (contentsObj = this.backpacksConfig.get(path)) != null) {
            ItemStack[] contents = ((List)contentsObj).toArray(new ItemStack[0]);
            for (int i = 0; i < contents.length && i < slots; ++i) {
                if (contents[i] == null) continue;
                inventory.setItem(i, contents[i]);
            }
        }
        this.loadedInventories.put(backpackUUID, inventory);
        this.saveInventory(backpackUUID, inventory);
        return inventory;
    }

    public void saveInventory(UUID backpackUuid, Inventory inventory) {
        UUID backpackUUID = backpackUuid;
        String path = backpackUUID.toString() + ".contents";
        ItemStack[] contents = inventory.getContents();
        if (contents != null) {
            this.backpacksConfig.set(path, Arrays.asList(contents));
        }
        this.saveBackpacksFile();
        this.loadedInventories.put(backpackUUID, inventory);
    }

    public void clearInventory(UUID backpackUuid) {
        UUID backpackUUID = backpackUuid;
        this.backpacksConfig.set(backpackUUID.toString(), null);
        this.saveBackpacksFile();
        this.loadedInventories.remove(backpackUUID);
    }

    public void saveAllInventories() {
        for (Map.Entry<UUID, Inventory> entry : this.loadedInventories.entrySet()) {
            String path = entry.getKey().toString() + ".contents";
            ItemStack[] contents = entry.getValue().getContents();
            if (contents == null) continue;
            this.backpacksConfig.set(path, Arrays.asList(contents));
        }
        this.saveBackpacksFile();
        this.plugin.getLogger().info("Saved " + this.loadedInventories.size() + " backpack inventories");
    }

    public void loadAllBackpacks() {
        this.loadBackpacksFile();
        int count = this.backpacksConfig.getKeys(false).size();
        this.plugin.getLogger().info("Loaded data for " + count + " backpacks");
    }

    public boolean backpackExists(UUID backpackUuid) {
        UUID backpackUUID = backpackUuid;
        return this.backpacksConfig.contains(backpackUUID.toString() + ".contents");
    }

    public Inventory getLoadedInventory(UUID backpackUuid) {
        UUID backpackUUID = backpackUuid;
        return this.loadedInventories.get(backpackUUID);
    }

    public List<UUID> getAllBackpackUUIDs() {
        this.backpacksConfig = YamlConfiguration.loadConfiguration((File)this.backpacksFile);
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String key : this.backpacksConfig.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                uuids.add(uuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return uuids;
    }

    public UUID findInventoryUUID(Inventory inventory) {
        for (Map.Entry<UUID, Inventory> entry : this.loadedInventories.entrySet()) {
            if (!entry.getValue().equals((Object)inventory)) continue;
            return entry.getKey();
        }
        return null;
    }
}

