/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.listeners;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import com.shweit.expendablebackpacks.util.BackpackBlockUtil;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;

public class BackpackBlockListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (!BackpackItem.isBackpack(item)) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        UUID backpackUUID = BackpackItem.getBackpackUUID(item);
        BackpackTier tier = BackpackItem.getBackpackTier(item);
        if (backpackUUID == null || tier == null) {
            player.sendMessage("\u00a7cError: Invalid backpack data!");
            event.setCancelled(true);
            return;
        }
        if (block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD) {
            return;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Skull) {
            Skull skull = (Skull)blockState;
            String textureValue = tier.getTextureValue();
            if (textureValue != null && !textureValue.startsWith("PLACEHOLDER")) {
                try {
                    PlayerProfile profile = Bukkit.createProfile((UUID)backpackUUID);
                    profile.getProperties().add(new ProfileProperty("textures", textureValue));
                    skull.setPlayerProfile(profile);
                }
                catch (Exception e) {
                    player.sendMessage("\u00a7cError: Failed to set backpack texture!");
                    event.setCancelled(true);
                    return;
                }
            }
            if (!BackpackBlockUtil.setBlockData(block, backpackUUID, tier)) {
                player.sendMessage("\u00a7cError: Failed to store backpack data!");
                event.setCancelled(true);
                return;
            }
            player.sendMessage("\u00a77Backpack placed! \u00a78(Right-click to open)");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!BackpackBlockUtil.isBackpackBlock(block)) {
            return;
        }
        UUID backpackUUID = BackpackBlockUtil.getBackpackUUIDFromBlock(block);
        BackpackTier tier = BackpackBlockUtil.getBackpackTierFromBlock(block);
        if (backpackUUID == null || tier == null) {
            return;
        }
        event.setDropItems(false);
        ItemStack backpackItem = BackpackItem.createBackpack(tier, backpackUUID);
        Location dropLocation = block.getLocation().add(0.5, 0.5, 0.5);
        block.getWorld().dropItemNaturally(dropLocation, backpackItem);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        List blocks = event.blockList();
        blocks.removeIf(BackpackBlockUtil::isBackpackBlock);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        List blocks = event.blockList();
        blocks.removeIf(BackpackBlockUtil::isBackpackBlock);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block = event.getBlock();
        if (BackpackBlockUtil.isBackpackBlock(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!BackpackBlockUtil.isBackpackBlock(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (!BackpackBlockUtil.isBackpackBlock(block)) continue;
            event.setCancelled(true);
            return;
        }
    }
}

