/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.listeners;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerJoinListener
implements Listener {
    private final Plugin plugin;

    public PlayerJoinListener(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String message;
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("give-backpack-on-first-join", false)) {
            return;
        }
        if (player.hasPlayedBefore()) {
            return;
        }
        ItemStack leatherBackpack = BackpackItem.createBackpack(BackpackTier.LEATHER);
        if (!player.getInventory().addItem(new ItemStack[]{leatherBackpack}).isEmpty()) {
            player.getWorld().dropItemNaturally(player.getLocation(), leatherBackpack);
        }
        if ((message = this.plugin.getConfig().getString("starter-backpack-message", "")) != null && !message.trim().isEmpty()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }
}

