/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.util;

import com.shweit.expendablebackpacks.items.BackpackTier;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BackpackBlockUtil {
    private static Plugin plugin;
    private static NamespacedKey BACKPACK_UUID_KEY;
    private static NamespacedKey BACKPACK_TIER_KEY;

    public static void initialize(Plugin pluginInstance) {
        plugin = pluginInstance;
        BACKPACK_UUID_KEY = new NamespacedKey(plugin, "backpack_uuid");
        BACKPACK_TIER_KEY = new NamespacedKey(plugin, "backpack_tier");
    }

    public static boolean isBackpackBlock(Block block) {
        if (block == null || block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD) {
            return false;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Skull)) {
            return false;
        }
        Skull skull = (Skull)blockState;
        PersistentDataContainer pdc = skull.getPersistentDataContainer();
        return pdc.has(BACKPACK_UUID_KEY, PersistentDataType.STRING);
    }

    public static UUID getBackpackUUIDFromBlock(Block block) {
        if (!BackpackBlockUtil.isBackpackBlock(block)) {
            return null;
        }
        Skull skull = (Skull)block.getState();
        PersistentDataContainer pdc = skull.getPersistentDataContainer();
        String uuidString = (String)pdc.get(BACKPACK_UUID_KEY, PersistentDataType.STRING);
        if (uuidString == null) {
            return null;
        }
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static BackpackTier getBackpackTierFromBlock(Block block) {
        if (!BackpackBlockUtil.isBackpackBlock(block)) {
            return null;
        }
        Skull skull = (Skull)block.getState();
        PersistentDataContainer pdc = skull.getPersistentDataContainer();
        Integer level = (Integer)pdc.get(BACKPACK_TIER_KEY, PersistentDataType.INTEGER);
        if (level == null) {
            return null;
        }
        return BackpackTier.fromLevel(level);
    }

    public static boolean setBlockData(Block block, UUID uuid, BackpackTier tier) {
        if (block == null || uuid == null || tier == null) {
            return false;
        }
        if (block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD) {
            return false;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Skull)) {
            return false;
        }
        Skull skull = (Skull)blockState;
        PersistentDataContainer pdc = skull.getPersistentDataContainer();
        pdc.set(BACKPACK_UUID_KEY, PersistentDataType.STRING, (Object)uuid.toString());
        pdc.set(BACKPACK_TIER_KEY, PersistentDataType.INTEGER, (Object)tier.getLevel());
        return skull.update();
    }
}

