/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.items;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.shweit.expendablebackpacks.items.BackpackTier;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BackpackItem {
    private static Plugin plugin;
    private static NamespacedKey BACKPACK_UUID_KEY;
    private static NamespacedKey BACKPACK_TIER_KEY;

    public static void initialize(Plugin pluginInstance) {
        plugin = pluginInstance;
        BACKPACK_UUID_KEY = new NamespacedKey(plugin, "backpack_uuid");
        BACKPACK_TIER_KEY = new NamespacedKey(plugin, "backpack_tier");
    }

    public static ItemStack createBackpack(BackpackTier tier) {
        return BackpackItem.createBackpack(tier, UUID.randomUUID());
    }

    public static ItemStack createBackpack(BackpackTier tier, UUID uuid) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(tier.getDisplayName());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a78" + tier.getRows() + " rows \u2022 " + tier.getSlots() + " slots");
        if (tier.isEnderpack()) {
            lore.add("\u00a75\u00a7oShared Storage");
            lore.add("\u00a77All Enderpacks with the same ID");
            lore.add("\u00a77share the same inventory");
        }
        lore.add("");
        lore.add("\u00a77Right-click to open");
        lore.add("\u00a78ID: " + uuid.toString().substring(0, 8) + "...");
        meta.setLore(lore);
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            String textureValue = tier.getTextureValue();
            if (textureValue != null && !textureValue.startsWith("PLACEHOLDER")) {
                try {
                    PlayerProfile profile = Bukkit.createProfile((UUID)uuid);
                    profile.getProperties().add(new ProfileProperty("textures", textureValue));
                    skullMeta.setPlayerProfile(profile);
                }
                catch (Exception e) {
                    plugin.getLogger().severe("Failed to set texture for " + tier.name() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(BACKPACK_UUID_KEY, PersistentDataType.STRING, (Object)uuid.toString());
        pdc.set(BACKPACK_TIER_KEY, PersistentDataType.INTEGER, (Object)tier.getLevel());
        if (!item.setItemMeta(meta)) {
            plugin.getLogger().warning("Failed to set item meta for backpack " + tier.name());
        }
        return item;
    }

    public static boolean isBackpack(ItemStack item) {
        if (item == null || item.getType() != Material.PLAYER_HEAD) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(BACKPACK_UUID_KEY, PersistentDataType.STRING);
    }

    public static UUID getBackpackUUID(ItemStack item) {
        if (!BackpackItem.isBackpack(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        String uuidString = (String)meta.getPersistentDataContainer().get(BACKPACK_UUID_KEY, PersistentDataType.STRING);
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static BackpackTier getBackpackTier(ItemStack item) {
        if (!BackpackItem.isBackpack(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        Integer level = (Integer)meta.getPersistentDataContainer().get(BACKPACK_TIER_KEY, PersistentDataType.INTEGER);
        if (level == null) {
            return null;
        }
        return BackpackTier.fromLevel(level);
    }

    public static ItemStack cloneBackpack(ItemStack original) {
        if (!BackpackItem.isBackpack(original)) {
            return null;
        }
        UUID uuid = BackpackItem.getBackpackUUID(original);
        BackpackTier tier = BackpackItem.getBackpackTier(original);
        if (uuid == null || tier == null) {
            return null;
        }
        return BackpackItem.createBackpack(tier, uuid);
    }

    public static ItemStack upgradeBackpack(ItemStack original, BackpackTier newTier) {
        if (!BackpackItem.isBackpack(original)) {
            return null;
        }
        UUID uuid = BackpackItem.getBackpackUUID(original);
        if (uuid == null) {
            return null;
        }
        return BackpackItem.createBackpack(newTier, uuid);
    }
}

