/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.items;

import org.bukkit.Material;

public enum BackpackTier {
    DIRT(0, "Dirt Backpack", 9, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWFlNmE5MTFmYTJiOWY0Y2IyYTM2NWVjYThkMGI2MGNjZDFiMGUzYmE0ODA5ZDkzNDUzNzUxODMwOWMxYjRmYyJ9fX0=", Material.DIRT, "\u00a77"),
    LEATHER(1, "Leather Backpack", 9, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDBiMWI1MzY3NDkxODM5MWEwN2E5ZDAwNTgyYzA1OGY5MjgwYmM1MjZhNzE2Yzc5NmVlNWVhYjRiZTEwYTc2MCJ9fX0=", Material.LEATHER, "\u00a77"),
    COPPER(2, "Copper Backpack", 18, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWU1ODNjYjc3MTU4MWQzYjI3YjIzZjYxN2M3YjhhNDNkY2Q3MjIwNDQ3ZmY5NWZmMTk2MDQxNGQyMzUwYmRiOSJ9fX0=", Material.COPPER_INGOT, "\u00a76"),
    IRON(3, "Iron Backpack", 27, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGRhZjhlZGMzMmFmYjQ2MWFlZTA3MTMwNTgwMjMxMDFmOTI0ZTJhN2VmYTg4M2RhZTcyZDVkNTdkNGMwNTNkNyJ9fX0=", Material.IRON_INGOT, "\u00a7f"),
    GOLD(4, "Gold Backpack", 36, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2Y4NzUyNWFkODRlZmQxNjgwNmEyNmNhMDE5ODRiMjgwZTViYTY0MDM1MDViNmY2Yzk4MDNjMjQ2NDJhYmZjNyJ9fX0=", Material.GOLD_INGOT, "\u00a7e"),
    DIAMOND(5, "Diamond Backpack", 45, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTBkMWIwNzMyYmY3YTcwZGU0ZGMwMTU1OWNjNWM5ODExMDY4ZWY3YjYwOTUwMTAzODI3MDlmOTQwOTM5MjdmNiJ9fX0=", Material.DIAMOND, "\u00a7b"),
    NETHERITE(6, "Netherite Backpack", 54, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODM1ZDdjYzA5ZmZmYmNhM2UxYzAwZDQyMWFmYWE0MzJjZjcxZmNiMDk1NTVmNTQ1MjNlNTIyMGQxYWYwZjk3ZCJ9fX0=", Material.NETHERITE_INGOT, "\u00a78"),
    ENDERPACK(7, "Enderpack", 27, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGQ1OWY0ZGRiYjJhMDk0YzFkYTc2NTRjMWViZjlkODUxNWEyYjc1YTIyMGZkNzNhNjUxMzUwNzJlMzhkNGY2MCJ9fX0=", Material.ENDER_PEARL, "\u00a75");

    private final int level;
    private final String displayName;
    private final int slots;
    private final String textureValue;
    private final Material upgradeMaterial;
    private final String colorCode;

    private BackpackTier(int level, String displayName, int slots, String textureValue, Material upgradeMaterial, String colorCode) {
        this.level = level;
        this.displayName = displayName;
        this.slots = slots;
        this.textureValue = textureValue;
        this.upgradeMaterial = upgradeMaterial;
        this.colorCode = colorCode;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDisplayName() {
        return this.colorCode + this.displayName;
    }

    public String getRawDisplayName() {
        return this.displayName;
    }

    public int getSlots() {
        return this.slots;
    }

    public int getRows() {
        return this.slots / 9;
    }

    public String getTextureValue() {
        return this.textureValue;
    }

    public Material getUpgradeMaterial() {
        return this.upgradeMaterial;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public static BackpackTier fromLevel(int level) {
        for (BackpackTier tier : BackpackTier.values()) {
            if (tier.level != level) continue;
            return tier;
        }
        return null;
    }

    public static BackpackTier fromName(String name) {
        for (BackpackTier tier : BackpackTier.values()) {
            if (!tier.name().equalsIgnoreCase(name) && !tier.displayName.equalsIgnoreCase(name)) continue;
            return tier;
        }
        return null;
    }

    public boolean hasNextTier() {
        return this.level < BackpackTier.NETHERITE.level;
    }

    public BackpackTier getNextTier() {
        if (this.level >= BackpackTier.NETHERITE.level) {
            return null;
        }
        return BackpackTier.fromLevel(this.level + 1);
    }

    public boolean isEnderpack() {
        return this == ENDERPACK;
    }
}

