/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.listeners;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import com.shweit.expendablebackpacks.storage.BackpackManager;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BackpackCraftingListener
implements Listener {
    private final BackpackManager backpackManager;
    private final Plugin plugin;

    public BackpackCraftingListener(BackpackManager backpackManager, Plugin plugin) {
        this.backpackManager = backpackManager;
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCraft(PrepareItemCraftEvent event) {
        CraftingInventory inv = event.getInventory();
        ItemStack[] matrix = inv.getMatrix();
        if (matrix == null) {
            return;
        }
        ItemStack enderpack = null;
        boolean hasEnderPearl = false;
        int totalItems = 0;
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (item == null || item.getType() == Material.AIR) continue;
            ++totalItems;
            if (BackpackItem.isBackpack(item)) {
                BackpackTier tier = BackpackItem.getBackpackTier(item);
                if (tier == BackpackTier.ENDERPACK && item.getAmount() == 1) {
                    enderpack = item;
                    continue;
                }
                enderpack = null;
                break;
            }
            if (item.getType() == Material.ENDER_PEARL && item.getAmount() == 1) {
                hasEnderPearl = true;
                continue;
            }
            enderpack = null;
            break;
        }
        if (enderpack != null && hasEnderPearl && totalItems == 2) {
            ItemStack clonedEnderpack = BackpackItem.cloneBackpack(enderpack);
            if (clonedEnderpack != null) {
                clonedEnderpack.setAmount(2);
                inv.setResult(clonedEnderpack);
            }
            return;
        }
        if (matrix.length != 9) {
            return;
        }
        if (this.isEnderpackPattern(matrix)) {
            inv.setResult(BackpackItem.createBackpack(BackpackTier.ENDERPACK));
            return;
        }
        ItemStack center = matrix[4];
        if (!BackpackItem.isBackpack(center)) {
            return;
        }
        BackpackTier currentTier = BackpackItem.getBackpackTier(center);
        if (currentTier == null) {
            return;
        }
        Material surrounding = this.getSurroundingMaterial(matrix);
        if (surrounding == null) {
            return;
        }
        BackpackTier targetTier = null;
        if (surrounding == Material.DIRT && currentTier == BackpackTier.LEATHER) {
            targetTier = BackpackTier.DIRT;
        } else if (surrounding == Material.COPPER_INGOT && currentTier == BackpackTier.LEATHER) {
            targetTier = BackpackTier.COPPER;
        } else if (surrounding == Material.IRON_INGOT && currentTier == BackpackTier.COPPER) {
            targetTier = BackpackTier.IRON;
        } else if (surrounding == Material.GOLD_INGOT && currentTier == BackpackTier.IRON) {
            targetTier = BackpackTier.GOLD;
        } else if (surrounding == Material.DIAMOND && currentTier == BackpackTier.GOLD) {
            targetTier = BackpackTier.DIAMOND;
        }
        if (targetTier != null) {
            ItemStack upgraded = BackpackItem.upgradeBackpack(center, targetTier);
            inv.setResult(upgraded);
        }
    }

    private boolean isEnderpackPattern(ItemStack[] matrix) {
        return this.isMaterial(matrix[0], Material.ENDER_EYE) && this.isMaterial(matrix[1], Material.ENDER_PEARL) && this.isMaterial(matrix[2], Material.ENDER_EYE) && this.isMaterial(matrix[3], Material.ENDER_PEARL) && this.isMaterial(matrix[4], Material.CHEST) && this.isMaterial(matrix[5], Material.ENDER_PEARL) && this.isMaterial(matrix[6], Material.ENDER_EYE) && this.isMaterial(matrix[7], Material.IRON_BLOCK) && this.isMaterial(matrix[8], Material.ENDER_EYE);
    }

    private Material getSurroundingMaterial(ItemStack[] matrix) {
        int[] surrounding = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
        Material material = null;
        for (int i : surrounding) {
            ItemStack item = matrix[i];
            if (item == null || item.getType() == Material.AIR) {
                return null;
            }
            if (material == null) {
                material = item.getType();
                continue;
            }
            if (item.getType() == material) continue;
            return null;
        }
        return material;
    }

    private boolean isMaterial(ItemStack item, Material material) {
        return item != null && item.getType() == material;
    }
}

