/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.listeners;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import com.shweit.expendablebackpacks.storage.BackpackManager;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BackpackInteractionListener
implements Listener {
    private final BackpackManager backpackManager;

    public BackpackInteractionListener(BackpackManager backpackManager) {
        this.backpackManager = backpackManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (!BackpackItem.isBackpack(item)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        UUID backpackUUID = BackpackItem.getBackpackUUID(item);
        BackpackTier tier = BackpackItem.getBackpackTier(item);
        if (backpackUUID == null || tier == null) {
            player.sendMessage("\u00a7cError: Invalid backpack data!");
            return;
        }
        String title = tier.getDisplayName();
        Inventory inventory = this.backpackManager.getInventory(backpackUUID, title, tier.getSlots());
        player.openInventory(inventory);
        if (tier.isEnderpack()) {
            player.sendMessage("\u00a75\u00a7lEnderpack \u00a77opened! All Enderpacks with this ID share storage.");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inv = event.getInventory();
        String title = event.getView().getTitle();
        boolean isBackpack = false;
        for (BackpackTier tier : BackpackTier.values()) {
            if (!title.equals(tier.getDisplayName())) continue;
            isBackpack = true;
            break;
        }
        if (!isBackpack) {
            return;
        }
        UUID backpackUUID = this.findBackpackUUID(inv);
        if (backpackUUID != null) {
            this.backpackManager.saveInventory(backpackUUID, inv);
        }
    }

    private UUID findBackpackUUID(Inventory inventory) {
        for (BackpackTier backpackTier : BackpackTier.values()) {
        }
        return null;
    }
}

