/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.listeners;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import com.shweit.expendablebackpacks.storage.BackpackManager;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;

public class BackpackSmithingListener
implements Listener {
    private final BackpackManager backpackManager;

    public BackpackSmithingListener(BackpackManager backpackManager) {
        this.backpackManager = backpackManager;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareSmithing(PrepareSmithingEvent event) {
        SmithingInventory inv = event.getInventory();
        ItemStack template = inv.getItem(0);
        ItemStack base = inv.getItem(1);
        if (!BackpackItem.isBackpack(base)) {
            return;
        }
        BackpackTier currentTier = BackpackItem.getBackpackTier(base);
        if (currentTier == null || currentTier != BackpackTier.DIAMOND) {
            return;
        }
        if (template == null || template.getType() != Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE) {
            return;
        }
        ItemStack addition = inv.getItem(2);
        if (addition == null || addition.getType() != Material.NETHERITE_INGOT) {
            return;
        }
        ItemStack upgraded = BackpackItem.upgradeBackpack(base, BackpackTier.NETHERITE);
        event.setResult(upgraded);
    }
}

