/*
 * Decompiled with CFR 0.152.
 */
package com.mekanismbiggerteleporters.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketPortalAreaFX(BlockPos minPos, BlockPos maxPos, int particlesPerBlock, Direction portalDirection) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketPortalAreaFX> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mekanismbiggerteleporters", (String)"portal_area_fx"));
    public static final StreamCodec<ByteBuf, PacketPortalAreaFX> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketPortalAreaFX::minPos, (StreamCodec)BlockPos.STREAM_CODEC, PacketPortalAreaFX::maxPos, (StreamCodec)ByteBufCodecs.VAR_INT, PacketPortalAreaFX::particlesPerBlock, (StreamCodec)Direction.STREAM_CODEC, PacketPortalAreaFX::portalDirection, PacketPortalAreaFX::new);

    @NotNull
    public CustomPacketPayload.Type<PacketPortalAreaFX> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Level world = context.player().level();
        int xRange = this.maxPos.getX() - this.minPos.getX();
        int yRange = this.maxPos.getY() - this.minPos.getY();
        int zRange = this.maxPos.getZ() - this.minPos.getZ();
        Direction.Axis depthAxis = xRange <= yRange && xRange <= zRange ? Direction.Axis.X : (yRange <= xRange && yRange <= zRange ? Direction.Axis.Y : Direction.Axis.Z);
        if (depthAxis == Direction.Axis.Z) {
            int fixedZ = this.minPos.getZ();
            for (int x = this.minPos.getX(); x < this.maxPos.getX(); ++x) {
                for (int y = this.minPos.getY(); y < this.maxPos.getY(); ++y) {
                    this.spawnParticlesAt(world, (double)x + 0.5, (double)y + 0.5, (double)fixedZ + 0.5, depthAxis);
                }
            }
        } else if (depthAxis == Direction.Axis.X) {
            int fixedX = this.minPos.getX();
            for (int y = this.minPos.getY(); y < this.maxPos.getY(); ++y) {
                for (int z = this.minPos.getZ(); z < this.maxPos.getZ(); ++z) {
                    this.spawnParticlesAt(world, (double)fixedX + 0.5, (double)y + 0.5, (double)z + 0.5, depthAxis);
                }
            }
        } else {
            int fixedY = this.minPos.getY();
            for (int x = this.minPos.getX(); x < this.maxPos.getX(); ++x) {
                for (int z = this.minPos.getZ(); z < this.maxPos.getZ(); ++z) {
                    this.spawnParticlesAt(world, (double)x + 0.5, (double)fixedY + 0.5, (double)z + 0.5, depthAxis);
                }
            }
        }
    }

    private int spawnParticlesAt(Level world, double centerX, double centerY, double centerZ, Direction.Axis depthAxis) {
        for (int i = 0; i < this.particlesPerBlock; ++i) {
            if (!(world.random.nextDouble() < 0.5)) continue;
            double offsetX = world.random.nextDouble() * 1.5 - 0.25;
            double offsetY = world.random.nextDouble() * 1.5 - 0.25;
            double offsetZ = world.random.nextDouble() * 1.5 - 0.25;
            if (depthAxis == Direction.Axis.X) {
                offsetX *= 0.5;
            } else if (depthAxis == Direction.Axis.Y) {
                offsetY *= 0.5;
            } else if (depthAxis == Direction.Axis.Z) {
                offsetZ *= 0.5;
            }
            double velocityX = (world.random.nextDouble() - 0.5) * 0.05;
            double velocityY = (world.random.nextDouble() - 0.5) * 0.05;
            double velocityZ = (world.random.nextDouble() - 0.5) * 0.05;
            world.addParticle((ParticleOptions)ParticleTypes.PORTAL, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, velocityX, velocityY, velocityZ);
        }
        return this.particlesPerBlock;
    }
}

