/*
 * Decompiled with CFR 0.152.
 */
package com.mekanismbiggerteleporters.mixin;

import com.mekanismbiggerteleporters.util.BiggerTeleporterUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.SupportsColorMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderTeleporter.class}, remap=false)
@NothingNullByDefault
public class RenderTeleporterMixin {
    @Unique
    private static final Map<String, MekanismRenderer.Model3D> extendedModelCache = new HashMap<String, MekanismRenderer.Model3D>();

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderExtendedPortal(TileEntityTeleporter tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler, CallbackInfo ci) {
        try {
            int width = BiggerTeleporterUtil.getFrameWidth(tile);
            int height = BiggerTeleporterUtil.getFrameHeight(tile);
            if (width == 3 && height == 4) {
                return;
            }
            MekanismRenderer.Model3D model = this.getExtendedOverlayModel(tile.frameDirection(), tile.frameRotated(), width, height);
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)model, (PoseStack)matrix, (VertexConsumer)renderer.getBuffer(Sheets.translucentCullBlockSheet()), (int)MekanismRenderer.getColorARGB((SupportsColorMap)tile.getColor(), (float)0.75f), (int)0xF000F0, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)this.getCamera(), (BlockPos)tile.getBlockPos());
            ci.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Unique
    private MekanismRenderer.Model3D getExtendedOverlayModel(@Nullable Direction direction, boolean rotated, int width, int height) {
        String cacheKey;
        MekanismRenderer.Model3D model;
        if (direction == null) {
            direction = Direction.UP;
        }
        if ((model = extendedModelCache.get(cacheKey = String.valueOf(direction) + "_" + rotated + "_" + width + "_" + height)) == null) {
            float depthMax;
            float depthMin;
            model = new MekanismRenderer.Model3D().setTexture(MekanismRenderer.teleporterPortal);
            Direction.Axis renderAxis = direction.getAxis().isHorizontal() ? Direction.Axis.Y : (rotated ? Direction.Axis.X : Direction.Axis.Z);
            for (Direction side : Direction.values()) {
                model.setSideRender(direction, side.getAxis() == renderAxis);
            }
            float halfWidth = (float)(width - 1) / 2.0f;
            float depth = height - 2;
            float frameOffset = 0.01f;
            if (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                depthMin = 1.0f + frameOffset;
                depthMax = 1.0f + depth + frameOffset;
            } else {
                depthMin = -1.0f - depth - frameOffset;
                depthMax = -1.0f - frameOffset;
            }
            float widthMin = -halfWidth + 1.0f + frameOffset;
            float widthMax = halfWidth + frameOffset;
            float portalThicknessMin = 0.46f;
            float portalThicknessMax = 0.54f;
            switch (direction.getAxis()) {
                case X: {
                    model.xBounds(depthMin, depthMax);
                    if (rotated) {
                        model.yBounds(widthMin, widthMax);
                        model.zBounds(portalThicknessMin, portalThicknessMax);
                        break;
                    }
                    model.yBounds(portalThicknessMin, portalThicknessMax);
                    model.zBounds(widthMin, widthMax);
                    break;
                }
                case Y: {
                    model.yBounds(depthMin, depthMax);
                    if (rotated) {
                        model.xBounds(portalThicknessMin, portalThicknessMax);
                        model.zBounds(widthMin, widthMax);
                        break;
                    }
                    model.xBounds(widthMin, widthMax);
                    model.zBounds(portalThicknessMin, portalThicknessMax);
                    break;
                }
                case Z: {
                    model.zBounds(depthMin, depthMax);
                    if (rotated) {
                        model.xBounds(portalThicknessMin, portalThicknessMax);
                        model.yBounds(widthMin, widthMax);
                        break;
                    }
                    model.xBounds(widthMin, widthMax);
                    model.yBounds(portalThicknessMin, portalThicknessMax);
                }
            }
            extendedModelCache.put(cacheKey, model);
        }
        return model;
    }

    @Unique
    private Camera getCamera() {
        try {
            Field field = RenderTeleporter.class.getSuperclass().getDeclaredField("camera");
            field.setAccessible(true);
            return (Camera)field.get(this);
        }
        catch (Exception e) {
            return Minecraft.getInstance().gameRenderer.getMainCamera();
        }
    }

    @Inject(method={"resetCachedModels"}, at={@At(value="RETURN")})
    private static void clearExtendedCache(CallbackInfo ci) {
        extendedModelCache.clear();
    }
}

