/*
 * Decompiled with CFR 0.152.
 */
package com.mekanismbiggerteleporters.mixin;

import com.mekanismbiggerteleporters.network.PacketPortalAreaFX;
import com.mekanismbiggerteleporters.util.BiggerTeleporterUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEntityTeleporter.class}, remap=false)
public abstract class TeleporterMixin
extends TileEntityMekanism {
    @Shadow
    private boolean frameRotated;
    @Unique
    private int cachedFrameWidth = -1;
    @Unique
    private int cachedFrameHeight = -1;
    @Unique
    private int lastCheckTick = 0;

    public TeleporterMixin(BlockPos pos, BlockState state) {
        super(null, pos, state);
    }

    @Shadow
    protected abstract boolean isFrame(Long2ObjectMap<ChunkAccess> var1, BlockPos.MutableBlockPos var2, Object2BooleanMap<BlockPos> var3, int var4, int var5, int var6);

    @Shadow
    public abstract AABB getTeleporterBoundingBox(@NotNull Direction var1);

    @Unique
    @Nullable
    private static Direction calculateTeleporterNormalDirection(AABB box, BlockPos target) {
        double X = box.maxX - box.minX;
        double Y = box.maxY - box.minY;
        double Z = box.maxZ - box.minZ;
        Direction normalDir = null;
        if (Z < X && Z < Y) {
            normalDir = (double)target.getZ() > box.minZ + Z / 2.0 ? Direction.SOUTH : Direction.NORTH;
        } else if (X < Y && X < Z) {
            normalDir = (double)target.getX() > box.minX + X / 2.0 ? Direction.EAST : Direction.WEST;
        } else if (Y < X && Y < Z) {
            normalDir = (double)target.getY() > box.minY + Y / 2.0 ? Direction.UP : Direction.DOWN;
        }
        return normalDir;
    }

    @Inject(method={"alignPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void alignPlayerForBiggerPortals(ServerPlayer player, BlockPos target, TileEntityTeleporter teleporter, CallbackInfoReturnable<Float> cir) {
        float yaw;
        Direction normal;
        AABB box;
        Direction side = null;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Level level = teleporter.getLevel();
        Direction frameDir = teleporter.frameDirection();
        if (frameDir == null) {
            return;
        }
        if (level != null && (box = teleporter.getTeleporterBoundingBox(frameDir)) != null && (normal = TeleporterMixin.calculateTeleporterNormalDirection(box, target)) != null) {
            mutable.setWithOffset((Vec3i)target, normal.getStepX(), normal.getStepY(), normal.getStepZ());
            if (level.isEmptyBlock((BlockPos)mutable)) {
                side = normal;
            } else {
                Direction opposite = normal.getOpposite();
                mutable.setWithOffset((Vec3i)target, opposite.getStepX(), opposite.getStepY(), opposite.getStepZ());
                if (level.isEmptyBlock((BlockPos)mutable)) {
                    side = opposite;
                }
            }
        }
        if (side == null) {
            yaw = player.getYRot();
        } else {
            yaw = switch (side) {
                case Direction.NORTH -> 180.0f;
                case Direction.SOUTH -> 0.0f;
                case Direction.WEST -> 90.0f;
                case Direction.EAST -> 270.0f;
                default -> player.getYRot();
            };
        }
        cir.setReturnValue((Object)Float.valueOf(yaw));
    }

    @Inject(method={"getFrameDirection"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExtendedFrameDirection(CallbackInfoReturnable<Direction> cir) {
        Long2ObjectArrayMap chunkMap = new Long2ObjectArrayMap(3);
        Object2BooleanOpenHashMap cachedIsFrame = new Object2BooleanOpenHashMap();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            for (int width = 3; width <= 23; width += 2) {
                for (int height = 4; height <= 23; ++height) {
                    if (this.hasRectangularFrame((Long2ObjectMap<ChunkAccess>)chunkMap, pos, (Object2BooleanMap<BlockPos>)cachedIsFrame, direction, false, width, height)) {
                        this.frameRotated = false;
                        this.cachedFrameWidth = width;
                        this.cachedFrameHeight = height;
                        cir.setReturnValue((Object)direction);
                        return;
                    }
                    if (!this.hasRectangularFrame((Long2ObjectMap<ChunkAccess>)chunkMap, pos, (Object2BooleanMap<BlockPos>)cachedIsFrame, direction, true, width, height)) continue;
                    this.frameRotated = true;
                    this.cachedFrameWidth = width;
                    this.cachedFrameHeight = height;
                    cir.setReturnValue((Object)direction);
                    return;
                }
            }
            chunkMap.clear();
            cachedIsFrame.clear();
        }
        cir.setReturnValue(null);
    }

    @Unique
    private boolean hasRectangularFrame(Long2ObjectMap<ChunkAccess> chunkMap, BlockPos.MutableBlockPos pos, Object2BooleanMap<BlockPos> cachedIsFrame, Direction direction, boolean rotated, int width, int height) {
        int alternatingX = 0;
        int alternatingY = 0;
        int alternatingZ = 0;
        if (rotated) {
            if (direction.getAxis() == Direction.Axis.Z) {
                alternatingX = 1;
            } else {
                alternatingZ = 1;
            }
        } else if (direction.getAxis() == Direction.Axis.Y) {
            alternatingX = 1;
        } else {
            alternatingY = 1;
        }
        int xComp = direction.getStepX();
        int yComp = direction.getStepY();
        int zComp = direction.getStepZ();
        int halfWidth = width / 2;
        int depth = height - 1;
        for (int d = 0; d <= depth; ++d) {
            int w;
            int xBase = d * xComp;
            int yBase = d * yComp;
            int zBase = d * zComp;
            if (d == 0) {
                for (w = -halfWidth; w <= halfWidth; ++w) {
                    if (w == 0 || this.isFrame(chunkMap, pos, cachedIsFrame, xBase + w * alternatingX, yBase + w * alternatingY, zBase + w * alternatingZ)) continue;
                    return false;
                }
                continue;
            }
            if (d == depth) {
                for (w = -halfWidth; w <= halfWidth; ++w) {
                    if (this.isFrame(chunkMap, pos, cachedIsFrame, xBase + w * alternatingX, yBase + w * alternatingY, zBase + w * alternatingZ)) continue;
                    return false;
                }
                continue;
            }
            if (!this.isFrame(chunkMap, pos, cachedIsFrame, xBase - halfWidth * alternatingX, yBase - halfWidth * alternatingY, zBase - halfWidth * alternatingZ)) {
                return false;
            }
            if (this.isFrame(chunkMap, pos, cachedIsFrame, xBase + halfWidth * alternatingX, yBase + halfWidth * alternatingY, zBase + halfWidth * alternatingZ)) continue;
            return false;
        }
        return true;
    }

    @Inject(method={"getTeleporterBoundingBox"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExtendedBoundingBox(@NotNull Direction frameDirection, CallbackInfoReturnable<AABB> cir) {
        this.detectCurrentSizeCached(frameDirection);
        int alternatingX = 0;
        int alternatingY = 0;
        int alternatingZ = 0;
        if (this.frameRotated) {
            if (frameDirection.getAxis() == Direction.Axis.Z) {
                alternatingX = 1;
            } else {
                alternatingZ = 1;
            }
        } else if (frameDirection.getAxis() == Direction.Axis.Y) {
            alternatingX = 1;
        } else {
            alternatingY = 1;
        }
        int halfWidth = this.cachedFrameWidth / 2;
        int depth = this.cachedFrameHeight - 1;
        BlockPos start = this.worldPosition.relative(frameDirection, 1);
        int widthOffset = halfWidth - 1;
        if (widthOffset < 1) {
            widthOffset = 1;
        }
        BlockPos corner1 = start.offset(-widthOffset * alternatingX, -widthOffset * alternatingY, -widthOffset * alternatingZ);
        BlockPos end = this.worldPosition.relative(frameDirection, depth - 1);
        if (depth < 2) {
            end = this.worldPosition.relative(frameDirection, 2);
        }
        BlockPos corner2 = end.offset(widthOffset * alternatingX, widthOffset * alternatingY, widthOffset * alternatingZ);
        AABB boundingBox = AABB.encapsulatingFullBlocks((BlockPos)corner1, (BlockPos)corner2);
        cir.setReturnValue((Object)boundingBox);
    }

    @Unique
    private void detectCurrentSizeCached(Direction direction) {
        int currentTick;
        int n = currentTick = this.level != null ? (int)this.level.getGameTime() : 0;
        if (this.cachedFrameWidth == -1 || currentTick - this.lastCheckTick > 20) {
            this.detectCurrentSize(direction);
            this.lastCheckTick = currentTick;
        }
    }

    @Unique
    private void detectCurrentSize(Direction direction) {
        Long2ObjectArrayMap chunkMap = new Long2ObjectArrayMap(3);
        Object2BooleanOpenHashMap cachedIsFrame = new Object2BooleanOpenHashMap();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int width = 23; width >= 3; width -= 2) {
            for (int height = 23; height >= 4; --height) {
                if (!this.hasRectangularFrame((Long2ObjectMap<ChunkAccess>)chunkMap, pos, (Object2BooleanMap<BlockPos>)cachedIsFrame, direction, this.frameRotated, width, height)) continue;
                this.cachedFrameWidth = width;
                this.cachedFrameHeight = height;
                return;
            }
        }
        this.cachedFrameWidth = 3;
        this.cachedFrameHeight = 4;
    }

    @Inject(method={"sendTeleportParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendExtendedParticles(CallbackInfo ci) {
        try {
            TileEntityTeleporter tile = (TileEntityTeleporter)this;
            Direction frameDirection = tile.frameDirection();
            if (frameDirection == null || tile.getLevel() == null) {
                return;
            }
            this.detectCurrentSizeCached(frameDirection);
            int width = this.cachedFrameWidth;
            int height = this.cachedFrameHeight;
            if (width == 3 && height == 4) {
                return;
            }
            ci.cancel();
            AABB box = this.getTeleporterBoundingBox(frameDirection);
            int particlesCount = BiggerTeleporterUtil.getParticlesCount(tile, box);
            BlockPos minPos = new BlockPos((int)Math.floor(box.minX), (int)Math.floor(box.minY), (int)Math.floor(box.minZ));
            BlockPos maxPos = new BlockPos((int)Math.ceil(box.maxX), (int)Math.ceil(box.maxY), (int)Math.ceil(box.maxZ));
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)tile.getLevel()), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new PacketPortalAreaFX(minPos, maxPos, particlesCount, tile.frameDirection()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

