/*
 * Decompiled with CFR 0.152.
 */
package com.mekanismbiggerteleporters.util;

import java.lang.reflect.Field;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.phys.AABB;

public class BiggerTeleporterUtil {
    public static final int MAX_PARTICLES_TOTAL = 8192;
    public static final int MAX_PARTICLES_PER_BLOCK = 30;

    public static int getFrameWidth(TileEntityTeleporter tile) {
        try {
            Field field = tile.getClass().getDeclaredField("cachedFrameWidth");
            field.setAccessible(true);
            int width = field.getInt(tile);
            return width > 0 ? width : 3;
        }
        catch (Exception e) {
            return 3;
        }
    }

    public static int getFrameHeight(TileEntityTeleporter tile) {
        try {
            Field field = tile.getClass().getDeclaredField("cachedFrameHeight");
            field.setAccessible(true);
            int height = field.getInt(tile);
            return height > 0 ? height : 4;
        }
        catch (Exception e) {
            return 4;
        }
    }

    public static double calculateTeleportersDistance(TileEntityTeleporter tile) {
        TeleporterFrequency frequency = (TeleporterFrequency)tile.getFrequencyComponent().getFrequency(FrequencyType.TELEPORTER);
        if (frequency == null) {
            return -1.0;
        }
        GlobalPos tilePos = GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos());
        GlobalPos targetTeleporter = frequency.getClosestCoords(tilePos);
        if (!tilePos.dimension().equals(targetTeleporter.dimension())) {
            return -1.0;
        }
        BlockPos thisTeleporterPos = tilePos.pos();
        BlockPos targetTeleporterPos = targetTeleporter.pos();
        double dx = targetTeleporterPos.getX() - thisTeleporterPos.getX();
        double dy = targetTeleporterPos.getY() - thisTeleporterPos.getY();
        double dz = targetTeleporterPos.getZ() - thisTeleporterPos.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static int calculatePortalArea(AABB box) {
        int sizeX = (int)Math.ceil(box.maxX - box.minX);
        int sizeY = (int)Math.ceil(box.maxY - box.minY);
        int sizeZ = (int)Math.ceil(box.maxZ - box.minZ);
        return Math.max(Math.max(sizeX * sizeY, sizeX * sizeZ), sizeY * sizeZ);
    }

    public static int getParticlesCount(TileEntityTeleporter tile, AABB box) {
        int portalArea = BiggerTeleporterUtil.calculatePortalArea(box);
        double teleportersDistance = BiggerTeleporterUtil.calculateTeleportersDistance(tile);
        int particlesPerBlock = 8192 / portalArea;
        if (teleportersDistance > 0.0 && teleportersDistance <= 32.0) {
            particlesPerBlock = (int)((double)particlesPerBlock * 0.75);
        }
        return Math.max(1, Math.min(particlesPerBlock, 30));
    }
}

