/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.advancement.criterion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.criterion.BattleCountableContext;
import com.cobblemon.mod.common.advancement.criterion.BattleCountableCriterion;
import com.cobblemon.mod.common.advancement.criterion.CountableContext;
import com.cobblemon.mod.common.advancement.criterion.CountableCriterion;
import com.cobblemon.mod.common.api.storage.player.PlayerAdvancementData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B+\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableCriterion;", "Lcom/cobblemon/mod/common/advancement/criterion/CountableCriterion;", "Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableContext;", "Ljava/util/Optional;", "Lnet/minecraft/advancements/critereon/ContextAwarePredicate;", "playerCtx", "", "", "battleTypes", "", "count", "<init>", "(Ljava/util/Optional;Ljava/util/List;I)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "context", "", "matches", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableContext;)Z", "Ljava/util/List;", "getBattleTypes", "()Ljava/util/List;", "Companion", "common"})
public final class BattleCountableCriterion
extends CountableCriterion<BattleCountableContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> battleTypes;
    @NotNull
    private static final Codec<BattleCountableCriterion> CODEC;

    public BattleCountableCriterion(@NotNull Optional<ContextAwarePredicate> playerCtx, @NotNull List<String> battleTypes, int count) {
        Intrinsics.checkNotNullParameter(playerCtx, (String)"playerCtx");
        Intrinsics.checkNotNullParameter(battleTypes, (String)"battleTypes");
        super(playerCtx, count);
        this.battleTypes = battleTypes;
    }

    @NotNull
    public final List<String> getBattleTypes() {
        return this.battleTypes;
    }

    @Override
    public boolean matches(@NotNull ServerPlayer player, @NotNull BattleCountableContext context) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean typeCheck = false;
        PlayerAdvancementData advancementData = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player).getAdvancementData();
        if (this.battleTypes.isEmpty() || this.battleTypes.contains("any")) {
            typeCheck = true;
        }
        if (this.battleTypes.contains("pvp")) {
            typeCheck = context.getBattle().isPvP();
            context.setTimes(advancementData.getTotalPvPBattleVictoryCount());
        }
        if (this.battleTypes.contains("pvw")) {
            typeCheck = context.getBattle().isPvW();
            context.setTimes(advancementData.getTotalPvWBattleVictoryCount());
        }
        if (this.battleTypes.contains("pvn")) {
            typeCheck = context.getBattle().isPvN();
            context.setTimes(advancementData.getTotalPvWBattleVictoryCount());
        }
        if (this.battleTypes.size() > 1) {
            context.setTimes(advancementData.getTotalBattleVictoryCount());
        }
        return typeCheck && super.matches(player, (CountableContext)context);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(arg_0 -> BattleCountableCriterion.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.STRING.listOf().optionalFieldOf("battle_types", (Object)CollectionsKt.listOf((Object)"any")).forGetter(arg_0 -> BattleCountableCriterion.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("count", (Object)0).forGetter(arg_0 -> BattleCountableCriterion.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)it, BattleCountableCriterion::new);
    }

    private static final Optional CODEC$lambda$0$0(KProperty1 $tmp0, BattleCountableCriterion p0) {
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List CODEC$lambda$0$1(KProperty1 $tmp0, BattleCountableCriterion p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$0$2(KProperty1 $tmp0, BattleCountableCriterion p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        Codec codec = RecordCodecBuilder.create(BattleCountableCriterion::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableCriterion$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableCriterion;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<BattleCountableCriterion> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

