/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.advancement.criterion;

import com.cobblemon.mod.common.advancement.criterion.RidingStatBoostContext;
import com.cobblemon.mod.common.advancement.criterion.SimpleCriterionCondition;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB7\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0014\u001a\u0004\b\f\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/RidingStatBoostCriterion;", "Lcom/cobblemon/mod/common/advancement/criterion/SimpleCriterionCondition;", "Lcom/cobblemon/mod/common/advancement/criterion/RidingStatBoostContext;", "Ljava/util/Optional;", "Lnet/minecraft/advancements/critereon/ContextAwarePredicate;", "playerCtx", "", "requiresOwner", "", "rideStat", "", "statValue", "isMax", "<init>", "(Ljava/util/Optional;ZLjava/lang/String;DZ)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "context", "matches", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/advancement/criterion/RidingStatBoostContext;)Z", "Z", "getRequiresOwner", "()Z", "Ljava/lang/String;", "getRideStat", "()Ljava/lang/String;", "D", "getStatValue", "()D", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nRidingStatBoostCriterion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RidingStatBoostCriterion.kt\ncom/cobblemon/mod/common/advancement/criterion/RidingStatBoostCriterion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1869#2:64\n1869#2,2:65\n1870#2:67\n*S KotlinDebug\n*F\n+ 1 RidingStatBoostCriterion.kt\ncom/cobblemon/mod/common/advancement/criterion/RidingStatBoostCriterion\n*L\n45#1:64\n46#1:65,2\n45#1:67\n*E\n"})
public final class RidingStatBoostCriterion
extends SimpleCriterionCondition<RidingStatBoostContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean requiresOwner;
    @NotNull
    private final String rideStat;
    private final double statValue;
    private final boolean isMax;
    @NotNull
    private static final Lazy<Codec<RidingStatBoostCriterion>> CODEC$delegate = LazyKt.lazy(RidingStatBoostCriterion::CODEC_delegate$lambda$0);

    public RidingStatBoostCriterion(@NotNull Optional<ContextAwarePredicate> playerCtx, boolean requiresOwner, @NotNull String rideStat, double statValue, boolean isMax) {
        Intrinsics.checkNotNullParameter(playerCtx, (String)"playerCtx");
        Intrinsics.checkNotNullParameter((Object)rideStat, (String)"rideStat");
        super(playerCtx);
        this.requiresOwner = requiresOwner;
        this.rideStat = rideStat;
        this.statValue = statValue;
        this.isMax = isMax;
    }

    public /* synthetic */ RidingStatBoostCriterion(Optional optional, boolean bl, String string, double d, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(optional, bl, string, d, bl2);
    }

    public final boolean getRequiresOwner() {
        return this.requiresOwner;
    }

    @NotNull
    public final String getRideStat() {
        return this.rideStat;
    }

    public final double getStatValue() {
        return this.statValue;
    }

    public final boolean isMax() {
        return this.isMax;
    }

    @Override
    public boolean matches(@NotNull ServerPlayer player, @NotNull RidingStatBoostContext context) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.requiresOwner && !Intrinsics.areEqual((Object)context.getPokemon().getOwnerUUID(), (Object)player.getUUID())) {
            return false;
        }
        Iterable $this$forEach$iv = (Iterable)RidingStyle.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RidingStyle ridingStyle = (RidingStyle)((Object)element$iv);
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)RidingStat.getEntries();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean isSufficient;
                RidingStat rideStat = (RidingStat)((Object)element$iv2);
                boolean bl2 = false;
                if (!StringsKt.equals((String)rideStat.name(), (String)this.rideStat, (boolean)true) && !Intrinsics.areEqual((Object)this.rideStat, (Object)"any") && !Intrinsics.areEqual((Object)this.rideStat, (Object)"all")) continue;
                double max = context.getPokemon().getPokemon().getMaxRideBoost(rideStat);
                double min = context.getPokemon().getPokemon().getBaseRideStat(rideStat);
                double value = context.getPokemon().getRideStat(rideStat, ridingStyle, min, max);
                boolean bl3 = isSufficient = value >= this.statValue && this.statValue > 0.0 || !context.getPokemon().getPokemon().canAddRideBoost(rideStat);
                if (isSufficient && Intrinsics.areEqual((Object)this.rideStat, (Object)"any")) {
                    return true;
                }
                if (isSufficient || !Intrinsics.areEqual((Object)this.rideStat, (Object)"all")) continue;
                return false;
            }
        }
        return Intrinsics.areEqual((Object)this.rideStat, (Object)"all");
    }

    private static final Codec CODEC_delegate$lambda$0() {
        return RecordCodecBuilder.create(RidingStatBoostCriterion::CODEC_delegate$lambda$0$0);
    }

    private static final App CODEC_delegate$lambda$0$0(RecordCodecBuilder.Instance it) {
        return it.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(RidingStatBoostCriterion::CODEC_delegate$lambda$0$0$0), (App)Codec.BOOL.optionalFieldOf("requires_owner", (Object)true).forGetter(RidingStatBoostCriterion::CODEC_delegate$lambda$0$0$1), (App)Codec.STRING.optionalFieldOf("ride_stat", (Object)"any").forGetter(RidingStatBoostCriterion::CODEC_delegate$lambda$0$0$2), (App)Codec.DOUBLE.optionalFieldOf("stat_value", (Object)0.0).forGetter(RidingStatBoostCriterion::CODEC_delegate$lambda$0$0$3), (App)Codec.BOOL.optionalFieldOf("is_max", (Object)false).forGetter(RidingStatBoostCriterion::CODEC_delegate$lambda$0$0$4)).apply((Applicative)it, RidingStatBoostCriterion::new);
    }

    private static final Optional CODEC_delegate$lambda$0$0$0(RidingStatBoostCriterion it) {
        return it.getPlayerCtx();
    }

    private static final Boolean CODEC_delegate$lambda$0$0$1(RidingStatBoostCriterion it) {
        return it.requiresOwner;
    }

    private static final String CODEC_delegate$lambda$0$0$2(RidingStatBoostCriterion it) {
        return it.rideStat;
    }

    private static final Double CODEC_delegate$lambda$0$0$3(RidingStatBoostCriterion it) {
        return it.statValue;
    }

    private static final Boolean CODEC_delegate$lambda$0$0$4(RidingStatBoostCriterion it) {
        return it.isMax;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/RidingStatBoostCriterion$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/advancement/criterion/RidingStatBoostCriterion;", "CODEC$delegate", "Lkotlin/Lazy;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "CODEC", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<RidingStatBoostCriterion> getCODEC() {
            Lazy lazy = CODEC$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Codec)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

