/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.berry;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.berry.GrowthFactor;
import com.cobblemon.mod.common.api.berry.spawncondition.BerrySpawnCondition;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.mulch.MulchVariant;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.net.messages.client.data.BerryRegistrySyncPacket;
import com.cobblemon.mod.common.pokemon.adapters.CobblemonStatTypeAdapter;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.adapters.BoxAdapter;
import com.cobblemon.mod.common.util.adapters.BoxCollectionAdapter;
import com.cobblemon.mod.common.util.adapters.CobblemonBerrySpawnConditionAdapter;
import com.cobblemon.mod.common.util.adapters.CobblemonGrowthFactorAdapter;
import com.cobblemon.mod.common.util.adapters.FloatNumberRangeAdapter;
import com.cobblemon.mod.common.util.adapters.IdentifierAdapter;
import com.cobblemon.mod.common.util.adapters.LiteralHexColorAdapter;
import com.cobblemon.mod.common.util.adapters.MulchVariantAdapter;
import com.cobblemon.mod.common.util.adapters.StatusAdapter;
import com.cobblemon.mod.common.util.adapters.TagKeyAdapter;
import com.cobblemon.mod.common.util.adapters.VerboseIntRangeAdapter;
import com.cobblemon.mod.common.util.adapters.VerboseVec3dAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\t\u001a\u00020\b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\u001e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R \u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000#8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010*\u001a\n )*\u0004\u0018\u00010(0(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R \u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u00168\u0016X\u0096D\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R0\u00109\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000207j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002`88\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lcom/cobblemon/mod/common/api/berry/Berries;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lcom/cobblemon/mod/common/api/berry/Berry;", "<init>", "()V", "", "Lnet/minecraft/resources/ResourceLocation;", "data", "", "reload", "(Ljava/util/Map;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "", "Lkotlin/jvm/internal/EnhancedNullability;", "all", "()Ljava/util/List;", "identifier", "getByIdentifier", "(Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/api/berry/Berry;", "", "name", "getByName", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/berry/Berry;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "resourcePath", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "berries", "Ljava/util/HashMap;", "common"})
@SourceDebugExtension(value={"SMAP\nBerries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Berries.kt\ncom/cobblemon/mod/common/api/berry/Berries\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n216#2,2:110\n*S KotlinDebug\n*F\n+ 1 Berries.kt\ncom/cobblemon/mod/common/api/berry/Berries\n*L\n71#1:110,2\n*E\n"})
public final class Berries
implements JsonDataRegistry<Berry> {
    @NotNull
    public static final Berries INSTANCE = new Berries();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("berries");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final SimpleObservable<Berries> observable = new SimpleObservable();
    private static final Gson gson;
    @NotNull
    private static final TypeToken<Berry> typeToken;
    @NotNull
    private static final String resourcePath;
    @NotNull
    private static final HashMap<ResourceLocation, Berry> berries;

    private Berries() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<Berries> getObservable() {
        return observable;
    }

    @Override
    public Gson getGson() {
        return gson;
    }

    @Override
    @NotNull
    public TypeToken<Berry> getTypeToken() {
        return typeToken;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        return resourcePath;
    }

    @Override
    public void reload(@NotNull Map<ResourceLocation, Berry> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        berries.clear();
        Map<ResourceLocation, Berry> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, Berry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, Berry> element$iv;
            Map.Entry<ResourceLocation, Berry> entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier2 = entry.getKey();
            Berry berry = entry.getValue();
            try {
                berry.setIdentifier$common(identifier2);
                berry.validate$common();
                ((Map)berries).put(identifier2, berry);
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Skipped loading the {} berry", (Object)identifier2, (Object)e);
            }
        }
        Cobblemon.LOGGER.info("Loaded {} berries", (Object)berries.size());
        Berries[] berriesArray = new Berries[]{this};
        this.getObservable().emit((Berries[])berriesArray);
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new BerryRegistrySyncPacket((Collection<Berry>)Berries.all()).sendToPlayer(player);
    }

    @JvmStatic
    @NotNull
    public static final List<Berry> all() {
        Collection<Berry> collection = berries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @JvmStatic
    @Nullable
    public static final Berry getByIdentifier(@NotNull ResourceLocation identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        return berries.get(identifier2);
    }

    @JvmStatic
    @Nullable
    public static final Berry getByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Berries.getByIdentifier(MiscUtilsKt.cobblemonResource(name));
    }

    static {
        Type[] typeArray = new Type[]{AABB.class};
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter((Type)((Object)MulchVariant.class), (Object)MulchVariantAdapter.INSTANCE).registerTypeAdapter((Type)((Object)MinMaxBounds.Doubles.class), (Object)FloatNumberRangeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Status.class), (Object)StatusAdapter.INSTANCE).registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)Collection.class)), (Type[])typeArray).getType(), (Object)BoxCollectionAdapter.INSTANCE).registerTypeAdapter((Type)((Object)AABB.class), (Object)BoxAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Vec3.class), (Object)VerboseVec3dAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ResourceLocation.class), (Object)IdentifierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)GrowthFactor.class), (Object)CobblemonGrowthFactorAdapter.INSTANCE).registerTypeAdapter((Type)((Object)IntRange.class), (Object)VerboseIntRangeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Color.class), (Object)LiteralHexColorAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Stat.class), (Object)CobblemonStatTypeAdapter.INSTANCE);
        typeArray = new Type[]{Biome.class};
        Type type = TypeToken.getParameterized((Type)((Type)((Object)TagKey.class)), (Type[])typeArray).getType();
        ResourceKey resourceKey = Registries.BIOME;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"BIOME");
        gson = gsonBuilder.registerTypeAdapter(type, new TagKeyAdapter(resourceKey)).registerTypeAdapter((Type)((Object)BerrySpawnCondition.class), (Object)CobblemonBerrySpawnConditionAdapter.INSTANCE).create();
        TypeToken typeToken = TypeToken.get(Berry.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"get(...)");
        Berries.typeToken = typeToken;
        resourcePath = "berries";
        berries = new HashMap();
    }
}

