/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.drop;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.ItemDropMethod;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010$\u001a\u0004\u0018\u00010#8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\u001c8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010\u001e\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R\u001c\u0010.\u001a\u0004\u0018\u00010-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R*\u00104\u001a\n 3*\u0004\u0018\u000102028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010;\u001a\u0004\u0018\u00010:8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "Lcom/cobblemon/mod/common/api/drop/DropEntry;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/world/phys/Vec3;", "pos", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "drop", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "", "percentage", "F", "getPercentage", "()F", "setPercentage", "(F)V", "", "quantity", "I", "getQuantity", "()I", "setQuantity", "(I)V", "Lkotlin/ranges/IntRange;", "quantityRange", "Lkotlin/ranges/IntRange;", "getQuantityRange", "()Lkotlin/ranges/IntRange;", "setQuantityRange", "(Lkotlin/ranges/IntRange;)V", "maxSelectableTimes", "getMaxSelectableTimes", "setMaxSelectableTimes", "Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "dropMethod", "Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "getDropMethod", "()Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "item", "Lnet/minecraft/resources/ResourceLocation;", "getItem", "()Lnet/minecraft/resources/ResourceLocation;", "setItem", "(Lnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/core/component/DataComponentMap;", "components", "Lnet/minecraft/core/component/DataComponentMap;", "getComponents", "()Lnet/minecraft/core/component/DataComponentMap;", "common"})
@SourceDebugExtension(value={"SMAP\nItemDropEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemDropEntry.kt\ncom/cobblemon/mod/common/api/drop/ItemDropEntry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1869#2,2:96\n*S KotlinDebug\n*F\n+ 1 ItemDropEntry.kt\ncom/cobblemon/mod/common/api/drop/ItemDropEntry\n*L\n57#1:96,2\n*E\n"})
public class ItemDropEntry
implements DropEntry {
    private float percentage = 100.0f;
    private int quantity = 1;
    @Nullable
    private IntRange quantityRange;
    private int maxSelectableTimes = 1;
    @Nullable
    private final ItemDropMethod dropMethod;
    private ResourceLocation item = ResourceLocation.parse((String)"minecraft:fish");
    @Nullable
    private final DataComponentMap components;

    @Override
    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float f) {
        this.percentage = f;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int n) {
        this.quantity = n;
    }

    @Nullable
    public IntRange getQuantityRange() {
        return this.quantityRange;
    }

    public void setQuantityRange(@Nullable IntRange intRange) {
        this.quantityRange = intRange;
    }

    @Override
    public int getMaxSelectableTimes() {
        return this.maxSelectableTimes;
    }

    public void setMaxSelectableTimes(int n) {
        this.maxSelectableTimes = n;
    }

    @Nullable
    public ItemDropMethod getDropMethod() {
        return this.dropMethod;
    }

    public ResourceLocation getItem() {
        return this.item;
    }

    public void setItem(ResourceLocation resourceLocation) {
        this.item = resourceLocation;
    }

    @Nullable
    public DataComponentMap getComponents() {
        return this.components;
    }

    @Override
    public void drop(@Nullable LivingEntity entity, @NotNull ServerLevel world, @NotNull Vec3 pos, @Nullable ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Item item = (Item)world.registryAccess().registryOrThrow(Registries.ITEM).get(this.getItem());
        if (item == null) {
            Cobblemon.LOGGER.error("Unable to load drop item: " + this.getItem());
            return;
        }
        Item item2 = item;
        IntRange intRange = this.getQuantityRange();
        ItemStack stack = new ItemStack((ItemLike)item2, intRange != null ? RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default)) : this.getQuantity());
        boolean inLava = Intrinsics.areEqual((Object)world.getBlockState(Vec3ExtensionsKt.toBlockPos(pos)).getBlock(), (Object)Blocks.LAVA);
        ItemDropMethod itemDropMethod = this.getDropMethod();
        if (itemDropMethod == null) {
            itemDropMethod = Cobblemon.INSTANCE.getConfig().getDefaultDropItemMethod();
        }
        ItemDropMethod it = itemDropMethod;
        boolean bl = false;
        ItemDropMethod dropMethod = inLava ? ItemDropMethod.TO_INVENTORY : it;
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        DataComponentMap dataComponentMap = this.getComponents();
        if (dataComponentMap != null) {
            Iterable $this$forEach$iv = (Iterable)dataComponentMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypedDataComponent it2 = (TypedDataComponent)element$iv;
                boolean bl2 = false;
                builder.set(it2);
            }
        }
        stack.applyComponentsAndValidate(builder.build());
        if (dropMethod == ItemDropMethod.ON_PLAYER && player != null) {
            world.addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack));
        } else if (dropMethod == ItemDropMethod.TO_INVENTORY && player != null && !stack.isEmpty()) {
            Component name = stack.getHoverName();
            int count = stack.getCount();
            boolean succeeded = player.addItem(stack);
            if (Cobblemon.INSTANCE.getConfig().getAnnounceDropItems()) {
                MutableComponent mutableComponent;
                if (succeeded) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = count;
                    MutableComponent mutableComponent2 = name.copy();
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"copy(...)");
                    objectArray[1] = TextKt.green(mutableComponent2);
                    mutableComponent = LocalizationUtilsKt.lang("drop.item.inventory", objectArray);
                } else {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)name);
                    objectArray[0] = name;
                    MutableComponent mutableComponent3 = LocalizationUtilsKt.lang("drop.item.full", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"lang(...)");
                    mutableComponent = TextKt.red(mutableComponent3);
                }
                player.sendSystemMessage((Component)mutableComponent);
            }
        } else if (dropMethod == ItemDropMethod.ON_ENTITY && entity != null) {
            world.addFreshEntity((Entity)new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), stack));
        } else {
            world.addFreshEntity((Entity)new ItemEntity((Level)world, pos.x, pos.y, pos.z, stack));
        }
    }

    public final void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeFloat(this.getPercentage());
        buffer.writeVarInt(this.getQuantity());
        buffer.writeResourceLocation(this.getItem());
        buffer.writeNullable((Object)this.getQuantityRange(), (arg_0, arg_1) -> ItemDropEntry.encode$lambda$1((arg_0, arg_1) -> ItemDropEntry.encode$lambda$0(buffer, arg_0, arg_1), arg_0, arg_1));
    }

    @NotNull
    public final ItemDropEntry decode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.setPercentage(buffer.readFloat());
        this.setQuantity(buffer.readVarInt());
        this.setItem(buffer.readResourceLocation());
        this.setQuantityRange((IntRange)buffer.readNullable(arg_0 -> ItemDropEntry.decode$lambda$1(arg_0 -> ItemDropEntry.decode$lambda$0(buffer, arg_0), arg_0)));
        return this;
    }

    private static final Unit encode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, IntRange it) {
        $buffer.writeVarInt(it.getFirst());
        $buffer.writeVarInt(it.getLast());
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$1(Function2 $tmp0, Object object, IntRange object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final IntRange decode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return new IntRange($buffer.readVarInt(), $buffer.readVarInt());
    }

    private static final IntRange decode$lambda$1(Function1 $tmp0, Object object) {
        return (IntRange)$tmp0.invoke(object);
    }
}

