/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.multiblock;

import com.cobblemon.mod.common.api.multiblock.MultiblockBlock;
import com.cobblemon.mod.common.api.multiblock.MultiblockStructure;
import com.cobblemon.mod.common.api.multiblock.builder.MultiblockStructureBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H$\u00a2\u0006\u0004\b\u001d\u0010\u0018R$\u0010\t\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010(\u001a\u0004\u0018\u00010#8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001e\u0010-\u001a\u0004\u0018\u00010\u00048&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/api/multiblock/MultiblockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;", "multiblockBuilder", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;)V", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "Lnet/minecraft/nbt/CompoundTag;", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "nbt", "", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "blockState", "", "isValidBlockState", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "loadAdditional", "Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;", "getMultiblockBuilder", "()Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;", "setMultiblockBuilder", "(Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;)V", "Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;", "getMultiblockStructure", "()Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;", "setMultiblockStructure", "(Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;)V", "multiblockStructure", "getMasterBlockPos", "()Lnet/minecraft/core/BlockPos;", "setMasterBlockPos", "(Lnet/minecraft/core/BlockPos;)V", "masterBlockPos", "common"})
public abstract class MultiblockEntity
extends BlockEntity {
    @Nullable
    private MultiblockStructureBuilder multiblockBuilder;

    public MultiblockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable MultiblockStructureBuilder multiblockBuilder) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.multiblockBuilder = multiblockBuilder;
    }

    @Nullable
    public final MultiblockStructureBuilder getMultiblockBuilder() {
        return this.multiblockBuilder;
    }

    public final void setMultiblockBuilder(@Nullable MultiblockStructureBuilder multiblockStructureBuilder) {
        this.multiblockBuilder = multiblockStructureBuilder;
    }

    @Nullable
    public abstract MultiblockStructure getMultiblockStructure();

    public abstract void setMultiblockStructure(@Nullable MultiblockStructure var1);

    @Nullable
    public abstract BlockPos getMasterBlockPos();

    public abstract void setMasterBlockPos(@Nullable BlockPos var1);

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag result = new CompoundTag();
        this.saveAdditional(result, registryLookup);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("Formed", this.getMasterBlockPos() != null);
        if (this.getMultiblockStructure() != null) {
            MultiblockStructure multiblockStructure = this.getMultiblockStructure();
            Intrinsics.checkNotNull((Object)multiblockStructure);
            if (Intrinsics.areEqual((Object)multiblockStructure.getControllerBlockPos(), (Object)this.getBlockPos())) {
                MultiblockStructure multiblockStructure2 = this.getMultiblockStructure();
                Intrinsics.checkNotNull((Object)multiblockStructure2);
                nbt.put("MultiblockStore", (Tag)multiblockStructure2.writeToNbt(registryLookup));
                return;
            }
        }
        if (this.getMasterBlockPos() == null) return;
        nbt.put("ControllerBlock", NbtUtils.writeBlockPos((BlockPos)this.getMasterBlockPos()));
    }

    public boolean isValidBlockState(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return blockState.getBlock() instanceof MultiblockBlock;
    }

    protected abstract void loadAdditional(@NotNull CompoundTag var1, @NotNull HolderLookup.Provider var2);
}

