/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.npc.configuration.interaction;

import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.npc.configuration.NPCInteractConfiguration;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/api/npc/configuration/interaction/CustomScriptNPCInteractionConfiguration;", "Lcom/cobblemon/mod/common/api/npc/configuration/NPCInteractConfiguration;", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "decode", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "writeToNBT", "(Lnet/minecraft/nbt/CompoundTag;)V", "readFromNBT", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "npc", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "interact", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;Lnet/minecraft/server/level/ServerPlayer;)Z", "other", "isDifferentTo", "(Lcom/cobblemon/mod/common/api/npc/configuration/NPCInteractConfiguration;)Z", "", "type", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "script", "Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "getScript", "()Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "setScript", "(Lcom/cobblemon/mod/common/api/molang/ExpressionLike;)V", "common"})
public final class CustomScriptNPCInteractionConfiguration
implements NPCInteractConfiguration {
    @NotNull
    private final String type;
    @NotNull
    private ExpressionLike script = MoLangExtensionsKt.asExpressionLike("1");

    public CustomScriptNPCInteractionConfiguration() {
        this.type = "custom_script";
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public final ExpressionLike getScript() {
        return this.script;
    }

    public final void setScript(@NotNull ExpressionLike expressionLike) {
        Intrinsics.checkNotNullParameter((Object)expressionLike, (String)"<set-?>");
        this.script = expressionLike;
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BufferUtilsKt.writeString((ByteBuf)buffer, this.script.getString());
    }

    @Override
    public void decode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.script = MoLangExtensionsKt.asExpressionLike(BufferUtilsKt.readString((ByteBuf)buffer));
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        compoundTag.putString("CustomScript", this.script.getString());
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        String string = compoundTag.getString("CustomScript");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.script = MoLangExtensionsKt.asExpressionLike(string);
    }

    @Override
    public boolean interact(@NotNull NPCEntity npc, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)npc, (String)"npc");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"npc", (Object)npc.getStruct()), TuplesKt.to((Object)"player", MoLangFunctions.INSTANCE.asMoLangValue((Player)player))};
        Map context = MapsKt.mapOf((Pair[])pairArray);
        this.script.resolve(npc.getRuntime(), context);
        return true;
    }

    @Override
    public boolean isDifferentTo(@NotNull NPCInteractConfiguration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !(other instanceof CustomScriptNPCInteractionConfiguration) || !Intrinsics.areEqual((Object)((CustomScriptNPCInteractionConfiguration)other).script.getString(), (Object)this.script.getString());
    }
}

