/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.liquid;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangMath;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.SubmarineSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.SubmarineState;
import com.cobblemon.mod.common.api.riding.posing.PoseOption;
import com.cobblemon.mod.common.api.riding.posing.PoseProvider;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J7\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ/\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010#\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J7\u0010%\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b%\u0010&J7\u0010)\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b)\u0010*J/\u0010,\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b,\u0010-J?\u00100\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b0\u00101J_\u00108\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020'2\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b8\u00109J/\u0010:\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b:\u0010;J/\u0010<\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b<\u0010\u0017J7\u0010?\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\b?\u0010@J/\u0010B\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020'H\u0016\u00a2\u0006\u0004\bB\u0010CJ/\u0010D\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\bD\u0010\u0017J'\u0010E\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bE\u0010\u000fJ'\u0010F\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bF\u0010GJ'\u0010H\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bH\u0010\u000fJ'\u0010I\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bI\u0010\u000fJ'\u0010J\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bJ\u0010\u000fJ3\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0K2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bL\u0010MJ'\u0010N\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bN\u0010\u000fJ'\u0010O\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bO\u0010\u000fJ'\u0010Q\u001a\u00020P2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u0017\u0010S\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bS\u0010TJ9\u0010V\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010U2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bV\u0010WR\u001a\u0010Y\u001a\u00020X8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010\\R\u0011\u0010_\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R#\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030`8\u0006\u00a2\u0006\f\n\u0004\ba\u0010b\u001a\u0004\bc\u0010d\u00a8\u0006f"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;", "<init>", "()V", "settings", "state", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "isActive", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lcom/cobblemon/mod/common/entity/PoseType;", "pose", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/entity/PoseType;", "Lnet/minecraft/world/entity/player/Player;", "driver", "", "speed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)F", "Lnet/minecraft/world/phys/Vec3;", "input", "", "tick", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "tickStamina", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "surfaceCheck", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/phys/Vec2;", "rotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "velocity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "", "deltaTime", "angRollVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Lnet/minecraft/world/phys/Vec3;", "partialTicks", "applyRenderRotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;F)V", "Lcom/cobblemon/mod/common/api/orientation/OrientationController;", "controller", "correctOrientation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/orientation/OrientationController;Lnet/minecraft/world/entity/player/Player;D)V", "mouseY", "mouseX", "Lnet/minecraft/util/SmoothDouble;", "mouseYSmoother", "mouseXSmoother", "sensitivity", "rotationOnMouseXY", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;DDLnet/minecraft/util/SmoothDouble;Lnet/minecraft/util/SmoothDouble;DD)Lnet/minecraft/world/phys/Vec3;", "canJump", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "setRideBar", "", "jumpStrength", "jumpForce", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/phys/Vec3;", "regularGravity", "gravity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;D)D", "rideFovMultiplier", "useAngVelSmoothing", "inertia", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)D", "shouldRoll", "turnOffOnGround", "dismountOnShift", "Lkotlin/Pair;", "mouseModifiesDriverRotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lkotlin/Pair;", "shouldRotatePokemonHead", "shouldRotateRiderHead", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "getRideSounds", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "createDefaultState", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "asMoLangValue", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "getGlobalSubmarine", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineSettings;", "globalSubmarine", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "poseProvider", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "getPoseProvider", "()Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "Companion", "common"})
public final class SubmarineBehaviour
implements RidingBehaviour<SubmarineSettings, SubmarineState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation key = KEY;
    @NotNull
    private final PoseProvider<SubmarineSettings, SubmarineState> poseProvider = new PoseProvider(PoseType.FLOAT).with(new PoseOption(PoseType.SWIM, SubmarineBehaviour::poseProvider$lambda$0)).with(new PoseOption(PoseType.STAND, SubmarineBehaviour::poseProvider$lambda$1)).with(new PoseOption(PoseType.STAND, SubmarineBehaviour::poseProvider$lambda$2));
    @NotNull
    private static final ResourceLocation KEY = MiscUtilsKt.cobblemonResource("liquid/submarine");

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @NotNull
    public final SubmarineSettings getGlobalSubmarine() {
        return CobblemonRideSettings.INSTANCE.getSubmarine();
    }

    @Override
    @NotNull
    public RidingStyle getRidingStyle(@NotNull SubmarineSettings settings, @NotNull SubmarineState state) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RidingStyle.LIQUID;
    }

    @NotNull
    public final PoseProvider<SubmarineSettings, SubmarineState> getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public boolean isActive(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return vehicle.isInWater() || !vehicle.onGround();
    }

    @Override
    @NotNull
    public PoseType pose(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return this.poseProvider.select((SubmarineSettings)((RidingBehaviourSettings)settings), (SubmarineState)((RidingBehaviourState)state), vehicle);
    }

    @Override
    public float speed(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return (float)((Number)state.getSpeed().get()).doubleValue();
    }

    @Override
    public void tick(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (vehicle.level().isClientSide) {
            this.tickStamina(settings, state, vehicle);
            this.surfaceCheck(settings, state, vehicle, driver);
        }
    }

    public final void tickStamina(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        LivingEntity driver;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        float stam = ((Number)state.getStamina().get()).floatValue();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getInfiniteStamina();
        if (expression == null) {
            Expression expression2 = this.getGlobalSubmarine().getInfiniteStamina();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        if (MoLangExtensionsKt.resolveBoolean$default(moLangRuntime, expression, null, 2, null)) {
            return;
        }
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getStaminaExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalSubmarine().getStaminaExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double breathTime = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * (double)20.0f;
        MoLangRuntime moLangRuntime3 = vehicle.getRuntime();
        Expression expression5 = settings.getStaminaRegenTime();
        if (expression5 == null) {
            Expression expression6 = this.getGlobalSubmarine().getStaminaRegenTime();
            expression5 = expression6;
            Intrinsics.checkNotNull((Object)expression6);
        }
        float stamRegenRate = 1.0f / ((float)MoLangExtensionsKt.resolveDouble$default(moLangRuntime3, expression5, null, 2, null) * 20.0f);
        float stamDrainRate = (float)((double)1.0f / breathTime);
        LivingEntity livingEntity = driver = vehicle.getControllingPassenger();
        float newStam = (livingEntity != null ? livingEntity.isEyeInFluid(FluidTags.WATER) : false) ? Math.max(0.0f, stam - stamDrainRate) : Math.min(1.0f, stam + stamRegenRate);
        SidedRidingState.set$default(state.getStamina(), Float.valueOf(newStam), false, 2, null);
    }

    private final void surfaceCheck(SubmarineSettings settings, SubmarineState state, PokemonEntity vehicle, Player driver) {
        boolean aboveInWater;
        if (!vehicle.isInWater()) {
            SidedRidingState.set$default(state.getOnSurface(), false, false, 2, null);
            return;
        }
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getHitboxBreachPercentage();
        if (expression == null) {
            Expression expression2 = this.getGlobalSubmarine().getHitboxBreachPercentage();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double hitboxBreachPercentage = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        Vec3 vehicleBreachPoint = vehicle.position().add(0.0, (double)vehicle.getBbHeight() * hitboxBreachPercentage, 0.0);
        BlockPos centerBlockPos = BlockPos.containing((Position)((Position)vehicleBreachPoint));
        boolean centerInWater = !vehicle.level().getFluidState(centerBlockPos).isEmpty();
        BlockPos abovePos = centerBlockPos.above();
        boolean bl = aboveInWater = !vehicle.level().getFluidState(abovePos).isEmpty();
        if (!centerInWater && !aboveInWater) {
            SidedRidingState.set$default(state.getOnSurface(), true, false, 2, null);
        } else {
            SidedRidingState.set$default(state.getOnSurface(), false, false, 2, null);
        }
    }

    @Override
    @NotNull
    public Vec2 rotation(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return new Vec2(driver.getXRot() * 0.5f, driver.getYRot());
    }

    @Override
    @NotNull
    public Vec3 velocity(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(vehicle instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        OrientationController controller = ((OrientationControllable)((Object)vehicle)).getOrientationController();
        Matrix3f matrix3f = controller.getOrientation();
        if (matrix3f == null) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        Matrix3f orientation = matrix3f;
        MoLangRuntime runtime = vehicle.getRuntime();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalSubmarine().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) / 20.0;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getAccelerationExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalSubmarine().getAccelerationExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double accel = topSpeed / (MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * 20.0);
        Expression expression5 = settings.getJumpExpr();
        if (expression5 == null) {
            Expression expression6 = this.getGlobalSubmarine().getJumpExpr();
            expression5 = expression6;
            Intrinsics.checkNotNull((Object)expression6);
        }
        double strafeSpeed = MoLangExtensionsKt.resolveDouble$default(runtime, expression5, null, 2, null) / 20.0;
        MoLangRuntime moLangRuntime3 = vehicle.getRuntime();
        Expression expression7 = settings.getAccelerationExpr();
        if (expression7 == null) {
            Expression expression8 = this.getGlobalSubmarine().getAccelerationExpr();
            expression7 = expression8;
            Intrinsics.checkNotNull((Object)expression8);
        }
        double strafeAccel = strafeSpeed / (MoLangExtensionsKt.resolveDouble$default(moLangRuntime3, expression7, null, 2, null) * 20.0);
        Vec3 currVel = state.getRideVelocity().get();
        if (vehicle.horizontalCollision || vehicle.verticalCollision) {
            double frictionLimit = 0.1;
            double postColSpeed = Math.min(Math.max(state.getRideVelocity().get().length(), frictionLimit), ((Number)state.getSpeed().get()).doubleValue());
            SidedRidingState.set$default(state.getSpeed(), postColSpeed, false, 2, null);
        }
        if (vehicle.verticalCollision) {
            SidedRidingState.set$default(state.getRideVelocity(), new Vec3(state.getRideVelocity().get().x, 0.0, state.getRideVelocity().get().z), false, 2, null);
        }
        double currZVel = state.getRideVelocity().get().z;
        double newZVel = (double)driver.zza > 0.0 ? Math.min(topSpeed, currZVel + accel) : ((double)driver.zza < 0.0 ? Math.max(-strafeSpeed, currZVel - strafeAccel) : MoLangMath.lerp(currZVel, 0.0, 0.05));
        currVel = new Vec3(currVel.x, currVel.y, newZVel);
        double vertTopSpeed = strafeSpeed;
        double currYVel = state.getRideVelocity().get().y;
        double gravity = 0.03920000000000001;
        double terminalYVel = 2.0;
        double driverYInput = driver.jumping ? 1.0 : (driver.isShiftKeyDown() ? -1.0 : 0.0);
        double newYVel = !((Entity)vehicle).isInWater() ? Math.max(-terminalYVel, currYVel - gravity) : (driverYInput > 0.0 ? Math.min(vertTopSpeed, currYVel + strafeAccel) : (driverYInput < 0.0 ? Math.max(-vertTopSpeed, currYVel - strafeAccel) : MoLangMath.lerp(currYVel, 0.0, 0.05)));
        currVel = new Vec3(currVel.x, newYVel, currVel.z);
        double currXVel = state.getRideVelocity().get().x;
        double horzTopSpeed = strafeSpeed;
        double newXVel = (double)driver.xxa > 0.0 ? Math.min(horzTopSpeed, currXVel + strafeAccel) : ((double)driver.xxa < 0.0 ? Math.max(-horzTopSpeed, currXVel - strafeAccel) : MoLangMath.lerp(currXVel, 0.0, 0.01));
        currVel = new Vec3(newXVel, currVel.y, currVel.z);
        SidedRidingState.set$default(state.getRideVelocity(), currVel, false, 2, null);
        if (state.getOnSurface().get().booleanValue()) {
            Vec3 worldVelVec = new Vec3(currVel.x, Math.min(0.0, currVel.y), currVel.z);
            return worldVelVec;
        }
        Vec3 vertVec = new Vec3(0.0, currVel.y, 0.0);
        Vec3 horzVec = new Vec3(currVel.x, 0.0, 0.0);
        Vector3f localZVelVec = new Vector3f(0.0f, 0.0f, (float)currVel.z * -1.0f);
        Vector3f vector3f = localZVelVec.mul((Matrix3fc)orientation);
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"mul(...)");
        Vec3 worldVelVec = Vec3ExtensionsKt.toVec3d(vector3f).yRot(AngleExtensionsKt.toRadians(Float.valueOf(((Entity)vehicle).getYRot())));
        Vec3 vec3 = worldVelVec.add(vertVec).add(horzVec);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 angRollVel(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public void applyRenderRotation(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        if (!(vehicle instanceof OrientationControllable)) {
            return;
        }
        OrientationController controller = ((OrientationControllable)((Object)vehicle)).getOrientationController();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getHandlingExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalSubmarine().getHandlingExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double handling = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        double surfaceHandlingBoost = state.getOnSurface().get() != false ? 3.0 : 1.0;
        handling *= surfaceHandlingBoost;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getJumpExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalSubmarine().getJumpExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double strafeSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) / 20.0;
        int maxRollDeg = state.getOnSurface().get() != false ? 5 : 15;
        int maxPitchDeg = 15;
        double rollAmount = 0.0;
        double pitchAmount = 0.0;
        double maxHorzSpeed = strafeSpeed;
        double currHorzSpeed = state.getRideVelocity().get().x;
        double desiredRoll = -RangesKt.coerceIn((double)(currHorzSpeed / maxHorzSpeed), (double)-1.0, (double)1.0) * (double)maxRollDeg;
        controller.rotateRoll((float)(rollAmount += MoLangMath.lerp(controller.getRoll(), desiredRoll, partialTicks) - (double)controller.getRoll()));
        double maxYawRate = handling;
        double currYawRate = vehicle.getRidingAnimationData().getRotDeltaSpring().getInterpolated(partialTicks, 2).y();
        desiredRoll = -RangesKt.coerceIn((double)(currYawRate / maxYawRate), (double)-1.0, (double)1.0) * (double)maxRollDeg;
        controller.rotateRoll((float)(rollAmount += desiredRoll - (double)controller.getRoll()));
    }

    private final void correctOrientation(SubmarineSettings settings, SubmarineState state, PokemonEntity vehicle, OrientationController controller, Player driver, double deltaTime) {
    }

    @Override
    @NotNull
    public Vec3 rotationOnMouseXY(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double mouseY, double mouseX, @NotNull SmoothDouble mouseYSmoother, @NotNull SmoothDouble mouseXSmoother, double sensitivity, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)mouseYSmoother, (String)"mouseYSmoother");
        Intrinsics.checkNotNullParameter((Object)mouseXSmoother, (String)"mouseXSmoother");
        if (!(vehicle instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        OrientationController controller = ((OrientationControllable)((Object)vehicle)).getOrientationController();
        controller.rotateRoll(controller.getRoll() * -1.0f);
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getHandlingExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalSubmarine().getHandlingExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double handling = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        double surfaceHandlingBoost = state.getOnSurface().get() != false ? 3.0 : 1.0;
        double effHandling = state.getOnSurface().get() != false ? (double)1000 * deltaTime : handling * deltaTime;
        double smoothingSpeed = state.getOnSurface().get() != false ? 10.0 : 2.0;
        double mouseXc = RangesKt.coerceIn((double)(mouseX * 0.1), (double)(-effHandling), (double)effHandling);
        double mouseYc = RangesKt.coerceIn((double)(mouseY * 0.1), (double)(-effHandling), (double)effHandling);
        double xInput = mouseXSmoother.getNewDeltaValue(mouseXc, deltaTime * smoothingSpeed);
        double yInput = mouseYSmoother.getNewDeltaValue(mouseYc, deltaTime * smoothingSpeed);
        double yawForce = xInput;
        controller.applyGlobalYaw((float)yawForce);
        double pitchRot = yInput;
        double pitchLimit = 45.0;
        if (Math.abs((double)controller.getPitch() + pitchRot) >= pitchLimit) {
            pitchRot = 0.0;
            mouseYSmoother.reset();
        } else {
            controller.applyGlobalPitch((float)pitchRot);
        }
        if (state.getOnSurface().get().booleanValue()) {
            double maxCorrectionSpeed = 30.0;
            double arrivalDegreeWidth = 30.0;
            float currentPitch = controller.getPitch();
            double correctionDegrees = RangesKt.coerceIn((double)((double)(-currentPitch) / arrivalDegreeWidth), (double)-1.0, (double)1.0) * maxCorrectionSpeed * deltaTime;
            controller.applyGlobalPitch((float)correctionDegrees);
        }
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public boolean canJump(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return false;
    }

    @Override
    public float setRideBar(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return ((Number)state.getStamina().get()).floatValue() / 1.0f;
    }

    @Override
    @NotNull
    public Vec3 jumpForce(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, int jumpStrength) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public double gravity(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, double regularGravity) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.0;
    }

    @Override
    public float rideFovMultiplier(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return 1.0f;
    }

    @Override
    public boolean useAngVelSmoothing(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public double inertia(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return !vehicle.isUnderWater() ? 1.0 : 0.1;
    }

    @Override
    public boolean shouldRoll(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    public boolean turnOffOnGround(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean dismountOnShift(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    @NotNull
    public Pair<Boolean, Boolean> mouseModifiesDriverRotation(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return new Pair((Object)false, (Object)state.getOnSurface().get());
    }

    @Override
    public boolean shouldRotatePokemonHead(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotateRiderHead(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    @NotNull
    public RideSoundSettingsList getRideSounds(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return settings.getRideSounds();
    }

    @Override
    @NotNull
    public SubmarineState createDefaultState(@NotNull SubmarineSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new SubmarineState();
    }

    @Override
    @NotNull
    public ObjectValue<RidingBehaviour<SubmarineSettings, SubmarineState>> asMoLangValue(@NotNull SubmarineSettings settings, @NotNull SubmarineState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        ObjectValue<RidingBehaviour<SubmarineSettings, SubmarineState>> value = RidingBehaviour.super.asMoLangValue((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle);
        value.functions.put("on_surface", arg_0 -> SubmarineBehaviour.asMoLangValue$lambda$0(state, arg_0));
        return value;
    }

    private static final boolean poseProvider$lambda$0(SubmarineSettings submarineSettings, SubmarineState state, PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)submarineSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return state.getRideVelocity().get().z > 0.05 && state.getOnSurface().get() == false;
    }

    private static final boolean poseProvider$lambda$1(SubmarineSettings submarineSettings, SubmarineState state, PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)submarineSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return state.getRideVelocity().get().z <= 0.05 && state.getOnSurface().get() != false;
    }

    private static final boolean poseProvider$lambda$2(SubmarineSettings submarineSettings, SubmarineState state, PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)submarineSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return state.getRideVelocity().get().z > 0.05 && state.getOnSurface().get() != false;
    }

    private static final Object asMoLangValue$lambda$0(SubmarineState $state, MoParams it) {
        return new DoubleValue($state.getOnSurface().get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/SubmarineBehaviour$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "KEY", "Lnet/minecraft/resources/ResourceLocation;", "getKEY", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

