/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.detail;

import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.selection.SpawnSelectionData;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u000b\u0018\u0000 C2\u00020\u0001:\u0002CDB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R(\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\"\u0010.\u001a\u00020-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00104\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\"\u0010;\u001a\u00020:8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0011\u0010B\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010%\u00a8\u0006E"}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/PokemonHerdSpawnDetail;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "<init>", "()V", "", "isValid", "()Z", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "spawnAction", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;", "selectionData", "", "onSelection", "(Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)V", "lacksPossibleLeader", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)Z", "", "getOrSetHerdLevel", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)I", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucket", "Lcom/cobblemon/mod/common/api/spawning/detail/PokemonSpawnAction;", "createSpawnAction", "(Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)Lcom/cobblemon/mod/common/api/spawning/detail/PokemonSpawnAction;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/PokemonHerdSpawnDetail$Herdable;", "getHerdMemberCounts", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)Ljava/util/Map;", "", "getValidHerdMembers", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)Ljava/util/List;", "", "type", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "", "herdablePokemon", "Ljava/util/List;", "getHerdablePokemon", "()Ljava/util/List;", "setHerdablePokemon", "(Ljava/util/List;)V", "Lkotlin/ranges/IntRange;", "levelRange", "Lkotlin/ranges/IntRange;", "getLevelRange", "()Lkotlin/ranges/IntRange;", "setLevelRange", "(Lkotlin/ranges/IntRange;)V", "maxHerdSize", "I", "getMaxHerdSize", "()I", "setMaxHerdSize", "(I)V", "", "minDistanceBetweenSpawns", "F", "getMinDistanceBetweenSpawns", "()F", "setMinDistanceBetweenSpawns", "(F)V", "getHerdLevelKey", "herdLevelKey", "Companion", "Herdable", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonHerdSpawnDetail.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonHerdSpawnDetail.kt\ncom/cobblemon/mod/common/api/spawning/detail/PokemonHerdSpawnDetail\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,145:1\n1740#2,3:146\n1788#2,4:149\n1761#2,3:153\n774#2:159\n865#2,2:160\n808#2,11:162\n774#2:173\n865#2,2:174\n1491#2:176\n1516#2,2:177\n1518#2:180\n1519#2,3:188\n1252#2,4:193\n808#2,11:197\n774#2:208\n865#2,2:209\n1491#2:211\n1516#2,3:212\n1519#2,3:222\n1252#2,4:227\n774#2:231\n865#2,2:232\n188#3,3:156\n1#4:179\n382#5,7:181\n463#5:191\n413#5:192\n382#5,7:215\n463#5:225\n413#5:226\n*S KotlinDebug\n*F\n+ 1 PokemonHerdSpawnDetail.kt\ncom/cobblemon/mod/common/api/spawning/detail/PokemonHerdSpawnDetail\n*L\n58#1:146,3\n67#1:149,4\n80#1:153,3\n100#1:159\n100#1:160,2\n128#1:162,11\n128#1:173\n128#1:174,2\n129#1:176\n129#1:177,2\n129#1:180\n129#1:188,3\n129#1:193,4\n134#1:197,11\n134#1:208\n134#1:209,2\n135#1:211\n135#1:212,3\n135#1:222,3\n135#1:227,4\n136#1:231\n136#1:232,2\n81#1:156,3\n129#1:181,7\n129#1:191\n129#1:192\n135#1:215,7\n135#1:225\n135#1:226\n*E\n"})
public final class PokemonHerdSpawnDetail
extends SpawnDetail {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type = TYPE;
    @NotNull
    private List<Herdable> herdablePokemon = new ArrayList();
    @SerializedName(value="level", alternate={"levelRange"})
    @NotNull
    private IntRange levelRange = new IntRange(1, 100);
    private int maxHerdSize = 10;
    private float minDistanceBetweenSpawns = 1.0f;
    @NotNull
    private static final String TYPE = "pokemon-herd";
    @NotNull
    public static final String HERD_LEADER = "leader";

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public final List<Herdable> getHerdablePokemon() {
        return this.herdablePokemon;
    }

    public final void setHerdablePokemon(@NotNull List<Herdable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.herdablePokemon = list;
    }

    @NotNull
    public final IntRange getLevelRange() {
        return this.levelRange;
    }

    public final void setLevelRange(@NotNull IntRange intRange) {
        Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
        this.levelRange = intRange;
    }

    public final int getMaxHerdSize() {
        return this.maxHerdSize;
    }

    public final void setMaxHerdSize(int n) {
        this.maxHerdSize = n;
    }

    public final float getMinDistanceBetweenSpawns() {
        return this.minDistanceBetweenSpawns;
    }

    public final void setMinDistanceBetweenSpawns(float f) {
        this.minDistanceBetweenSpawns = f;
    }

    @NotNull
    public final String getHerdLevelKey() {
        return this.getId() + "__LEVEL";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        boolean bl;
        if (!super.isValid()) return false;
        Iterable $this$all$iv = this.herdablePokemon;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Herdable it = (Herdable)element$iv;
            boolean bl2 = false;
            if (!it.getPokemon().hasSpecies()) return false;
            if (!(it.getWeight() > 0.0f)) return false;
            if (it.getMaxTimes() <= 0) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @Override
    protected void onSelection(@NotNull SpawnablePosition spawnablePosition, @NotNull SpawnAction<?> spawnAction, @NotNull SpawnSelectionData selectionData) {
        int n;
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        Intrinsics.checkNotNullParameter(spawnAction, (String)"spawnAction");
        Intrinsics.checkNotNullParameter((Object)selectionData, (String)"selectionData");
        selectionData.removeSpawnDetails((Function1<? super SpawnDetail, Boolean>)((Function1)arg_0 -> PokemonHerdSpawnDetail.onSelection$lambda$0(this, arg_0)));
        selectionData.removeSpawnablePositions((Function2<? super SpawnDetail, ? super SpawnablePosition, Boolean>)((Function2)(arg_0, arg_1) -> PokemonHerdSpawnDetail.onSelection$lambda$1(spawnablePosition, this, arg_0, arg_1)));
        Iterable $this$count$iv = selectionData.getSpawnActions();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                SpawnAction it = (SpawnAction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDetail(), (Object)this) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int herdSpawnCount = n + 1;
        if (herdSpawnCount >= this.maxHerdSize || this.getValidHerdMembers(selectionData).isEmpty()) {
            selectionData.removeSpawnDetails((Function1<? super SpawnDetail, Boolean>)((Function1)arg_0 -> PokemonHerdSpawnDetail.onSelection$lambda$3(this, arg_0)));
        }
    }

    public final boolean lacksPossibleLeader(@NotNull SpawnSelectionData selectionData) {
        boolean bl;
        boolean leaderIsPossible;
        block7: {
            boolean bl2;
            Map<Herdable, Integer> herdCounts;
            block6: {
                Intrinsics.checkNotNullParameter((Object)selectionData, (String)"selectionData");
                int level = this.getOrSetHerdLevel(selectionData);
                List<Herdable> herdable = this.getValidHerdMembers(selectionData);
                herdCounts = this.getHerdMemberCounts(selectionData);
                Iterable $this$any$iv = herdable;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Herdable it = (Herdable)element$iv;
                        boolean bl3 = false;
                        IntRange intRange = it.getLevelRange();
                        boolean bl4 = intRange != null ? !intRange.contains(level) : false;
                        if (!(!bl4 && Intrinsics.areEqual((Object)it.isLeader(), (Object)true))) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            leaderIsPossible = bl2;
            Map<Herdable, Integer> $this$any$iv = herdCounts;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<Herdable, Integer>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Herdable, Integer> element$iv;
                    Map.Entry<Herdable, Integer> it = element$iv = iterator.next();
                    boolean bl5 = false;
                    Herdable herdable = it.getKey();
                    if (!((herdable != null ? Intrinsics.areEqual((Object)herdable.isLeader(), (Object)true) : false) && ((Number)it.getValue()).intValue() > 0)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean leaderIsSelected = bl;
        return leaderIsPossible && !leaderIsSelected;
    }

    private final int getOrSetHerdLevel(SpawnSelectionData selectionData) {
        Object object = selectionData.getContext().get(this.getHerdLevelKey());
        Integer n = object instanceof Integer ? (Integer)object : null;
        if (n == null) {
            PokemonHerdSpawnDetail $this$getOrSetHerdLevel_u24lambda_u240 = this;
            boolean bl = false;
            int level = RangesKt.random((IntRange)$this$getOrSetHerdLevel_u24lambda_u240.levelRange, (Random)((Random)Random.Default));
            selectionData.getContext().put($this$getOrSetHerdLevel_u24lambda_u240.getHerdLevelKey(), level);
            return level;
        }
        return n;
    }

    @NotNull
    protected PokemonSpawnAction createSpawnAction(@NotNull SpawnablePosition spawnablePosition, @NotNull SpawnBucket bucket, @NotNull SpawnSelectionData selectionData) {
        IntRange intRange;
        Herdable herdable;
        List list;
        DropTable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)selectionData, (String)"selectionData");
        List validHerdMembers = this.getValidHerdMembers(selectionData);
        if (this.lacksPossibleLeader(selectionData)) {
            Iterable $this$filter$iv = validHerdMembers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Herdable it = (Herdable)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.isLeader(), (Object)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = validHerdMembers;
        }
        if ((herdable = (Herdable)CollectionUtilsKt.weightedSelection$default(list, null, PokemonHerdSpawnDetail::createSpawnAction$lambda$1, 1, null)) == null) {
            herdable = this.herdablePokemon.get(0);
        }
        Herdable herdable2 = herdable;
        Object object = selectionData.getContext().get(this.getHerdLevelKey());
        Integer n = object instanceof Integer ? (Integer)object : null;
        int level = n != null ? n : 1;
        IntRange intRange2 = herdable2.getLevelRangeOffset();
        if (intRange2 != null) {
            IntRange offset = intRange2;
            boolean bl = false;
            int min = level + offset.getFirst();
            int max = level + offset.getLast();
            intRange = new IntRange(min, max);
        } else {
            intRange = new IntRange(level, level);
        }
        IntRange levelRange = intRange;
        object = herdable2.getPokemon();
        $this$filterTo$iv$iv = herdable2.getDropTable();
        Object it = object = new PokemonSpawnAction(spawnablePosition, bucket, this, (PokemonProperties)object, null, $this$filterTo$iv$iv, levelRange);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)herdable2.isLeader(), (Object)true)) {
            ((Collection)((SpawnAction)it).getLabels()).add(HERD_LEADER);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Herdable, Integer> getHerdMemberCounts(@NotNull SpawnSelectionData selectionData) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selectionData, (String)"selectionData");
        Iterable $this$filterIsInstance$iv = selectionData.getSpawnActions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PokemonSpawnAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PokemonSpawnAction it = (PokemonSpawnAction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDetail(), (Object)this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantActions = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = relevantActions;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Object object = $this$groupByTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            Object v0;
            Object element$iv$iv;
            block7: {
                element$iv$iv = object.next();
                PokemonSpawnAction action = (PokemonSpawnAction)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = this.herdablePokemon;
                for (Object object3 : iterable2) {
                    Herdable it = (Herdable)object3;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPokemon(), (Object)action.getProps())) continue;
                    v0 = object3;
                    break block7;
                }
                v0 = null;
            }
            Herdable key$iv$iv = v0;
            Object object4 = destination$iv$iv;
            Herdable key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        object = $this$mapValuesTo$iv$iv.entrySet();
        Object destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Object object3;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object5 = object3;
            boolean bl3 = false;
            Integer n = ((List)it.getValue()).size();
            object5.put(k, (Integer)n);
        }
        return destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Herdable> getValidHerdMembers(SpawnSelectionData selectionData) {
        void $this$filterTo$iv$iv;
        void $this$associateByTo$iv$iv$iv;
        Iterable $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$groupByTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        int level = this.getOrSetHerdLevel(selectionData);
        Iterable $this$filterIsInstance$iv = selectionData.getSpawnActions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof PokemonSpawnAction)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            PokemonSpawnAction it = (PokemonSpawnAction)element$iv$iv2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDetail(), (Object)this)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List relevantActions = (List)destination$iv$iv;
        Object $this$groupBy$iv = relevantActions;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object v0;
            block8: {
                PokemonSpawnAction action = (PokemonSpawnAction)element$iv$iv3;
                boolean bl = false;
                Iterable iterable2 = this.herdablePokemon;
                for (Object object2 : iterable2) {
                    Herdable it = (Herdable)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPokemon(), (Object)action.getProps())) continue;
                    v0 = object2;
                    break block8;
                }
                v0 = null;
            }
            Herdable key$iv$iv = v0;
            Map map = destination$iv$iv2;
            Herdable key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        element$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv2;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Object object2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object = object2;
            boolean bl3 = false;
            Integer n = ((List)it.getValue()).size();
            object.put(k, (Integer)n);
        }
        Map counts = destination$iv$iv$iv;
        Iterable $this$filter$iv2 = this.herdablePokemon;
        boolean $i$f$filter2 = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            Herdable herdable = (Herdable)element$iv$iv3;
            boolean bl = false;
            Integer n = (Integer)counts.get(herdable);
            int count = n != null ? n : 0;
            boolean bl4 = count >= herdable.getMaxTimes() ? false : herdable.getLevelRange() == null || herdable.getLevelRange().contains(level);
            if (!bl4) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        return (List)destination$iv$iv2;
    }

    private static final boolean onSelection$lambda$0(PokemonHerdSpawnDetail this$0, SpawnDetail it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)this$0);
    }

    private static final boolean onSelection$lambda$1(SpawnablePosition $spawnablePosition, PokemonHerdSpawnDetail this$0, SpawnDetail spawnDetail, SpawnablePosition pos) {
        Intrinsics.checkNotNullParameter((Object)spawnDetail, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.distanceTo($spawnablePosition) < this$0.minDistanceBetweenSpawns;
    }

    private static final boolean onSelection$lambda$3(PokemonHerdSpawnDetail this$0, SpawnDetail it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)this$0);
    }

    private static final Number createSpawnAction$lambda$1(Herdable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Float.valueOf(it.getWeight());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/PokemonHerdSpawnDetail$Companion;", "", "<init>", "()V", "", "TYPE", "Ljava/lang/String;", "getTYPE", "()Ljava/lang/String;", "HERD_LEADER", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/PokemonHerdSpawnDetail$Herdable;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "pokemon", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getPokemon", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "setPokemon", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;)V", "Lkotlin/ranges/IntRange;", "levelRange", "Lkotlin/ranges/IntRange;", "getLevelRange", "()Lkotlin/ranges/IntRange;", "levelRangeOffset", "getLevelRangeOffset", "setLevelRangeOffset", "(Lkotlin/ranges/IntRange;)V", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "dropTable", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "getDropTable", "()Lcom/cobblemon/mod/common/api/drop/DropTable;", "setDropTable", "(Lcom/cobblemon/mod/common/api/drop/DropTable;)V", "", "isLeader", "Ljava/lang/Boolean;", "()Ljava/lang/Boolean;", "setLeader", "(Ljava/lang/Boolean;)V", "", "weight", "F", "getWeight", "()F", "setWeight", "(F)V", "", "maxTimes", "I", "getMaxTimes", "()I", "setMaxTimes", "(I)V", "common"})
    public static final class Herdable {
        @NotNull
        private PokemonProperties pokemon = new PokemonProperties();
        @Nullable
        private final IntRange levelRange;
        @Nullable
        private IntRange levelRangeOffset;
        @Nullable
        private DropTable dropTable;
        @Nullable
        private Boolean isLeader;
        private float weight = 1.0f;
        private int maxTimes = 10;

        @NotNull
        public final PokemonProperties getPokemon() {
            return this.pokemon;
        }

        public final void setPokemon(@NotNull PokemonProperties pokemonProperties) {
            Intrinsics.checkNotNullParameter((Object)pokemonProperties, (String)"<set-?>");
            this.pokemon = pokemonProperties;
        }

        @Nullable
        public final IntRange getLevelRange() {
            return this.levelRange;
        }

        @Nullable
        public final IntRange getLevelRangeOffset() {
            return this.levelRangeOffset;
        }

        public final void setLevelRangeOffset(@Nullable IntRange intRange) {
            this.levelRangeOffset = intRange;
        }

        @Nullable
        public final DropTable getDropTable() {
            return this.dropTable;
        }

        public final void setDropTable(@Nullable DropTable dropTable) {
            this.dropTable = dropTable;
        }

        @Nullable
        public final Boolean isLeader() {
            return this.isLeader;
        }

        public final void setLeader(@Nullable Boolean bl) {
            this.isLeader = bl;
        }

        public final float getWeight() {
            return this.weight;
        }

        public final void setWeight(float f) {
            this.weight = f;
        }

        public final int getMaxTimes() {
            return this.maxTimes;
        }

        public final void setMaxTimes(int n) {
            this.maxTimes = n;
        }
    }
}

