/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.detail;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.feature.SeasonFeatureHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u001c\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u001e\u001a\u0004\b\u001f\u0010 R\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0017R$\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010\u0019R$\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010\u001bR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u0010\u001d\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/PokemonSpawnAction;", "Lcom/cobblemon/mod/common/api/spawning/detail/SingleEntitySpawnAction;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucket", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "detail", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "props", "Lnet/minecraft/world/item/ItemStack;", "heldItem", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "drops", "Lkotlin/ranges/IntRange;", "levelRange", "<init>", "(Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/api/drop/DropTable;Lkotlin/ranges/IntRange;)V", "createEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "", "updatePokemon", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;)V", "updateHeldItem", "(Lnet/minecraft/world/item/ItemStack;)V", "updateDrops", "(Lcom/cobblemon/mod/common/api/drop/DropTable;)V", "updateLevelRange", "(Lkotlin/ranges/IntRange;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "getDetail", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getProps", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "setProps", "Lnet/minecraft/world/item/ItemStack;", "getHeldItem", "()Lnet/minecraft/world/item/ItemStack;", "setHeldItem", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "getDrops", "()Lcom/cobblemon/mod/common/api/drop/DropTable;", "setDrops", "Lkotlin/ranges/IntRange;", "getLevelRange", "()Lkotlin/ranges/IntRange;", "setLevelRange", "common"})
public final class PokemonSpawnAction
extends SingleEntitySpawnAction<PokemonEntity> {
    @NotNull
    private final SpawnDetail detail;
    @NotNull
    private PokemonProperties props;
    @Nullable
    private ItemStack heldItem;
    @Nullable
    private DropTable drops;
    @NotNull
    private IntRange levelRange;

    public PokemonSpawnAction(@NotNull SpawnablePosition spawnablePosition, @NotNull SpawnBucket bucket, @NotNull SpawnDetail detail, @NotNull PokemonProperties props, @Nullable ItemStack heldItem, @Nullable DropTable drops, @NotNull IntRange levelRange) {
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)levelRange, (String)"levelRange");
        super(spawnablePosition, bucket, detail);
        this.detail = detail;
        this.props = props;
        this.heldItem = heldItem;
        this.drops = drops;
        this.levelRange = levelRange;
    }

    public /* synthetic */ PokemonSpawnAction(SpawnablePosition spawnablePosition, SpawnBucket spawnBucket, SpawnDetail spawnDetail, PokemonProperties pokemonProperties, ItemStack itemStack, DropTable dropTable, IntRange intRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            dropTable = null;
        }
        this(spawnablePosition, spawnBucket, spawnDetail, pokemonProperties, itemStack, dropTable, intRange);
    }

    @Override
    @NotNull
    public SpawnDetail getDetail() {
        return this.detail;
    }

    @NotNull
    public final PokemonProperties getProps() {
        return this.props;
    }

    public final void setProps(@NotNull PokemonProperties pokemonProperties) {
        Intrinsics.checkNotNullParameter((Object)pokemonProperties, (String)"<set-?>");
        this.props = pokemonProperties;
    }

    @Nullable
    public final ItemStack getHeldItem() {
        return this.heldItem;
    }

    public final void setHeldItem(@Nullable ItemStack itemStack) {
        this.heldItem = itemStack;
    }

    @Nullable
    public final DropTable getDrops() {
        return this.drops;
    }

    public final void setDrops(@Nullable DropTable dropTable) {
        this.drops = dropTable;
    }

    @NotNull
    public final IntRange getLevelRange() {
        return this.levelRange;
    }

    public final void setLevelRange(@NotNull IntRange intRange) {
        Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
        this.levelRange = intRange;
    }

    @Override
    @NotNull
    public PokemonEntity createEntity() {
        PokemonProperties props = this.props.copy();
        props.setLevel(RangesKt.random((IntRange)this.levelRange, (Random)((Random)Random.Default)));
        Entity entity = this.getSpawnablePosition().getCause().getEntity();
        ServerPlayer sourcePlayer = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        PokemonEntity entity2 = props.createEntity((Level)this.getSpawnablePosition().getWorld(), sourcePlayer);
        entity2.setSpawnCause(this.getSpawnablePosition().getCause());
        SeasonFeatureHandler.INSTANCE.updateSeason(entity2.getPokemon(), Cobblemon.INSTANCE.getSeasonResolver().invoke((LevelAccessor)this.getSpawnablePosition().getWorld(), this.getSpawnablePosition().getPosition()));
        ItemStack heldItem = this.heldItem;
        if (!Intrinsics.areEqual((Object)heldItem, (Object)ItemStack.EMPTY) && heldItem != null) {
            Pokemon.swapHeldItem$default(entity2.getPokemon(), heldItem, false, false, 6, null);
        }
        entity2.setDrops(this.drops);
        return entity2;
    }

    public final void updatePokemon(@NotNull PokemonProperties props) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        this.props = props;
    }

    public final void updateHeldItem(@NotNull ItemStack heldItem) {
        Intrinsics.checkNotNullParameter((Object)heldItem, (String)"heldItem");
        this.heldItem = heldItem;
    }

    public final void updateDrops(@NotNull DropTable drops) {
        Intrinsics.checkNotNullParameter((Object)drops, (String)"drops");
        this.drops = drops;
    }

    public final void updateLevelRange(@NotNull IntRange levelRange) {
        Intrinsics.checkNotNullParameter((Object)levelRange, (String)"levelRange");
        this.levelRange = levelRange;
    }
}

