/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.prospecting;

import com.cobblemon.mod.common.CobblemonPoiTypes;
import com.cobblemon.mod.common.api.spawning.influence.SaccharineLogSlatheredInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpatialSpawningZoneInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpawningZoneInfluence;
import com.cobblemon.mod.common.api.spawning.influence.detector.SpawningInfluenceDetector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.math.SimpleMathExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/api/spawning/prospecting/SaccharineLogSlatheredDetector;", "Lcom/cobblemon/mod/common/api/spawning/influence/detector/SpawningInfluenceDetector;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;", "input", "", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningZoneInfluence;", "detectFromInput", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;)Ljava/util/List;", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "", "detectFromBlock", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Ljava/util/List;", "", "RANGE", "I", "common"})
public final class SaccharineLogSlatheredDetector
implements SpawningInfluenceDetector {
    @NotNull
    public static final SaccharineLogSlatheredDetector INSTANCE = new SaccharineLogSlatheredDetector();
    @JvmField
    public static final int RANGE = 32;

    private SaccharineLogSlatheredDetector() {
    }

    @Override
    @NotNull
    public List<SpawningZoneInfluence> detectFromInput(@NotNull Spawner spawner, @NotNull SpawningZoneInput input) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ServerLevel world = input.getWorld();
        List listOfInfluences = new ArrayList();
        int searchRange = RANGE + (int)Math.ceil(Math.sqrt(SimpleMathExtensionsKt.pow(input.getLength(), 2) + SimpleMathExtensionsKt.pow(input.getWidth(), 2)));
        BlockPos centerPos = Vec3ExtensionsKt.toBlockPos(input.getCenter());
        List honeyLogPositions = world.getPoiManager().findAll(SaccharineLogSlatheredDetector::detectFromInput$lambda$0, SaccharineLogSlatheredDetector::detectFromInput$lambda$1, centerPos, searchRange, PoiManager.Occupancy.ANY).toList();
        for (BlockPos pos : honeyLogPositions) {
            Intrinsics.checkNotNull((Object)pos);
            listOfInfluences.add(new SpatialSpawningZoneInfluence(pos, RANGE, new SaccharineLogSlatheredInfluence(pos)));
        }
        return listOfInfluences;
    }

    @Override
    @NotNull
    public List<SpawningZoneInfluence> detectFromBlock(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return CollectionsKt.emptyList();
    }

    private static final boolean detectFromInput$lambda$0(Holder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return holder.is(CobblemonPoiTypes.SACCHARINE_LOG_SLATHERED_KEY);
    }

    private static final boolean detectFromInput$lambda$1(BlockPos it) {
        return true;
    }
}

