/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.BottomlessPosition;
import com.cobblemon.mod.common.api.storage.InvalidSpeciesException;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\u0015J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010&\u001a\u00020\u00002\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010,\u001a\u00020\u00002\u0006\u0010)\u001a\u00020(2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b,\u0010-J\u001d\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020.2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b/\u00100J\u001f\u00101\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b1\u00102J\u0015\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b03H\u0016\u00a2\u0006\u0004\b4\u00105J!\u00107\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u00022\b\u00106\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b7\u00108J\u0017\u00109\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b9\u0010:R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010;\u001a\u0004\b<\u0010=R\u001d\u00106\u001a\b\u0012\u0004\u0012\u00020\b0>8\u0006\u00a2\u0006\f\n\u0004\b6\u0010?\u001a\u0004\b@\u0010AR\u001d\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001b038\u0006\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u00105\u00a8\u0006E"}, d2={"Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;", "Ljava/util/UUID;", "uuid", "<init>", "(Ljava/util/UUID;)V", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "iterator", "()Ljava/util/Iterator;", "position", "get", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;)Z", "", "index", "(I)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "", "Lnet/minecraft/server/level/ServerPlayer;", "getObservingPlayers", "()Ljava/util/Set;", "player", "", "sendTo", "(Lnet/minecraft/server/level/ServerPlayer;)V", "initialize", "()V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "saveToNBT", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/CompoundTag;", "loadFromNBT", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "Lcom/google/gson/JsonObject;", "json", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/core/RegistryAccess;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/nbt/CompoundTag;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;Lnet/minecraft/nbt/CompoundTag;)V", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "pokemon", "setAtPosition", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "onPokemonChanged", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "", "Ljava/util/List;", "getPokemon", "()Ljava/util/List;", "storeChangeObservable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getStoreChangeObservable", "common"})
@SourceDebugExtension(value={"SMAP\nBottomlessStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BottomlessStore.kt\ncom/cobblemon/mod/common/api/storage/BottomlessStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1#2:125\n1878#3,3:126\n1878#3,3:129\n1878#3,3:132\n*S KotlinDebug\n*F\n+ 1 BottomlessStore.kt\ncom/cobblemon/mod/common/api/storage/BottomlessStore\n*L\n46#1:126,3\n52#1:129,3\n72#1:132,3\n*E\n"})
public class BottomlessStore
extends PokemonStore<BottomlessPosition> {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final List<Pokemon> pokemon;
    @NotNull
    private final SimpleObservable<Unit> storeChangeObservable;

    public BottomlessStore(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.uuid = uuid;
        this.pokemon = new ArrayList();
        this.storeChangeObservable = new SimpleObservable();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final List<Pokemon> getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final SimpleObservable<Unit> getStoreChangeObservable() {
        return this.storeChangeObservable;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return this.pokemon.iterator();
    }

    @Override
    @Nullable
    public Pokemon get(@NotNull BottomlessPosition position) {
        Pokemon pokemon;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Integer n2 = position.getCurrentIndex();
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = (0 <= it ? it < ((Collection)this.pokemon).size() : false) ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            pokemon = this.pokemon.get(it);
        } else {
            pokemon = null;
        }
        return pokemon;
    }

    @Override
    @NotNull
    public BottomlessPosition getFirstAvailablePosition() {
        return new BottomlessPosition(this.pokemon.size());
    }

    @Override
    public boolean isValidPosition(@NotNull BottomlessPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return position.getCurrentIndex() >= 0;
    }

    @Override
    @Nullable
    public final Pokemon get(int index) {
        Pokemon pokemon;
        Integer n = index;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = (0 <= it ? it < ((Collection)this.pokemon).size() : false) ? n : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            pokemon = this.pokemon.get(it);
        } else {
            pokemon = null;
        }
        return pokemon;
    }

    @NotNull
    public Set<ServerPlayer> getObservingPlayers() {
        return SetsKt.emptySet();
    }

    @Override
    public void sendTo(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        Iterable $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this, new BottomlessPosition(index)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompoundTag saveToNBT(@NotNull CompoundTag nbt, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Iterable $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            nbt.put("Slot" + index, (Tag)Pokemon.saveToNBT$default((Pokemon)pokemon, registryAccess, null, 2, null));
        }
        return nbt;
    }

    @NotNull
    public BottomlessStore loadFromNBT(@NotNull CompoundTag nbt, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int i = -1;
        while (nbt.contains("Slot" + ++i)) {
            CompoundTag pokemonNBT = nbt.getCompound("Slot" + i);
            try {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.pokemon.add(Pokemon.Companion.loadFromNBT(registryAccess, pokemonNBT));
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.handleInvalidSpeciesNBT(pokemonNBT);
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to read a pok\u00e9mon: " + pokemonNBT, (Throwable)e);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Iterable $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            json.add("Slot" + index, (JsonElement)Pokemon.saveToJSON$default((Pokemon)pokemon, registryAccess, null, 2, null));
        }
        return json;
    }

    @NotNull
    public BottomlessStore loadFromJSON(@NotNull JsonObject json, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int i = -1;
        while (json.has("Slot" + ++i)) {
            JsonObject pokemonJSON = json.getAsJsonObject("Slot" + i);
            try {
                Intrinsics.checkNotNull((Object)pokemonJSON);
                this.pokemon.add(Pokemon.Companion.loadFromJSON(registryAccess, pokemonJSON));
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonJSON);
                this.handleInvalidSpeciesJSON(pokemonJSON);
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to read a pok\u00e9mon: " + pokemonJSON, (Throwable)e);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public StoreCoordinates<BottomlessPosition> loadPositionFromNBT(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        byte slot = nbt.getByte("Slot");
        return new StoreCoordinates<StorePosition>(this, new BottomlessPosition(slot));
    }

    @Override
    public void savePositionToNBT(@NotNull BottomlessPosition position, @NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putByte("Slot", (byte)position.getCurrentIndex());
    }

    @NotNull
    public SimpleObservable<Unit> getAnyChangeObservable() {
        return this.storeChangeObservable;
    }

    @Override
    protected void setAtPosition(@NotNull BottomlessPosition position, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (position.getCurrentIndex() == this.pokemon.size() && pokemon != null) {
            this.pokemon.add(pokemon);
            Unit[] unitArray = new Unit[]{Unit.INSTANCE};
            this.storeChangeObservable.emit((Unit[])unitArray);
        } else {
            int n = this.pokemon.size();
            int n2 = position.getCurrentIndex();
            boolean bl = 0 <= n2 ? n2 < n : false;
            if (bl) {
                int startIndex = position.getCurrentIndex();
                if (pokemon != null) {
                    this.pokemon.add(position.getCurrentIndex(), pokemon);
                    v1 = ++startIndex;
                } else {
                    v1 = this.pokemon.remove(position.getCurrentIndex());
                }
                int n3 = this.pokemon.size();
                for (int i = startIndex; i < n3; ++i) {
                    this.pokemon.get(i).getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this, new BottomlessPosition(i)));
                }
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.storeChangeObservable.emit((Unit[])unitArray);
            }
        }
    }

    @Override
    public void onPokemonChanged(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.storeChangeObservable.emit((Unit[])unitArray);
    }
}

