/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.party;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.InvalidSpeciesException;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.SwapClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.InitializePartyPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.MoveClientPartyPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.SetPartyPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d0\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u000b\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u000b\u00a2\u0006\u0004\b#\u0010\"J\r\u0010$\u001a\u00020\u0019\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b'\u0010(J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u0017\u0010)\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010*J\u001d\u0010-\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010-\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b-\u00101J\u000f\u00102\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b4\u00105J\u0015\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001c\u00a2\u0006\u0004\b6\u0010 J3\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001c\"\b\b\u0000\u00108*\u0002072\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u000009\u00a2\u0006\u0004\b;\u0010<J\u001f\u0010A\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u001f\u0010C\u001a\u00020\u00002\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bC\u0010DJ\u001f\u0010G\u001a\u00020E2\u0006\u0010F\u001a\u00020E2\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bG\u0010HJ\u001f\u0010I\u001a\u00020\u00002\u0006\u0010F\u001a\u00020E2\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bI\u0010JJ\r\u0010K\u001a\u00020\u0012\u00a2\u0006\u0004\bK\u00103J\u001d\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00020L2\u0006\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\bM\u0010NJ\u001f\u0010O\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\bO\u0010PJ\u0015\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00120QH\u0016\u00a2\u0006\u0004\bR\u0010SJ\r\u0010T\u001a\u00020\u0012\u00a2\u0006\u0004\bT\u00103J\r\u0010U\u001a\u00020\u0012\u00a2\u0006\u0004\bU\u00103J\r\u0010W\u001a\u00020V\u00a2\u0006\u0004\bW\u0010XJ5\u0010]\u001a\b\u0012\u0004\u0012\u00020\\0\u001c2\b\b\u0002\u0010Y\u001a\u00020\u00192\b\b\u0002\u0010Z\u001a\u00020\u00192\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0004\b]\u0010^J\r\u0010_\u001a\u00020\u0012\u00a2\u0006\u0004\b_\u00103R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010`\u001a\u0004\ba\u0010bR\"\u0010d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0c8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bd\u0010e\u001a\u0004\bf\u0010 R \u0010h\u001a\b\u0012\u0004\u0012\u00020\u00120g8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bh\u0010i\u001a\u0004\bR\u0010jR(\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00030c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010e\u001a\u0004\bl\u0010 \"\u0004\bm\u0010nR\u001d\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00000o8\u0006\u00a2\u0006\f\n\u0004\bp\u0010q\u001a\u0004\br\u0010s\u00a8\u0006t"}, d2={"Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "Ljava/util/UUID;", "uuid", "<init>", "(Ljava/util/UUID;)V", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "iterator", "()Ljava/util/Iterator;", "", "slot", "get", "(I)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "position", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "set", "(ILcom/cobblemon/mod/common/pokemon/Pokemon;)V", "setAtPosition", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)Z", "", "Lnet/minecraft/server/level/ServerPlayer;", "kotlin.jvm.PlatformType", "getObservingPlayers", "()Ljava/util/List;", "size", "()I", "occupied", "isEmpty", "()Z", "player", "sendTo", "(Lnet/minecraft/server/level/ServerPlayer;)V", "remove", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "slot1", "slot2", "swap", "(II)V", "position1", "position2", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "initialize", "()V", "onPokemonChanged", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "toGappyList", "", "T", "Lkotlin/Function1;", "mapper", "mapNullPreserving", "(Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "saveToNBT", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/CompoundTag;", "loadFromNBT", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Lcom/google/gson/JsonObject;", "json", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/core/RegistryAccess;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "removeDuplicates", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/nbt/CompoundTag;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lnet/minecraft/nbt/CompoundTag;)V", "Lcom/cobblemon/mod/common/api/reactive/Observable;", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/Observable;", "heal", "didSleep", "", "getHealingRemainderPercent", "()F", "clone", "healPokemon", "leadingPokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "toBattleTeam", "(ZZLjava/util/UUID;)Ljava/util/List;", "clearParty", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "", "slots", "Ljava/util/List;", "getSlots", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "anyChangeObservable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observerUUIDs", "getObserverUUIDs", "setObserverUUIDs", "(Ljava/util/List;)V", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "struct", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "getStruct", "()Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "common"})
@SourceDebugExtension(value={"SMAP\nPartyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartyStore.kt\ncom/cobblemon/mod/common/api/storage/party/PartyStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n1#2:311\n774#3:287\n865#3,2:288\n1878#3,3:290\n1563#3:293\n1634#3,3:294\n1869#3,2:297\n1869#3,2:299\n1617#3,9:301\n1869#3:310\n1870#3:312\n1626#3:313\n1869#3,2:314\n*S KotlinDebug\n*F\n+ 1 PartyStore.kt\ncom/cobblemon/mod/common/api/storage/party/PartyStore\n*L\n261#1:311\n82#1:287\n82#1:288,2\n94#1:290,3\n150#1:293\n150#1:294,3\n244#1:297,2\n248#1:299,2\n261#1:301,9\n261#1:310\n261#1:312\n261#1:313\n280#1:314,2\n*E\n"})
public class PartyStore
extends PokemonStore<PartyPosition> {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final List<Pokemon> slots;
    @NotNull
    private final SimpleObservable<Unit> anyChangeObservable;
    @NotNull
    private List<UUID> observerUUIDs;
    @NotNull
    private final ObjectValue<PartyStore> struct;

    public PartyStore(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.uuid = uuid;
        int n = 6;
        PartyStore partyStore = this;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(null);
        }
        partyStore.slots = arrayList;
        this.anyChangeObservable = new SimpleObservable();
        this.observerUUIDs = new ArrayList();
        this.struct = MoLangFunctions.INSTANCE.asMoLangValue(this);
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    protected final List<Pokemon> getSlots() {
        return this.slots;
    }

    @NotNull
    protected final SimpleObservable<Unit> getAnyChangeObservable() {
        return this.anyChangeObservable;
    }

    @NotNull
    public final List<UUID> getObserverUUIDs() {
        return this.observerUUIDs;
    }

    public final void setObserverUUIDs(@NotNull List<UUID> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.observerUUIDs = list;
    }

    @NotNull
    public final ObjectValue<PartyStore> getStruct() {
        return this.struct;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return CollectionsKt.filterNotNull((Iterable)this.slots).iterator();
    }

    @Override
    @Nullable
    public final Pokemon get(int slot) {
        Pokemon pokemon;
        Integer n = slot;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it < this.slots.size() && it >= 0 ? n : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            pokemon = this.slots.get(it);
        } else {
            pokemon = null;
        }
        return pokemon;
    }

    @Override
    @Nullable
    public Pokemon get(@NotNull PartyPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.get(position.getSlot());
    }

    @Override
    public final void set(int slot, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.set(new PartyPosition(slot), pokemon);
    }

    @Override
    protected void setAtPosition(@NotNull PartyPosition position, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (position.getSlot() >= this.slots.size()) {
            throw new IllegalArgumentException("Slot position is out of bounds");
        }
        this.slots.set(position.getSlot(), pokemon);
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.anyChangeObservable.emit((Unit[])unitArray);
    }

    @Override
    @Nullable
    public PartyPosition getFirstAvailablePosition() {
        int n = ((Collection)this.slots).size();
        for (int i = 0; i < n; ++i) {
            if (this.slots.get(i) != null) continue;
            return new PartyPosition(i);
        }
        return null;
    }

    @Override
    public boolean isValidPosition(@NotNull PartyPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.slots.size();
        int n2 = position.getSlot();
        return 0 <= n2 ? n2 < n : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ServerPlayer> getObservingPlayers() {
        List list;
        Object object = DistributionUtilsKt.server();
        if (object != null && (object = object.getPlayerList()) != null && (object = object.getPlayers()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerPlayer it = (ServerPlayer)element$iv$iv;
                boolean bl = false;
                if (!this.observerUUIDs.contains(it.getUUID())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final int size() {
        return this.slots.size();
    }

    public final int occupied() {
        return ((Collection)CollectionsKt.filterNotNull((Iterable)this.slots)).size();
    }

    public final boolean isEmpty() {
        return this.occupied() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendTo(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CobblemonNetwork.INSTANCE.sendPacket(player, new InitializePartyPacket(false, this.getUuid(), this.slots.size()));
        Iterable $this$forEachIndexed$iv = this.slots;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            if (pokemon == null) continue;
            CobblemonNetwork.INSTANCE.sendPacket(player, new SetPartyPokemonPacket(this.getUuid(), new PartyPosition(index), (Function1<? super RegistryAccess, ? extends Pokemon>)((Function1)arg_0 -> PartyStore.sendTo$lambda$0$0((Pokemon)pokemon, arg_0))));
        }
    }

    @Override
    public void set(@NotNull PartyPosition position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        super.set((StorePosition)position, pokemon);
        this.sendPacketToObservers(new SetPartyPokemonPacket(this.getUuid(), position, (Function1<? super RegistryAccess, ? extends Pokemon>)((Function1)arg_0 -> PartyStore.set$lambda$0(pokemon, arg_0))));
    }

    @Override
    public boolean remove(@NotNull Pokemon pokemon) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (super.remove(pokemon)) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final void swap(int slot1, int slot2) {
        block4: {
            block3: {
                boolean bl = 0 <= slot1 ? slot1 < ((Collection)this.slots).size() : false;
                if (!bl) break block3;
                if (0 <= slot2 ? slot2 < ((Collection)this.slots).size() : false) break block4;
            }
            return;
        }
        this.swap(new PartyPosition(slot1), new PartyPosition(slot2));
    }

    @Override
    public void swap(@NotNull PartyPosition position1, @NotNull PartyPosition position2) {
        Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
        Pokemon pokemon1 = this.get(position1);
        Pokemon pokemon2 = this.get(position2);
        super.swap((StorePosition)position1, (StorePosition)position2);
        if (pokemon1 != null && pokemon2 != null) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon1.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            UUID uUID2 = pokemon2.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new SwapClientPokemonPacket(pokemonStore, uUID, uUID2));
        } else if (pokemon1 != null || pokemon2 != null) {
            PartyPosition newPosition = pokemon1 == null ? position1 : position2;
            Pokemon pokemon = pokemon1;
            if (pokemon == null) {
                Pokemon pokemon3 = pokemon2;
                pokemon = pokemon3;
                Intrinsics.checkNotNull((Object)pokemon3);
            }
            Pokemon pokemon4 = pokemon;
            UUID uUID = this.getUuid();
            UUID uUID3 = pokemon4.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new MoveClientPartyPokemonPacket(uUID, uUID3, newPosition));
        }
    }

    @Override
    public void initialize() {
        int n = ((Collection)this.slots).size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon;
            if (this.get(slot) == null) continue;
            pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this, new PartyPosition(slot)));
        }
    }

    @Override
    public void onPokemonChanged(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.anyChangeObservable.emit((Unit[])unitArray);
    }

    @NotNull
    public final List<Pokemon> toGappyList() {
        return CollectionsKt.toList((Iterable)this.slots);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> mapNullPreserving(@NotNull Function1<? super Pokemon, ? extends T> mapper) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Iterable $this$map$iv = this.toGappyList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pokemon pokemon = (Pokemon)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 != null ? mapper.invoke((Object)v0) : null);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CompoundTag saveToNBT(@NotNull CompoundTag nbt, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        nbt.putInt("SlotCount", this.slots.size());
        int n = ((Collection)this.slots).size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon = this.get(slot);
            if (pokemon == null) continue;
            nbt.put("Slot" + slot, (Tag)Pokemon.saveToNBT$default(pokemon, registryAccess, null, 2, null));
        }
        return nbt;
    }

    @NotNull
    public PartyStore loadFromNBT(@NotNull CompoundTag nbt, @NotNull RegistryAccess registryAccess) {
        int slotCount;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Integer n = nbt.getInt("SlotCount");
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = (1 <= it ? it < 7 : false) ? n : null;
        int n3 = slotCount = n2 != null ? n2 : 6;
        while (slotCount < this.slots.size()) {
            this.slots.removeLast();
        }
        while (slotCount > this.slots.size()) {
            this.slots.add(null);
        }
        int n4 = ((Collection)this.slots).size();
        for (int slot = 0; slot < n4; ++slot) {
            CompoundTag pokemonNBT = nbt.getCompound("Slot" + slot);
            try {
                if (pokemonNBT.isEmpty()) continue;
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.slots.set(slot, Pokemon.Companion.loadFromNBT(registryAccess, pokemonNBT));
                continue;
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.handleInvalidSpeciesNBT(pokemonNBT);
                continue;
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to read a pok\u00e9mon: " + pokemonNBT, (Throwable)e);
            }
        }
        this.removeDuplicates();
        return this;
    }

    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        json.addProperty("SlotCount", (Number)this.slots.size());
        int n = ((Collection)this.slots).size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon = this.get(slot);
            if (pokemon == null) continue;
            json.add("Slot" + slot, (JsonElement)Pokemon.saveToJSON$default(pokemon, registryAccess, null, 2, null));
        }
        return json;
    }

    @NotNull
    public PartyStore loadFromJSON(@NotNull JsonObject json, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int slotCount = json.get("SlotCount").getAsInt();
        while (slotCount > this.slots.size()) {
            this.slots.removeLast();
        }
        while (slotCount < this.slots.size()) {
            this.slots.add(null);
        }
        int n = ((Collection)this.slots).size();
        for (int slot = 0; slot < n; ++slot) {
            String key = "Slot" + slot;
            if (!json.has(key)) continue;
            JsonObject pokemonJSON = json.get(key).getAsJsonObject();
            try {
                Intrinsics.checkNotNull((Object)pokemonJSON);
                this.slots.set(slot, Pokemon.Companion.loadFromJSON(registryAccess, pokemonJSON));
                continue;
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonJSON);
                this.handleInvalidSpeciesJSON(pokemonJSON);
                continue;
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to read a pok\u00e9mon: " + pokemonJSON, (Throwable)e);
            }
        }
        this.removeDuplicates();
        return this;
    }

    public final void removeDuplicates() {
        List knownUUIDs = new ArrayList();
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon;
            if (this.get(slot) == null) continue;
            if (!knownUUIDs.contains(pokemon.getUuid())) {
                UUID uUID = pokemon.getUuid();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
                knownUUIDs.add(uUID);
                continue;
            }
            this.slots.set(slot, null);
            Unit[] unitArray = new Unit[]{Unit.INSTANCE};
            this.anyChangeObservable.emit((Unit[])unitArray);
        }
    }

    @Override
    @NotNull
    public StoreCoordinates<PartyPosition> loadPositionFromNBT(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        byte slot = nbt.getByte("Slot");
        return new StoreCoordinates<StorePosition>(this, new PartyPosition(slot));
    }

    @Override
    public void savePositionToNBT(@NotNull PartyPosition position, @NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putByte("Slot", (byte)position.getSlot());
    }

    @Override
    @NotNull
    public Observable<Unit> getAnyChangeObservable() {
        return this.anyChangeObservable;
    }

    public final void heal() {
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            it.heal();
        }
    }

    public final void didSleep() {
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            it.didSleep();
        }
    }

    public final float getHealingRemainderPercent() {
        float totalPercent = 0.0f;
        for (Pokemon pokemon : this) {
            totalPercent += 1.0f - (float)pokemon.getCurrentHealth() / (float)pokemon.getMaxHealth();
        }
        return totalPercent;
    }

    @JvmOverloads
    @NotNull
    public final List<BattlePokemon> toBattleTeam(boolean clone, boolean healPokemon, @Nullable UUID leadingPokemon) {
        List result;
        block5: {
            Object v0;
            block4: {
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    BattlePokemon it$iv$iv;
                    BattlePokemon battlePokemon;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Pokemon it = (Pokemon)element$iv$iv;
                    boolean bl2 = false;
                    BattlePokemon it2 = battlePokemon = clone ? BattlePokemon.Companion.safeCopyOf(it) : BattlePokemon.Companion.playerOwned(it);
                    boolean bl3 = false;
                    if (healPokemon) {
                        it2.getEffectedPokemon().heal();
                    }
                    if (battlePokemon == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                result = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if (leadingPokemon == null || Intrinsics.areEqual((Object)((BattlePokemon)CollectionsKt.first((List)result)).getUuid(), (Object)leadingPokemon)) break block5;
                $this$mapNotNullTo$iv$iv = result;
                for (Object e : $this$mapNotNullTo$iv$iv) {
                    BattlePokemon it = (BattlePokemon)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)leadingPokemon)) continue;
                    v0 = e;
                    break block4;
                }
                v0 = null;
            }
            BattlePokemon battlePokemon = v0;
            if (battlePokemon != null) {
                BattlePokemon lead = battlePokemon;
                boolean bl = false;
                result.remove(lead);
                result.add(0, lead);
            }
        }
        return result;
    }

    public static /* synthetic */ List toBattleTeam$default(PartyStore partyStore, boolean bl, boolean bl2, UUID uUID, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toBattleTeam");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            uUID = null;
        }
        return partyStore.toBattleTeam(bl, bl2, uUID);
    }

    public final void clearParty() {
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            it.tryRecallWithAnimation();
            this.remove(it);
        }
    }

    @JvmOverloads
    @NotNull
    public final List<BattlePokemon> toBattleTeam(boolean clone, boolean healPokemon) {
        return PartyStore.toBattleTeam$default(this, clone, healPokemon, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<BattlePokemon> toBattleTeam(boolean clone) {
        return PartyStore.toBattleTeam$default(this, clone, false, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final List<BattlePokemon> toBattleTeam() {
        return PartyStore.toBattleTeam$default(this, false, false, null, 7, null);
    }

    private static final Pokemon sendTo$lambda$0$0(Pokemon $pokemon, RegistryAccess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pokemon;
    }

    private static final Pokemon set$lambda$0(Pokemon $pokemon, RegistryAccess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pokemon;
    }
}

