/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.ChallengeManager;
import com.cobblemon.mod.common.net.messages.client.battle.TeamJoinNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamMemberAddNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamMemberRemoveNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamRequestExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamRequestNotificationPacket;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000201B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u001b\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\u00072\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001b\"\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010%\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b(\u0010\u0017R\u0014\u0010*\u001a\u00020)8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b*\u0010+R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010.\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/battles/TeamManager;", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "getTeam", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "Ljava/util/UUID;", "teamID", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "request", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "(Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "teamEntry", "", "disbandTeam", "(Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;)V", "removeTeamMember", "(Lnet/minecraft/server/level/ServerPlayer;)V", "team", "joinTeam", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;)V", "", "players", "createTeam", "([Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "onAccept", "(Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;)V", "", "canAccept", "(Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;)Z", "target", "isValidInteraction", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;)Z", "sender", "onLogoff", "", "MAX_TEAM_MEMBER_COUNT", "I", "", "playerToTeam", "Ljava/util/Map;", "multiBattleTeams", "TeamRequest", "MultiBattleTeam", "common"})
@SourceDebugExtension(value={"SMAP\nTeamManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,201:1\n1617#2,9:202\n1869#2:211\n1870#2:213\n1626#2:214\n1869#2,2:215\n1869#2,2:217\n1869#2,2:220\n1617#2,9:222\n1869#2:231\n1870#2:233\n1626#2:234\n1869#2,2:235\n1617#2,9:237\n1869#2:246\n1870#2:248\n1626#2:249\n1869#2,2:251\n1#3:212\n1#3:219\n1#3:232\n1#3:247\n1#3:264\n13805#4:250\n13806#4:253\n11879#4,9:254\n13805#4:263\n13806#4:265\n11888#4:266\n13805#4,2:267\n*S KotlinDebug\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager\n*L\n81#1:202,9\n81#1:211\n81#1:213\n81#1:214\n82#1:215,2\n85#1:217,2\n93#1:220,2\n111#1:222,9\n111#1:231\n111#1:233\n111#1:234\n120#1:235,2\n135#1:237,9\n135#1:246\n135#1:248\n135#1:249\n144#1:251,2\n81#1:212\n111#1:232\n135#1:247\n153#1:264\n143#1:250\n143#1:253\n153#1:254,9\n153#1:263\n153#1:265\n153#1:266\n156#1:267,2\n*E\n"})
public final class TeamManager
extends RequestManager<TeamRequest> {
    @NotNull
    public static final TeamManager INSTANCE = new TeamManager();
    public static final int MAX_TEAM_MEMBER_COUNT = 2;
    @NotNull
    private static final Map<UUID, MultiBattleTeam> playerToTeam;
    @NotNull
    private static final Map<UUID, MultiBattleTeam> multiBattleTeams;

    private TeamManager() {
    }

    @Nullable
    public final MultiBattleTeam getTeam(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return playerToTeam.get(player.getUUID());
    }

    @Nullable
    public final MultiBattleTeam getTeam(@NotNull UUID teamID) {
        Intrinsics.checkNotNullParameter((Object)teamID, (String)"teamID");
        return multiBattleTeams.get(teamID);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> notificationPacket(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TeamRequestNotificationPacket(request);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> expirationPacket(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TeamRequestExpiredPacket(request);
    }

    public final void disbandTeam(@NotNull MultiBattleTeam teamEntry) {
        Iterator $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)teamEntry, (String)"teamEntry");
        Iterable $this$mapNotNull$iv = teamEntry.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TeamRequest it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UUID member = (UUID)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)member);
            if ((TeamRequest)INSTANCE.getOutboundRequest(member) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pendingTeamRequests = (List)destination$iv$iv;
        Iterable $this$forEach$iv = pendingTeamRequests;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            TeamRequest it = (TeamRequest)element$iv;
            boolean bl = false;
            RequestManager.cancelRequest$default(INSTANCE, it, false, 2, null);
        }
        List list = ChallengeManager.INSTANCE.getInboundRequests(teamEntry.getTeamID());
        if (list != null) {
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ChallengeManager.BattleChallenge it = (ChallengeManager.BattleChallenge)element$iv;
                boolean bl = false;
                ChallengeManager.INSTANCE.declineRequest((ServerPlayerActionRequest)it);
            }
        }
        ChallengeManager.BattleChallenge battleChallenge = (ChallengeManager.BattleChallenge)ChallengeManager.INSTANCE.getOutboundRequest(teamEntry.getTeamID());
        if (battleChallenge != null) {
            ChallengeManager.BattleChallenge it = battleChallenge;
            boolean bl = false;
            RequestManager.cancelRequest$default(ChallengeManager.INSTANCE, it, false, 2, null);
        }
        $this$forEach$iv = teamEntry.getTeamPlayersUUID();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer it;
            UUID member = (UUID)element$iv;
            boolean bl = false;
            playerToTeam.remove(member);
            Intrinsics.checkNotNull((Object)member);
            if (PlayerExtensionsKt.getPlayer(member) == null) continue;
            boolean bl4 = false;
            UUID uUID = it.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            CobblemonNetwork.INSTANCE.sendPacketToPlayer(it, new TeamMemberRemoveNotificationPacket(uUID));
        }
        multiBattleTeams.remove(teamEntry.getTeamID());
    }

    /*
     * WARNING - void declaration
     */
    public final void removeTeamMember(@NotNull ServerPlayer player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MultiBattleTeam multiBattleTeam = playerToTeam.get(player.getUUID());
        if (multiBattleTeam == null) {
            return;
        }
        MultiBattleTeam teamEntry = multiBattleTeam;
        teamEntry.getTeamPlayers().remove(player);
        playerToTeam.remove(player.getUUID());
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        TeamMemberRemoveNotificationPacket notificationPacket = new TeamMemberRemoveNotificationPacket(uUID);
        CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, notificationPacket);
        Iterable $this$mapNotNull$iv = teamEntry.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ServerPlayer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (PlayerExtensionsKt.getPlayer(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List teamServerPlayers = (List)destination$iv$iv;
        CobblemonNetwork.sendPacketToPlayers(teamServerPlayers, notificationPacket);
        if (((Collection)teamEntry.getTeamPlayersUUID()).size() == 1) {
            this.disbandTeam(teamEntry);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void joinTeam(@NotNull ServerPlayer player, @NotNull MultiBattleTeam team) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        List list = this.getInboundRequests(uUID);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                TeamRequest it = (TeamRequest)element$iv2;
                boolean bl = false;
                RequestManager.cancelRequest$default(INSTANCE, it, false, 2, null);
            }
        }
        UUID uUID2 = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        MutableComponent mutableComponent = player.getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        TeamMemberAddNotificationPacket teamNotifyPacket = new TeamMemberAddNotificationPacket(uUID2, mutableComponent);
        CobblemonNetwork.sendPacketToPlayers((Iterable<? extends ServerPlayer>)team.getTeamPlayers(), teamNotifyPacket);
        team.getTeamPlayers().add(player);
        UUID uUID3 = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        playerToTeam.put(uUID3, team);
        Iterable $i$f$forEach = team.getTeamPlayers();
        List<UUID> list2 = team.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MutableComponent it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl2 = false;
            if (it.getName().plainCopy() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List<UUID> list4 = list2;
        TeamJoinNotificationPacket joinerPacket = new TeamJoinNotificationPacket(list4, list3);
        CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, joinerPacket);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiBattleTeam createTeam(ServerPlayer ... players) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean $i$f$forEach;
        ServerPlayer element$iv;
        Intrinsics.checkNotNullParameter((Object)players, (String)"players");
        ServerPlayer[] $this$forEach$iv = players;
        boolean $i$f$forEach2 = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ServerPlayer it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            UUID uUID = it.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            List list = INSTANCE.getInboundRequests(uUID);
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TeamRequest it2 = (TeamRequest)element$iv2;
                boolean bl2 = false;
                RequestManager.cancelRequest$default(INSTANCE, it2, false, 2, null);
            }
        }
        MultiBattleTeam team = new MultiBattleTeam(Arrays.copyOf(players, players.length));
        multiBattleTeams.put(team.getTeamID(), team);
        ServerPlayer[] serverPlayerArray = players;
        List<UUID> list = team.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        element$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        int n2 = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            MutableComponent it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            if (it.getName().plainCopy() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List<UUID> list3 = list;
        TeamJoinNotificationPacket joinerPacket = new TeamJoinNotificationPacket(list3, list2);
        ServerPlayer[] $this$forEach$iv3 = players;
        boolean $i$f$forEach3 = false;
        int n3 = $this$forEach$iv3.length;
        for (int i = 0; i < n3; ++i) {
            ServerPlayer element$iv3;
            ServerPlayer it = element$iv3 = $this$forEach$iv3[i];
            boolean bl = false;
            UUID uUID = it.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            playerToTeam.put(uUID, team);
            CobblemonNetwork.INSTANCE.sendPacketToPlayer(it, joinerPacket);
        }
        return team;
    }

    @Override
    protected void onAccept(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super.onAccept((ServerPlayerActionRequest)request);
        MultiBattleTeam existingTeam = this.getTeam(request.getSender());
        if (existingTeam == null) {
            ServerPlayer[] serverPlayerArray = new ServerPlayer[]{request.getReceiver(), request.getSender()};
            this.createTeam(serverPlayerArray);
        } else {
            this.joinTeam(request.getReceiver(), existingTeam);
        }
    }

    @Override
    protected boolean canAccept(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        MultiBattleTeam existingReceiverTeam = this.getTeam(request.getReceiverID());
        MultiBattleTeam existingSenderTeam = this.getTeam(request.getSenderID());
        if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getSender()))) {
            request.notifySender(true, "error.no_pokemon", new Object[0]);
            request.notifyReceiver(true, "error.no_pokemon", new Object[0]);
        } else if (existingReceiverTeam != null) {
            Object[] objectArray = new Object[1];
            MutableComponent mutableComponent = request.getReceiver().getName().copy();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(mutableComponent);
            request.notifySender(true, "error.existing_team.other", objectArray);
            request.notifyReceiver(true, "error.existing_team.self", new Object[0]);
        } else if (existingSenderTeam != null && ((Collection)existingSenderTeam.getTeamPlayersUUID()).size() >= 2) {
            Object[] objectArray = new Object[1];
            MutableComponent mutableComponent = request.getReceiver().getName().copy();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(mutableComponent);
            request.notifySender(true, "error.max_team_size.other", objectArray);
            request.notifyReceiver(true, "error.max_team_size.self", new Object[0]);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidInteraction(@NotNull ServerPlayer player, @NotNull ServerPlayer target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return PlayerExtensionsKt.canInteractWith(player, (LivingEntity)target, Cobblemon.INSTANCE.getConfig().getTradeMaxDistance());
    }

    @Override
    protected void onLogoff(@NotNull ServerPlayer sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        super.onLogoff(sender);
        this.removeTeamMember(sender);
    }

    static {
        RequestManager.Companion.register(INSTANCE);
        playerToTeam = new LinkedHashMap();
        multiBattleTeams = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u0018\u0010\nR\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001f\u0010!\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00190\u00190\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\n\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "", "", "Lnet/minecraft/server/level/ServerPlayer;", "teamPlayers", "<init>", "(Ljava/util/List;)V", "", "([Lnet/minecraft/server/level/ServerPlayer;)V", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getTeamPlayers", "Ljava/util/UUID;", "teamID", "Ljava/util/UUID;", "getTeamID", "()Ljava/util/UUID;", "", "kotlin.jvm.PlatformType", "getTeamPlayersUUID", "teamPlayersUUID", "common"})
    @SourceDebugExtension(value={"SMAP\nTeamManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1563#2:202\n1634#2,3:203\n*S KotlinDebug\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam\n*L\n63#1:202\n63#1:203,3\n*E\n"})
    public static final class MultiBattleTeam {
        @NotNull
        private final List<ServerPlayer> teamPlayers;
        @NotNull
        private final UUID teamID;

        public MultiBattleTeam(@NotNull List<ServerPlayer> teamPlayers) {
            Intrinsics.checkNotNullParameter(teamPlayers, (String)"teamPlayers");
            this.teamPlayers = teamPlayers;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.teamID = uUID;
        }

        @NotNull
        public final List<ServerPlayer> getTeamPlayers() {
            return this.teamPlayers;
        }

        public MultiBattleTeam(ServerPlayer ... teamPlayers) {
            Intrinsics.checkNotNullParameter((Object)teamPlayers, (String)"teamPlayers");
            this(ArraysKt.toMutableList((Object[])teamPlayers));
        }

        @NotNull
        public final UUID getTeamID() {
            return this.teamID;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<UUID> getTeamPlayersUUID() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.teamPlayers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ServerPlayer serverPlayer = (ServerPlayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUUID());
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<ServerPlayer> component1() {
            return this.teamPlayers;
        }

        @NotNull
        public final MultiBattleTeam copy(@NotNull List<ServerPlayer> teamPlayers) {
            Intrinsics.checkNotNullParameter(teamPlayers, (String)"teamPlayers");
            return new MultiBattleTeam(teamPlayers);
        }

        public static /* synthetic */ MultiBattleTeam copy$default(MultiBattleTeam multiBattleTeam, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = multiBattleTeam.teamPlayers;
            }
            return multiBattleTeam.copy(list);
        }

        @NotNull
        public String toString() {
            return "MultiBattleTeam(teamPlayers=" + this.teamPlayers + ")";
        }

        public int hashCode() {
            return ((Object)this.teamPlayers).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MultiBattleTeam)) {
                return false;
            }
            MultiBattleTeam multiBattleTeam = (MultiBattleTeam)other;
            return Intrinsics.areEqual(this.teamPlayers, multiBattleTeam.teamPlayers);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001b\u0010\nR\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u001a\u0010\u001e\u001a\u00020\u00168\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0018R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;", "Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "Lnet/minecraft/server/level/ServerPlayer;", "sender", "receiver", "", "expiryTime", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;I)V", "component1", "()Lnet/minecraft/server/level/ServerPlayer;", "component2", "component3", "()I", "copy", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;I)Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/server/level/ServerPlayer;", "getSender", "getReceiver", "I", "getExpiryTime", "key", "Ljava/lang/String;", "getKey", "Ljava/util/UUID;", "requestID", "Ljava/util/UUID;", "getRequestID", "()Ljava/util/UUID;", "common"})
    public static final class TeamRequest
    implements ServerPlayerActionRequest {
        @NotNull
        private final ServerPlayer sender;
        @NotNull
        private final ServerPlayer receiver;
        private final int expiryTime;
        @NotNull
        private final String key;
        @NotNull
        private final UUID requestID;

        public TeamRequest(@NotNull ServerPlayer sender, @NotNull ServerPlayer receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            this.sender = sender;
            this.receiver = receiver;
            this.expiryTime = expiryTime;
            this.key = "team";
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.requestID = uUID;
        }

        public /* synthetic */ TeamRequest(ServerPlayer serverPlayer, ServerPlayer serverPlayer2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 60;
            }
            this(serverPlayer, serverPlayer2, n);
        }

        @Override
        @NotNull
        public ServerPlayer getSender() {
            return this.sender;
        }

        @Override
        @NotNull
        public ServerPlayer getReceiver() {
            return this.receiver;
        }

        @Override
        public int getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public UUID getRequestID() {
            return this.requestID;
        }

        @NotNull
        public final ServerPlayer component1() {
            return this.sender;
        }

        @NotNull
        public final ServerPlayer component2() {
            return this.receiver;
        }

        public final int component3() {
            return this.expiryTime;
        }

        @NotNull
        public final TeamRequest copy(@NotNull ServerPlayer sender, @NotNull ServerPlayer receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            return new TeamRequest(sender, receiver, expiryTime);
        }

        public static /* synthetic */ TeamRequest copy$default(TeamRequest teamRequest, ServerPlayer serverPlayer, ServerPlayer serverPlayer2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                serverPlayer = teamRequest.sender;
            }
            if ((n2 & 2) != 0) {
                serverPlayer2 = teamRequest.receiver;
            }
            if ((n2 & 4) != 0) {
                n = teamRequest.expiryTime;
            }
            return teamRequest.copy(serverPlayer, serverPlayer2, n);
        }

        @NotNull
        public String toString() {
            return "TeamRequest(sender=" + this.sender + ", receiver=" + this.receiver + ", expiryTime=" + this.expiryTime + ")";
        }

        public int hashCode() {
            int result = this.sender.hashCode();
            result = result * 31 + this.receiver.hashCode();
            result = result * 31 + Integer.hashCode(this.expiryTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TeamRequest)) {
                return false;
            }
            TeamRequest teamRequest = (TeamRequest)other;
            if (!Intrinsics.areEqual((Object)this.sender, (Object)teamRequest.sender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiver, (Object)teamRequest.receiver)) {
                return false;
            }
            return this.expiryTime == teamRequest.expiryTime;
        }
    }
}

