/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSeenEvent;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.dispatch.BattleDispatch;
import com.cobblemon.mod.common.battles.dispatch.DispatchResult;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.dispatch.WaitDispatch;
import com.cobblemon.mod.common.battles.interpreter.instructions.TransformInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.effects.IllusionEffect;
import com.cobblemon.mod.common.net.messages.client.battle.BattleSwitchPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/SwitchInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "instructionSet", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "battleActor", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "publicMessage", "privateMessage", "<init>", "(Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "getInstructionSet", "()Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getBattleActor", "()Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPublicMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPrivateMessage", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nSwitchInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitchInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/SwitchInstruction\n+ 2 InstructionSet.kt\ncom/cobblemon/mod/common/battles/dispatch/InstructionSet\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 InstructionSet.kt\ncom/cobblemon/mod/common/battles/dispatch/InstructionSet$getNextInstruction$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n42#2,6:228\n808#3,11:234\n295#3:245\n296#3:247\n808#3,11:248\n1869#3:259\n1869#3:260\n1869#3,2:261\n1870#3:263\n1870#3:264\n774#3:266\n865#3,2:267\n1869#3,2:269\n42#4:246\n1#5:265\n*S KotlinDebug\n*F\n+ 1 SwitchInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/SwitchInstruction\n*L\n55#1:228,6\n55#1:234,11\n55#1:245\n55#1:247\n97#1:248,11\n102#1:259\n104#1:260\n105#1:261,2\n104#1:263\n102#1:264\n137#1:266\n137#1:267,2\n137#1:269,2\n55#1:246\n*E\n"})
public final class SwitchInstruction
implements InterpreterInstruction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstructionSet instructionSet;
    @NotNull
    private final BattleActor battleActor;
    @NotNull
    private final BattleMessage publicMessage;
    @NotNull
    private final BattleMessage privateMessage;

    public SwitchInstruction(@NotNull InstructionSet instructionSet, @NotNull BattleActor battleActor, @NotNull BattleMessage publicMessage, @NotNull BattleMessage privateMessage) {
        Intrinsics.checkNotNullParameter((Object)instructionSet, (String)"instructionSet");
        Intrinsics.checkNotNullParameter((Object)battleActor, (String)"battleActor");
        Intrinsics.checkNotNullParameter((Object)publicMessage, (String)"publicMessage");
        Intrinsics.checkNotNullParameter((Object)privateMessage, (String)"privateMessage");
        this.instructionSet = instructionSet;
        this.battleActor = battleActor;
        this.publicMessage = publicMessage;
        this.privateMessage = privateMessage;
    }

    @NotNull
    public final InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    @NotNull
    public final BattleActor getBattleActor() {
        return this.battleActor;
    }

    @NotNull
    public final BattleMessage getPublicMessage() {
        return this.publicMessage;
    }

    @NotNull
    public final BattleMessage getPrivateMessage() {
        return this.privateMessage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Object v1;
        LivingEntity entity;
        ActiveBattlePokemon activePokemon;
        BattleActor actor;
        String pnx;
        block14: {
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
            Pair<String, String> pair = this.publicMessage.pnxAndUuid(0);
            if (pair == null) {
                return;
            }
            Pair<String, String> pair2 = pair;
            pnx = (String)pair2.component1();
            String pokemonID = (String)pair2.component2();
            Pair<BattleActor, ActiveBattlePokemon> pair3 = battle.getActorAndActiveSlotFromPNX(pnx);
            actor = (BattleActor)pair3.component1();
            activePokemon = (ActiveBattlePokemon)pair3.component2();
            entity = actor instanceof EntityBackedBattleActor ? (LivingEntity)((EntityBackedBattleActor)((Object)actor)).getEntity() : null;
            InstructionSet instructionSet = this.instructionSet;
            InterpreterInstruction comparedTo$iv = this;
            boolean $i$f$getNextInstruction = false;
            int index$iv = $this$iv.getInstructions().indexOf(comparedTo$iv);
            if (Intrinsics.areEqual((Object)CollectionsKt.last($this$iv.getInstructions()), (Object)comparedTo$iv)) {
                v1 = null;
            } else {
                void $this$firstOrNull$iv$iv;
                Iterator $this$filterIsInstanceTo$iv$iv$iv;
                Iterable $this$filterIsInstance$iv$iv = $this$iv.getInstructions().subList(index$iv + 1, $this$iv.getInstructions().size());
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator = $this$filterIsInstanceTo$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv = iterator.next();
                    if (!(element$iv$iv$iv instanceof TransformInstruction)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Object t = element$iv$iv;
                    boolean bl = false;
                    Object it = t;
                    if (!true) continue;
                    v1 = element$iv$iv;
                    break block14;
                }
                v1 = null;
            }
        }
        TransformInstruction transformInstruction = v1;
        boolean imposter = (transformInstruction != null ? transformInstruction.getExpectedTarget() : null) != null;
        BattlePokemon illusion = this.publicMessage.battlePokemonFromOptional(battle, "is");
        BattlePokemon battlePokemon = this.publicMessage.battlePokemon(0, battle);
        if (battlePokemon == null) {
            return;
        }
        BattlePokemon pokemon = battlePokemon;
        if (!battle.getStarted()) {
            void $this$filterIsInstanceTo$iv$iv;
            battle.dispatchToFront((Function0<? extends DispatchResult>)((Function0)() -> SwitchInstruction.invoke$lambda$0(pokemon, actor, illusion, battle, entity, activePokemon, pnx)));
            Iterable $this$filterIsInstance$iv = this.instructionSet.getSubsequentInstructions(this);
            boolean $i$f$filterIsInstance = false;
            Iterable index$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SwitchInstruction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List futureSwitches = (List)destination$iv$iv;
            if (futureSwitches.isEmpty() && battle.getFormat().getAdjustLevel() > 0) {
                boolean waitOnRecall = false;
                Iterable<BattleActor> $this$forEach$iv = battle.getActors();
                boolean $i$f$forEach = false;
                Iterator<BattleActor> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Iterable<UUID> playerUUIDS;
                    BattleActor element$iv;
                    BattleActor it = element$iv = iterator.next();
                    boolean bl = false;
                    Iterable<UUID> $this$forEach$iv2 = playerUUIDS = it.getPlayerUUIDs();
                    boolean $i$f$forEach2 = false;
                    for (Object e : $this$forEach$iv2) {
                        UUID uuid = (UUID)e;
                        boolean bl2 = false;
                        Object object = PlayerExtensionsKt.getPlayer(uuid);
                        if (object == null || (object = PlayerExtensionsKt.party(object)) == null) continue;
                        Iterable $this$forEach$iv3 = (Iterable)object;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            Pokemon pokemon2 = (Pokemon)element$iv3;
                            boolean bl3 = false;
                            if (pokemon2.getEntity() == null) continue;
                            waitOnRecall = true;
                            PokemonEntity pokemonEntity = pokemon2.getEntity();
                            Intrinsics.checkNotNull((Object)pokemonEntity);
                            pokemonEntity.recallWithAnimation();
                        }
                    }
                }
                if (waitOnRecall) {
                    battle.dispatchWaitingToFront(1.5f, (Function0<Unit>)((Function0)SwitchInstruction::invoke$lambda$2));
                }
            }
        } else {
            battle.dispatchInsert((Function0<? extends Iterable<? extends BattleDispatch>>)((Function0)() -> SwitchInstruction.invoke$lambda$3(this, pokemon, activePokemon, battle, actor, entity, pnx, illusion, imposter)));
        }
    }

    private static final DispatchResult invoke$lambda$0(BattlePokemon $pokemon, BattleActor $actor, BattlePokemon $illusion, PokemonBattle $battle, LivingEntity $entity, ActiveBattlePokemon $activePokemon, String $pnx) {
        PokemonEntity pokemonEntity = $pokemon.getEntity();
        if (pokemonEntity != null && !($actor instanceof PokemonBattleActor)) {
            BattlePokemon battlePokemon = $illusion;
            if (battlePokemon != null) {
                BattlePokemon it = battlePokemon;
                boolean bl = false;
                new IllusionEffect(it.getEffectedPokemon()).start(pokemonEntity);
            }
            SwitchInstruction.Companion.broadcastSwitch($battle, $actor, $pokemon, $illusion);
            new WaitDispatch(0.5f);
        } else if (pokemonEntity == null && $entity != null) {
            $activePokemon.setBattlePokemon($pokemon);
            $activePokemon.setIllusion($illusion);
            Vec3 targetPos = $activePokemon.getSendOutPosition();
            if (targetPos != null) {
                int battleSendoutCount = CharsKt.digitToInt((char)$activePokemon.getActorShowdownId().charAt(1)) - 1 + $actor.getStillSendingOutCount();
                int n = $actor.getStillSendingOutCount();
                $actor.setStillSendingOutCount(n + 1);
                PokemonBattle.sendSidedUpdate$default($battle, $actor, new BattleSwitchPokemonPacket($pnx, $pokemon, true, $illusion), new BattleSwitchPokemonPacket($pnx, $pokemon, false, $illusion), false, 8, null);
                SwitchInstruction.Companion.broadcastSwitch($battle, $actor, $pokemon, $illusion);
                SchedulingFunctionsKt.afterOnServer((float)battleSendoutCount * 0.35f + (battleSendoutCount > 0 ? Random.Default.nextFloat() * 0.15f : 0.0f), (Function0<Unit>)((Function0)() -> SwitchInstruction.invoke$lambda$0$1($pokemon, $entity, $battle, targetPos, $illusion, $actor)));
            }
        }
        return DispatchResultKt.getGO();
    }

    private static final Unit invoke$lambda$0$1(BattlePokemon $pokemon, LivingEntity $entity, PokemonBattle $battle, Vec3 $targetPos, BattlePokemon $illusion, BattleActor $actor) {
        IllusionEffect illusionEffect;
        Pokemon pokemon = $pokemon.getEffectedPokemon();
        LivingEntity livingEntity = $entity;
        UUID uUID = $battle.getBattleId();
        Level level = $entity.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 vec3 = $targetPos;
        BattlePokemon battlePokemon = $illusion;
        if (battlePokemon != null) {
            BattlePokemon it = battlePokemon;
            boolean bl = false;
            illusionEffect = new IllusionEffect(it.getEffectedPokemon());
        } else {
            illusionEffect = null;
        }
        IllusionEffect illusionEffect2 = illusionEffect;
        Pokemon.sendOutWithAnimation$default(pokemon, livingEntity, serverLevel, vec3, uUID, false, illusionEffect2, null, 64, null).thenApply(arg_0 -> SwitchInstruction.invoke$lambda$0$1$2(arg_0 -> SwitchInstruction.invoke$lambda$0$1$1($actor, arg_0), arg_0));
        new WaitDispatch(0.5f);
        return Unit.INSTANCE;
    }

    private static final Integer invoke$lambda$0$1$1(BattleActor $actor, PokemonEntity it) {
        int n = $actor.getStillSendingOutCount();
        $actor.setStillSendingOutCount(n + -1);
        return n;
    }

    private static final Integer invoke$lambda$0$1$2(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Unit invoke$lambda$2() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable invoke$lambda$3(SwitchInstruction this$0, BattlePokemon $pokemon, ActiveBattlePokemon $activePokemon, PokemonBattle $battle, BattleActor $actor, LivingEntity $entity, String $pnx, BattlePokemon $illusion, boolean $imposter) {
        String string = this$0.privateMessage.argumentAt(2);
        Intrinsics.checkNotNull((Object)string);
        String[] stringArray = new String[]{" "};
        String newHealth = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        String[] stringArray2 = new String[]{"/"};
        int remainingHealth = Integer.parseInt((String)StringsKt.split$default((CharSequence)newHealth, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0));
        $pokemon.getEffectedPokemon().setCurrentHealth(remainingHealth);
        $pokemon.sendUpdate();
        if (Intrinsics.areEqual((Object)$activePokemon.getBattlePokemon(), (Object)$pokemon)) {
            return SetsKt.emptySet();
        }
        BattlePokemon battlePokemon = $activePokemon.getBattlePokemon();
        if (battlePokemon != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            BattleContext.Type[] typeArray;
            BattlePokemon oldPokemon = battlePokemon;
            boolean bl = false;
            Effect effect = BattleMessage.effect$default(this$0.publicMessage, null, 1, null);
            if (Intrinsics.areEqual((Object)(effect != null ? effect.getId() : null), (Object)"batonpass")) {
                typeArray = new BattleContext.Type[]{BattleContext.Type.BOOST, BattleContext.Type.UNBOOST};
                oldPokemon.getContextManager().swap($pokemon.getContextManager(), typeArray);
            }
            typeArray = new BattleContext.Type[]{BattleContext.Type.VOLATILE, BattleContext.Type.BOOST, BattleContext.Type.UNBOOST};
            oldPokemon.getContextManager().clear(typeArray);
            ((Map)$battle.getMajorBattleActions()).put(oldPokemon.getUuid(), this$0.publicMessage);
            BattlePokemon battlePokemon2 = $activePokemon.getIllusion();
            if (battlePokemon2 == null) {
                battlePokemon2 = oldPokemon;
            }
            MutableComponent publicName = Pokemon.getDisplayName$default(battlePokemon2.getEffectedPokemon(), false, 1, null);
            Object[] objectArray = new Object[]{publicName};
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("withdraw.self", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            $actor.sendMessage((Component)mutableComponent);
            Iterable $this$filter$iv = $battle.getActors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BattleActor it = (BattleActor)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)$actor))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BattleActor it = (BattleActor)element$iv;
                boolean bl3 = false;
                Object[] objectArray2 = new Object[]{$actor.getName(), publicName};
                MutableComponent mutableComponent2 = LocalizationUtilsKt.battleLang("withdraw.other", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"battleLang(...)");
                it.sendMessage((Component)mutableComponent2);
            }
        }
        ((Map)$battle.getMajorBattleActions()).put($pokemon.getUuid(), this$0.publicMessage);
        return SetsKt.setOf(arg_0 -> SwitchInstruction.invoke$lambda$3$1($entity, $battle, $actor, $pnx, $activePokemon, $pokemon, $illusion, $imposter, arg_0));
    }

    private static final DispatchResult invoke$lambda$3$1(LivingEntity $entity, PokemonBattle $battle, BattleActor $actor, String $pnx, ActiveBattlePokemon $activePokemon, BattlePokemon $pokemon, BattlePokemon $illusion, boolean $imposter, PokemonBattle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $entity != null ? Companion.createEntitySwitch($battle, $actor, $entity, $pnx, $activePokemon, $pokemon, $illusion, $imposter) : Companion.createNonEntitySwitch($battle, $actor, $pnx, $activePokemon, $pokemon, $illusion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JS\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015JA\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0016\u0010\u0017J1\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/SwitchInstruction$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actor", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "", "pnx", "Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;", "activePokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "newPokemon", "illusion", "", "imposter", "Lcom/cobblemon/mod/common/battles/dispatch/DispatchResult;", "createEntitySwitch", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/String;Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Z)Lcom/cobblemon/mod/common/battles/dispatch/DispatchResult;", "createNonEntitySwitch", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Ljava/lang/String;Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)Lcom/cobblemon/mod/common/battles/dispatch/DispatchResult;", "", "broadcastSwitch", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "common"})
    @SourceDebugExtension(value={"SMAP\nSwitchInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitchInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/SwitchInstruction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n774#2:228\n865#2,2:229\n1869#2,2:231\n1869#2:233\n1870#2:243\n14#3,5:234\n19#3:242\n13805#4:239\n13806#4:241\n14#5:240\n1#6:244\n*S KotlinDebug\n*F\n+ 1 SwitchInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/SwitchInstruction$Companion\n*L\n218#1:228\n218#1:229,2\n218#1:231,2\n221#1:233\n221#1:243\n222#1:234,5\n222#1:242\n222#1:239\n222#1:241\n222#1:240\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DispatchResult createEntitySwitch(@NotNull PokemonBattle battle, @NotNull BattleActor actor, @NotNull LivingEntity entity, @NotNull String pnx, @NotNull ActiveBattlePokemon activePokemon, @NotNull BattlePokemon newPokemon, @Nullable BattlePokemon illusion, boolean imposter) {
            Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)pnx, (String)"pnx");
            Intrinsics.checkNotNullParameter((Object)activePokemon, (String)"activePokemon");
            Intrinsics.checkNotNullParameter((Object)newPokemon, (String)"newPokemon");
            BattlePokemon battlePokemon = activePokemon.getBattlePokemon();
            PokemonEntity pokemonEntity = battlePokemon != null ? battlePokemon.getEntity() : null;
            CompletableFuture sendOutFuture = new CompletableFuture();
            Object object = pokemonEntity;
            if (object == null || (object = ((PokemonEntity)object).recallWithAnimation()) == null) {
                object = CompletableFuture.completedFuture(Unit.INSTANCE);
            }
            ((CompletableFuture)object).thenApply(arg_0 -> Companion.createEntitySwitch$lambda$1(arg_0 -> Companion.createEntitySwitch$lambda$0(actor, activePokemon, newPokemon, illusion, battle, pnx, entity, imposter, sendOutFuture, arg_0), arg_0));
            return new UntilDispatch((Function0<Boolean>)((Function0)() -> Companion.createEntitySwitch$lambda$2(sendOutFuture)));
        }

        public static /* synthetic */ DispatchResult createEntitySwitch$default(Companion companion, PokemonBattle pokemonBattle, BattleActor battleActor, LivingEntity livingEntity, String string, ActiveBattlePokemon activeBattlePokemon, BattlePokemon battlePokemon, BattlePokemon battlePokemon2, boolean bl, int n, Object object) {
            if ((n & 0x40) != 0) {
                battlePokemon2 = null;
            }
            if ((n & 0x80) != 0) {
                bl = false;
            }
            return companion.createEntitySwitch(pokemonBattle, battleActor, livingEntity, string, activeBattlePokemon, battlePokemon, battlePokemon2, bl);
        }

        @NotNull
        public final DispatchResult createNonEntitySwitch(@NotNull PokemonBattle battle, @NotNull BattleActor actor, @NotNull String pnx, @NotNull ActiveBattlePokemon activePokemon, @NotNull BattlePokemon newPokemon, @Nullable BattlePokemon illusion) {
            Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            Intrinsics.checkNotNullParameter((Object)pnx, (String)"pnx");
            Intrinsics.checkNotNullParameter((Object)activePokemon, (String)"activePokemon");
            Intrinsics.checkNotNullParameter((Object)newPokemon, (String)"newPokemon");
            CollectionUtilsKt.swap(actor.getPokemonList(), actor.getActivePokemon().indexOf(activePokemon), actor.getPokemonList().indexOf(newPokemon));
            activePokemon.setBattlePokemon(newPokemon);
            activePokemon.setIllusion(illusion);
            PokemonBattle.sendSidedUpdate$default(battle, actor, new BattleSwitchPokemonPacket(pnx, newPokemon, true, illusion), new BattleSwitchPokemonPacket(pnx, newPokemon, false, illusion), false, 8, null);
            this.broadcastSwitch(battle, actor, newPokemon, illusion);
            return new WaitDispatch(1.5f);
        }

        public static /* synthetic */ DispatchResult createNonEntitySwitch$default(Companion companion, PokemonBattle pokemonBattle, BattleActor battleActor, String string, ActiveBattlePokemon activeBattlePokemon, BattlePokemon battlePokemon, BattlePokemon battlePokemon2, int n, Object object) {
            if ((n & 0x20) != 0) {
                battlePokemon2 = null;
            }
            return companion.createNonEntitySwitch(pokemonBattle, battleActor, string, activeBattlePokemon, battlePokemon, battlePokemon2);
        }

        /*
         * WARNING - void declaration
         */
        private final void broadcastSwitch(PokemonBattle battle, BattleActor actor, BattlePokemon newPokemon, BattlePokemon illusion) {
            Iterable<UUID> $this$forEach$iv;
            PokemonSeenEvent[] it;
            void $this$filterTo$iv$iv;
            Object object;
            Pokemon publicPokemon;
            MutableComponent mutableComponent;
            block9: {
                block8: {
                    BattlePokemon battlePokemon = illusion;
                    if (battlePokemon == null) {
                        battlePokemon = newPokemon;
                    }
                    if ((mutableComponent = (publicPokemon = battlePokemon.getEffectedPokemon()).getNickname()) == null) break block8;
                    MutableComponent mutableComponent2 = mutableComponent;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{actor.getName(), mutableComponent2, publicPokemon.getSpecies().getTranslatedName()};
                    MutableComponent mutableComponent3 = LocalizationUtilsKt.battleLang("switch.other.nickname", objectArray);
                    mutableComponent = mutableComponent3;
                    if (mutableComponent3 != null) break block9;
                }
                object = new Object[]{actor.getName(), publicPokemon.getDisplayName(true)};
                mutableComponent = LocalizationUtilsKt.battleLang("switch.other", (Object[])object);
            }
            MutableComponent publicLang = mutableComponent;
            Object[] objectArray = new Object[]{publicPokemon.getDisplayName(true)};
            MutableComponent mutableComponent4 = LocalizationUtilsKt.battleLang("switch.self", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"battleLang(...)");
            actor.sendMessage((Component)mutableComponent4);
            Iterable $this$filter$iv = battle.getActors();
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Collection collection = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PokemonSeenEvent[])element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)actor))) continue;
                collection.add(element$iv$iv);
            }
            $this$filter$iv = (List)collection;
            boolean $i$f$forEach = false;
            for (Object e : $this$forEach$iv) {
                BattleActor it2 = (BattleActor)e;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)publicLang);
                it2.sendMessage((Component)publicLang);
            }
            $this$forEach$iv = battle.getPlayerUUIDs();
            $i$f$forEach = false;
            for (Object e : $this$forEach$iv) {
                void $this$iv;
                Object element$iv$iv;
                UUID uuid = (UUID)e;
                boolean bl = false;
                element$iv$iv = CobblemonEvents.POKEMON_SEEN;
                it = new PokemonSeenEvent[]{new PokemonSeenEvent(uuid, publicPokemon)};
                PokemonSeenEvent[] events$iv = it;
                boolean $i$f$post = false;
                $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
                PokemonSeenEvent[] $this$forEach$iv$iv = events$iv;
                boolean $i$f$forEach2 = false;
                int n = $this$forEach$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    PokemonSeenEvent element$iv$iv2;
                    PokemonSeenEvent pokemonSeenEvent = element$iv$iv2 = $this$forEach$iv$iv[i];
                    boolean bl2 = false;
                    PokemonSeenEvent it3 = pokemonSeenEvent;
                }
            }
        }

        private static final Unit createEntitySwitch$lambda$0(BattleActor $actor, ActiveBattlePokemon $activePokemon, BattlePokemon $newPokemon, BattlePokemon $illusion, PokemonBattle $battle, String $pnx, LivingEntity $entity, boolean $imposter, CompletableFuture $sendOutFuture, Object it) {
            CollectionUtilsKt.swap($actor.getPokemonList(), $actor.getActivePokemon().indexOf($activePokemon), $actor.getPokemonList().indexOf($newPokemon));
            $activePokemon.setBattlePokemon($newPokemon);
            $activePokemon.setIllusion($illusion);
            PokemonBattle.sendSidedUpdate$default($battle, $actor, new BattleSwitchPokemonPacket($pnx, $newPokemon, true, $illusion), new BattleSwitchPokemonPacket($pnx, $newPokemon, false, $illusion), false, 8, null);
            PokemonEntity newEntity = $newPokemon.getEntity();
            if (newEntity != null) {
                BattlePokemon battlePokemon = $illusion;
                if (battlePokemon != null) {
                    BattlePokemon it2 = battlePokemon;
                    boolean bl = false;
                    new IllusionEffect(it2.getEffectedPokemon()).start(newEntity);
                }
                v1 = SchedulingFunctionsKt.afterOnServer(1.5f, (Function0<Unit>)((Function0)() -> Companion.createEntitySwitch$lambda$0$1($imposter, $newPokemon, $sendOutFuture)));
            } else {
                IllusionEffect illusionEffect;
                Vec3 vec3;
                Object object;
                if ($battle.getFormat().getBattleType().getPokemonPerSide() == 1) {
                    object = $activePokemon.getSendOutPosition();
                } else {
                    Pair<ServerLevel, Vec3> pair = $activePokemon.getPosition();
                    object = vec3 = pair != null ? (Vec3)pair.getSecond() : null;
                }
                if (object == null) {
                    vec3 = $entity.position();
                }
                Vec3 pos = vec3;
                Level level = $entity.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel world = (ServerLevel)level;
                Pokemon pokemon = $newPokemon.getEffectedPokemon();
                UUID uUID = $battle.getBattleId();
                Intrinsics.checkNotNull((Object)pos);
                Vec3 vec32 = pos;
                boolean bl = !$imposter;
                BattlePokemon battlePokemon = $illusion;
                if (battlePokemon != null) {
                    BattlePokemon it3 = battlePokemon;
                    boolean bl2 = false;
                    illusionEffect = new IllusionEffect(it3.getEffectedPokemon());
                } else {
                    illusionEffect = null;
                }
                IllusionEffect illusionEffect2 = illusionEffect;
                v1 = Pokemon.sendOutWithAnimation$default(pokemon, $entity, world, vec32, uUID, bl, illusionEffect2, null, 64, null).thenAccept(arg_0 -> Companion.createEntitySwitch$lambda$0$4(arg_0 -> Companion.createEntitySwitch$lambda$0$3($sendOutFuture, arg_0), arg_0));
            }
            Companion.broadcastSwitch($battle, $actor, $newPokemon, $illusion);
            return Unit.INSTANCE;
        }

        private static final Unit createEntitySwitch$lambda$0$1(boolean $imposter, BattlePokemon $newPokemon, CompletableFuture $sendOutFuture) {
            if (!$imposter) {
                PokemonEntity pokemonEntity = $newPokemon.getEntity();
                if (pokemonEntity != null) {
                    pokemonEntity.cry();
                }
            }
            $sendOutFuture.complete(Unit.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createEntitySwitch$lambda$0$3(CompletableFuture $sendOutFuture, PokemonEntity it) {
            $sendOutFuture.complete(Unit.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final void createEntitySwitch$lambda$0$4(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit createEntitySwitch$lambda$1(Function1 $tmp0, Object p0) {
            return (Unit)$tmp0.invoke(p0);
        }

        private static final boolean createEntitySwitch$lambda$2(CompletableFuture $sendOutFuture) {
            return $sendOutFuture.isDone();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

