/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.cobblemon.mod.common.block.GrowableStoneBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B1\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ#\u0010 \u001a\u00020\u001f2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u001dH\u0014\u00a2\u0006\u0004\b \u0010!J\u0019\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J?\u0010+\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/block/TumblestoneBlock;", "Lcom/cobblemon/mod/common/block/GrowableStoneBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "", "stage", "height", "xzOffset", "Lnet/minecraft/world/level/block/Block;", "nextStage", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;IIILnet/minecraft/world/level/block/Block;)V", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/BlockGetter;", "world", "", "canGrow", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockGetter;)Z", "Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/material/FluidState;", "getFluidState", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Companion", "common"})
public final class TumblestoneBlock
extends GrowableStoneBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<TumblestoneBlock> CODEC;

    public TumblestoneBlock(@NotNull BlockBehaviour.Properties settings, int stage, int height, int xzOffset, @Nullable Block nextStage) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, stage, height, xzOffset, nextStage);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canGrow(@NotNull BlockPos pos, @NotNull BlockGetter world) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.getStage() == 3) {
            return false;
        }
        Iterator iterator = BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1)).iterator();
        BlockPos blockPos = null;
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!world.getBlockState(blockPos = (BlockPos)iterator.next()).is(CobblemonBlockTags.TUMBLESTONE_HEAT_SOURCE));
        return true;
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            Intrinsics.checkNotNull((Object)fluidState2);
            fluidState = fluidState2;
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.createBlockStateDefinition(builder);
        Property[] propertyArray = new Property[]{BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState = super.getStateForPlacement(ctx);
        return blockState != null ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)ctx.getLevel().getFluidState(ctx.getClickedPos()).getType(), (Object)Fluids.WATER))) : null;
    }

    @Override
    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)DirectionalBlock.propertiesCodec(), (App)PrimitiveCodec.INT.fieldOf("stage").forGetter(TumblestoneBlock::CODEC$lambda$0$0), (App)PrimitiveCodec.INT.fieldOf("height").forGetter(TumblestoneBlock::CODEC$lambda$0$1), (App)PrimitiveCodec.INT.fieldOf("xzOffset").forGetter(TumblestoneBlock::CODEC$lambda$0$2), (App)Block.CODEC.fieldOf("nextStage").forGetter(TumblestoneBlock::CODEC$lambda$0$3)).apply((Applicative)it, TumblestoneBlock::new);
    }

    private static final Integer CODEC$lambda$0$0(TumblestoneBlock it) {
        return it.getStage();
    }

    private static final Integer CODEC$lambda$0$1(TumblestoneBlock it) {
        return it.getHeight();
    }

    private static final Integer CODEC$lambda$0$2(TumblestoneBlock it) {
        return it.getXzOffset();
    }

    private static final Block CODEC$lambda$0$3(TumblestoneBlock it) {
        return it.getNextStage();
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(TumblestoneBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/block/TumblestoneBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/TumblestoneBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<TumblestoneBlock> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

