/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0017\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\"\u0010#J'\u0010(\u001a\u00020\u00142\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00103\u001a\u00020\u00102\u0006\u00102\u001a\u00020,H\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020\u00102\u0006\u00102\u001a\u00020,2\u0006\u00105\u001a\u00020,H\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020\u00102\u0006\u00102\u001a\u00020,H\u0016\u00a2\u0006\u0004\b8\u00104J\u001f\u0010:\u001a\u00020\u00142\u0006\u00102\u001a\u00020,2\u0006\u00109\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010<\u001a\u00020/2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010A\u001a\u00020@2\u0006\u0010?\u001a\u00020>H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u000f\u0010C\u001a\u00020,H\u0016\u00a2\u0006\u0004\bC\u0010.J)\u0010E\u001a\u00020/2\u0006\u00102\u001a\u00020,2\u0006\u00109\u001a\u00020\u00102\b\u0010D\u001a\u0004\u0018\u00010>H\u0016\u00a2\u0006\u0004\bE\u0010FJ'\u0010H\u001a\u00020/2\u0006\u00102\u001a\u00020,2\u0006\u00109\u001a\u00020\u00102\u0006\u0010G\u001a\u00020>H\u0016\u00a2\u0006\u0004\bH\u0010FR\u001d\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00100I8\u0006\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\u00a8\u0006N"}, d2={"Lcom/cobblemon/mod/common/block/entity/DisplayCaseBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResult;", "updateItem", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/item/ItemStack;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "newStack", "", "setCaseStack", "(Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/world/level/Level;", "world", "oldState", "newState", "onItemUpdated", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V", "clearContent", "()V", "", "getContainerSize", "()I", "", "isEmpty", "()Z", "slot", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "stack", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "getMaxStackSize", "dir", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "direction", "canTakeItemThroughFace", "Lnet/minecraft/core/NonNullList;", "inv", "Lnet/minecraft/core/NonNullList;", "getInv", "()Lnet/minecraft/core/NonNullList;", "common"})
public final class DisplayCaseBlockEntity
extends BlockEntity
implements WorldlyContainer {
    @NotNull
    private final NonNullList<ItemStack> inv;

    public DisplayCaseBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(CobblemonBlockEntities.DISPLAY_CASE, pos, state);
        NonNullList nonNullList = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inv = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getInv() {
        return this.inv;
    }

    @NotNull
    public final InteractionResult updateItem(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack playerStack = player.getItemInHand(hand);
        if (Intrinsics.areEqual((Object)playerStack.getItem(), (Object)this.getStack().getItem())) {
            return !Intrinsics.areEqual((Object)playerStack.getItem(), (Object)Items.AIR) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        if (playerStack.isEmpty() && !this.getStack().isEmpty()) {
            if (!player.isCreative()) {
                player.setItemInHand(hand, this.getStack());
            }
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.setCaseStack(itemStack);
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        if (this.getStack().isEmpty() && !playerStack.isEmpty()) {
            ItemStack itemStack = playerStack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            this.setCaseStack(itemStack);
            playerStack.consume(1, (LivingEntity)player);
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        if (!this.getStack().isEmpty() && !playerStack.isEmpty()) {
            ItemStack oldCaseStack = this.getStack();
            ItemStack itemStack = playerStack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            this.setCaseStack(itemStack);
            if (!player.hasInfiniteMaterials()) {
                playerStack.shrink(1);
                PlayerExtensionsKt.giveOrDropItemStack$default(player, oldCaseStack, false, 2, null);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public final ItemStack getStack() {
        Object object = this.inv.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    private final void setCaseStack(ItemStack newStack) {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        BlockState oldState = level2.getBlockState(this.getBlockPos());
        newStack.setCount(1);
        this.inv.set(0, (Object)newStack);
        if (newStack.isEmpty()) {
            level2.playSound(null, this.getBlockPos(), CobblemonSounds.DISPLAY_CASE_REMOVE_ITEM, SoundSource.BLOCKS);
        } else {
            level2.playSound(null, this.getBlockPos(), CobblemonSounds.DISPLAY_CASE_ADD_ITEM, SoundSource.BLOCKS);
        }
        Intrinsics.checkNotNull((Object)oldState);
        BlockState blockState = level2.getBlockState(this.getBlockPos());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        this.onItemUpdated(level2, oldState, blockState);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inv, (boolean)true, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(nbt, registryLookup);
        this.inv.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inv, (HolderLookup.Provider)registryLookup);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag compoundTag = this.saveWithoutMetadata(registryLookup);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    private final void onItemUpdated(Level world, BlockState oldState, BlockState newState) {
        world.sendBlockUpdated(this.getBlockPos(), oldState, newState, 2);
        world.updateNeighbourForOutputSignal(this.getBlockPos(), world.getBlockState(this.getBlockPos()).getBlock());
        this.setChanged();
    }

    public void clearContent() {
        this.inv.clear();
    }

    public int getContainerSize() {
        return this.inv.size();
    }

    public boolean isEmpty() {
        return this.getStack().isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.getStack();
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        BlockState oldState = this.getBlockState();
        ItemStack result = ContainerHelper.removeItem((List)((List)this.inv), (int)slot, (int)amount);
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)oldState);
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            BlockState blockState = level2.getBlockState(this.getBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            this.onItemUpdated(level, oldState, blockState);
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        BlockState oldState = this.getBlockState();
        ItemStack result = ContainerHelper.takeItem((List)((List)this.inv), (int)slot);
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)oldState);
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            BlockState blockState = level2.getBlockState(this.getBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            this.onItemUpdated(level, oldState, blockState);
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BlockState oldState = this.getBlockState();
        this.inv.set(slot, (Object)stack);
        if (stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)oldState);
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            BlockState blockState = level2.getBlockState(this.getBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            this.onItemUpdated(level, oldState, blockState);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int[] result = new int[this.inv.size()];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = i;
        }
        return result;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction dir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.getStack().isEmpty();
    }

    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return direction == Direction.DOWN;
    }
}

