/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonClientImplementation;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonMenuType;
import com.cobblemon.mod.common.api.berry.Berries;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.scheduling.ClientTaskTracker;
import com.cobblemon.mod.common.api.storage.player.client.ClientGeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.client.ClientPokedexManager;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import com.cobblemon.mod.common.block.entity.TintBlockEntity;
import com.cobblemon.mod.common.client.ClientPlayerTeamData;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.gui.PartyOverlay;
import com.cobblemon.mod.common.client.gui.PartyOverlayDataControl;
import com.cobblemon.mod.common.client.gui.RideControlsOverlay;
import com.cobblemon.mod.common.client.gui.battle.BattleOverlay;
import com.cobblemon.mod.common.client.gui.cookingpot.CookingPotScreen;
import com.cobblemon.mod.common.client.particle.BedrockParticleOptionsRepository;
import com.cobblemon.mod.common.client.render.ClientPlayerIcon;
import com.cobblemon.mod.common.client.render.DeferredRenderer;
import com.cobblemon.mod.common.client.render.block.BerryBlockRenderer;
import com.cobblemon.mod.common.client.render.block.CampfireBlockEntityRenderer;
import com.cobblemon.mod.common.client.render.block.DisplayCaseRenderer;
import com.cobblemon.mod.common.client.render.block.FossilAnalyzerRenderer;
import com.cobblemon.mod.common.client.render.block.GildedChestBlockRenderer;
import com.cobblemon.mod.common.client.render.block.HealingMachineRenderer;
import com.cobblemon.mod.common.client.render.block.LecternBlockEntityRenderer;
import com.cobblemon.mod.common.client.render.block.PokeSnackBlockEntityRenderer;
import com.cobblemon.mod.common.client.render.block.RestorationTankRenderer;
import com.cobblemon.mod.common.client.render.boat.CobblemonBoatRenderer;
import com.cobblemon.mod.common.client.render.color.AprijuiceItemColorProvider;
import com.cobblemon.mod.common.client.render.color.PokeBaitItemColorProvider;
import com.cobblemon.mod.common.client.render.color.PokeSnackItemColorProvider;
import com.cobblemon.mod.common.client.render.color.PonigiriItemColorProvider;
import com.cobblemon.mod.common.client.render.color.SinisterTeaItemColorProvider;
import com.cobblemon.mod.common.client.render.entity.PokeBobberEntityRenderer;
import com.cobblemon.mod.common.client.render.generic.GenericBedrockRenderer;
import com.cobblemon.mod.common.client.render.item.CobblemonBuiltinItemRendererRegistry;
import com.cobblemon.mod.common.client.render.item.PokemonItemRenderer;
import com.cobblemon.mod.common.client.render.layer.PokemonOnShoulderRenderer;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockAnimationRepository;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.BerryModelRepository;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.MiscModelRepository;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.client.render.npc.NPCRenderer;
import com.cobblemon.mod.common.client.render.pokeball.PokeBallRenderer;
import com.cobblemon.mod.common.client.render.pokemon.PokemonRenderer;
import com.cobblemon.mod.common.client.requests.ClientPlayerActionRequests;
import com.cobblemon.mod.common.client.sound.BattleMusicController;
import com.cobblemon.mod.common.client.sound.EntitySoundTracker;
import com.cobblemon.mod.common.client.storage.ClientStorageManager;
import com.cobblemon.mod.common.client.tooltips.AprijuiceTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.CobblemonTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.FishingBaitTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.FishingRodTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.PokePuffTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.RecipeSeasoningAbsorptionTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.SeasoningTooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.TooltipManager;
import com.cobblemon.mod.common.client.trade.ClientTrade;
import com.cobblemon.mod.common.entity.boat.CobblemonBoatType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.AprijuiceItem;
import com.cobblemon.mod.common.platform.events.ClientEntityEvent;
import com.cobblemon.mod.common.platform.events.ClientPlayerEvent;
import com.cobblemon.mod.common.platform.events.ClientTickEvent;
import com.cobblemon.mod.common.platform.events.ItemTooltipEvent;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.pokedex.scanner.PokedexUsageContext;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0003J\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u001a\u001a\u00020\u00042\u001c\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\u0018\u00010\u0015\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u000f\u0010\u001d\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u000f\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u000f\u0010\u001f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010\u0003J\u000f\u0010%\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010\u0003R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\b\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010\nR\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R$\u00100\u001a\u0004\u0018\u00010/8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00107\u001a\u0004\u0018\u0001068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\"\u0010>\u001a\u00020=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\"\u0010E\u001a\u00020D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\"\u0010L\u001a\u00020K8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\"\u0010S\u001a\u00020R8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010T\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\"\u0010Z\u001a\u00020Y8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\"\u0010a\u001a\u00020`8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010b\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\u001b\u0010l\u001a\u00020g8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bh\u0010i\u001a\u0004\bj\u0010kR\u001b\u0010q\u001a\u00020m8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bn\u0010i\u001a\u0004\bo\u0010pR\u001b\u0010v\u001a\u00020r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bs\u0010i\u001a\u0004\bt\u0010uR\u001b\u0010{\u001a\u00020w8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bx\u0010i\u001a\u0004\by\u0010z\u00a8\u0006|"}, d2={"Lcom/cobblemon/mod/common/client/CobblemonClient;", "", "<init>", "()V", "", "onLogin", "onLogout", "Lcom/cobblemon/mod/common/CobblemonClientImplementation;", "implementation", "initialize", "(Lcom/cobblemon/mod/common/CobblemonClientImplementation;)V", "registerTooltipManagers", "registerFlywheelRenderers", "registerColors", "registerBlockRenderTypes", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "partialDeltaTicks", "beforeChatRender", "(Lnet/minecraft/client/gui/GuiGraphics;F)V", "", "Lnet/minecraft/client/resources/PlayerSkin$Model;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Lnet/minecraft/world/entity/player/Player;", "skinMap", "onAddLayer", "(Ljava/util/Map;)V", "registerMenuScreens", "registerBlockEntityRenderers", "registerEntityRenderers", "registerItemColors", "Lnet/minecraft/server/packs/resources/ResourceManager;", "resourceManager", "reloadCodedAssets", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "endBattle", "createBoatModelLayers", "Lcom/cobblemon/mod/common/CobblemonClientImplementation;", "getImplementation", "()Lcom/cobblemon/mod/common/CobblemonClientImplementation;", "setImplementation", "Lcom/cobblemon/mod/common/client/storage/ClientStorageManager;", "storage", "Lcom/cobblemon/mod/common/client/storage/ClientStorageManager;", "getStorage", "()Lcom/cobblemon/mod/common/client/storage/ClientStorageManager;", "Lcom/cobblemon/mod/common/client/trade/ClientTrade;", "trade", "Lcom/cobblemon/mod/common/client/trade/ClientTrade;", "getTrade", "()Lcom/cobblemon/mod/common/client/trade/ClientTrade;", "setTrade", "(Lcom/cobblemon/mod/common/client/trade/ClientTrade;)V", "Lcom/cobblemon/mod/common/client/battle/ClientBattle;", "battle", "Lcom/cobblemon/mod/common/client/battle/ClientBattle;", "getBattle", "()Lcom/cobblemon/mod/common/client/battle/ClientBattle;", "setBattle", "(Lcom/cobblemon/mod/common/client/battle/ClientBattle;)V", "Lcom/cobblemon/mod/common/api/storage/player/client/ClientGeneralPlayerData;", "clientPlayerData", "Lcom/cobblemon/mod/common/api/storage/player/client/ClientGeneralPlayerData;", "getClientPlayerData", "()Lcom/cobblemon/mod/common/api/storage/player/client/ClientGeneralPlayerData;", "setClientPlayerData", "(Lcom/cobblemon/mod/common/api/storage/player/client/ClientGeneralPlayerData;)V", "Lcom/cobblemon/mod/common/api/storage/player/client/ClientPokedexManager;", "clientPokedexData", "Lcom/cobblemon/mod/common/api/storage/player/client/ClientPokedexManager;", "getClientPokedexData", "()Lcom/cobblemon/mod/common/api/storage/player/client/ClientPokedexManager;", "setClientPokedexData", "(Lcom/cobblemon/mod/common/api/storage/player/client/ClientPokedexManager;)V", "", "checkedStarterScreen", "Z", "getCheckedStarterScreen", "()Z", "setCheckedStarterScreen", "(Z)V", "", "lastPcBoxViewed", "I", "getLastPcBoxViewed", "()I", "setLastPcBoxViewed", "(I)V", "Lcom/cobblemon/mod/common/client/requests/ClientPlayerActionRequests;", "requests", "Lcom/cobblemon/mod/common/client/requests/ClientPlayerActionRequests;", "getRequests", "()Lcom/cobblemon/mod/common/client/requests/ClientPlayerActionRequests;", "setRequests", "(Lcom/cobblemon/mod/common/client/requests/ClientPlayerActionRequests;)V", "Lcom/cobblemon/mod/common/client/ClientPlayerTeamData;", "teamData", "Lcom/cobblemon/mod/common/client/ClientPlayerTeamData;", "getTeamData", "()Lcom/cobblemon/mod/common/client/ClientPlayerTeamData;", "setTeamData", "(Lcom/cobblemon/mod/common/client/ClientPlayerTeamData;)V", "Lcom/cobblemon/mod/common/client/gui/PartyOverlay;", "overlay$delegate", "Lkotlin/Lazy;", "getOverlay", "()Lcom/cobblemon/mod/common/client/gui/PartyOverlay;", "overlay", "Lcom/cobblemon/mod/common/client/gui/battle/BattleOverlay;", "battleOverlay$delegate", "getBattleOverlay", "()Lcom/cobblemon/mod/common/client/gui/battle/BattleOverlay;", "battleOverlay", "Lcom/cobblemon/mod/common/pokedex/scanner/PokedexUsageContext;", "pokedexUsageContext$delegate", "getPokedexUsageContext", "()Lcom/cobblemon/mod/common/pokedex/scanner/PokedexUsageContext;", "pokedexUsageContext", "Lcom/cobblemon/mod/common/client/gui/RideControlsOverlay;", "rideControlsOverlay$delegate", "getRideControlsOverlay", "()Lcom/cobblemon/mod/common/client/gui/RideControlsOverlay;", "rideControlsOverlay", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonClient.kt\ncom/cobblemon/mod/common/client/CobblemonClient\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,441:1\n37#2,2:442\n37#2,2:444\n1869#3,2:446\n1869#3,2:448\n*S KotlinDebug\n*F\n+ 1 CobblemonClient.kt\ncom/cobblemon/mod/common/client/CobblemonClient\n*L\n287#1:442,2\n400#1:444,2\n430#1:446,2\n188#1:448,2\n*E\n"})
public final class CobblemonClient {
    @NotNull
    public static final CobblemonClient INSTANCE = new CobblemonClient();
    public static CobblemonClientImplementation implementation;
    @NotNull
    private static final ClientStorageManager storage;
    @Nullable
    private static ClientTrade trade;
    @Nullable
    private static ClientBattle battle;
    @NotNull
    private static ClientGeneralPlayerData clientPlayerData;
    @NotNull
    private static ClientPokedexManager clientPokedexData;
    private static boolean checkedStarterScreen;
    private static int lastPcBoxViewed;
    @NotNull
    private static ClientPlayerActionRequests requests;
    @NotNull
    private static ClientPlayerTeamData teamData;
    @NotNull
    private static final Lazy overlay$delegate;
    @NotNull
    private static final Lazy battleOverlay$delegate;
    @NotNull
    private static final Lazy pokedexUsageContext$delegate;
    @NotNull
    private static final Lazy rideControlsOverlay$delegate;

    private CobblemonClient() {
    }

    @NotNull
    public final CobblemonClientImplementation getImplementation() {
        CobblemonClientImplementation cobblemonClientImplementation = implementation;
        if (cobblemonClientImplementation != null) {
            return cobblemonClientImplementation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"implementation");
        return null;
    }

    public final void setImplementation(@NotNull CobblemonClientImplementation cobblemonClientImplementation) {
        Intrinsics.checkNotNullParameter((Object)cobblemonClientImplementation, (String)"<set-?>");
        implementation = cobblemonClientImplementation;
    }

    @NotNull
    public final ClientStorageManager getStorage() {
        return storage;
    }

    @Nullable
    public final ClientTrade getTrade() {
        return trade;
    }

    public final void setTrade(@Nullable ClientTrade clientTrade) {
        trade = clientTrade;
    }

    @Nullable
    public final ClientBattle getBattle() {
        return battle;
    }

    public final void setBattle(@Nullable ClientBattle clientBattle) {
        battle = clientBattle;
    }

    @NotNull
    public final ClientGeneralPlayerData getClientPlayerData() {
        return clientPlayerData;
    }

    public final void setClientPlayerData(@NotNull ClientGeneralPlayerData clientGeneralPlayerData) {
        Intrinsics.checkNotNullParameter((Object)clientGeneralPlayerData, (String)"<set-?>");
        clientPlayerData = clientGeneralPlayerData;
    }

    @NotNull
    public final ClientPokedexManager getClientPokedexData() {
        return clientPokedexData;
    }

    public final void setClientPokedexData(@NotNull ClientPokedexManager clientPokedexManager) {
        Intrinsics.checkNotNullParameter((Object)clientPokedexManager, (String)"<set-?>");
        clientPokedexData = clientPokedexManager;
    }

    public final boolean getCheckedStarterScreen() {
        return checkedStarterScreen;
    }

    public final void setCheckedStarterScreen(boolean bl) {
        checkedStarterScreen = bl;
    }

    public final int getLastPcBoxViewed() {
        return lastPcBoxViewed;
    }

    public final void setLastPcBoxViewed(int n) {
        lastPcBoxViewed = n;
    }

    @NotNull
    public final ClientPlayerActionRequests getRequests() {
        return requests;
    }

    public final void setRequests(@NotNull ClientPlayerActionRequests clientPlayerActionRequests) {
        Intrinsics.checkNotNullParameter((Object)clientPlayerActionRequests, (String)"<set-?>");
        requests = clientPlayerActionRequests;
    }

    @NotNull
    public final ClientPlayerTeamData getTeamData() {
        return teamData;
    }

    public final void setTeamData(@NotNull ClientPlayerTeamData clientPlayerTeamData) {
        Intrinsics.checkNotNullParameter((Object)clientPlayerTeamData, (String)"<set-?>");
        teamData = clientPlayerTeamData;
    }

    @NotNull
    public final PartyOverlay getOverlay() {
        Lazy lazy = overlay$delegate;
        return (PartyOverlay)((Object)lazy.getValue());
    }

    @NotNull
    public final BattleOverlay getBattleOverlay() {
        Lazy lazy = battleOverlay$delegate;
        return (BattleOverlay)lazy.getValue();
    }

    @NotNull
    public final PokedexUsageContext getPokedexUsageContext() {
        Lazy lazy = pokedexUsageContext$delegate;
        return (PokedexUsageContext)lazy.getValue();
    }

    @NotNull
    public final RideControlsOverlay getRideControlsOverlay() {
        Lazy lazy = rideControlsOverlay$delegate;
        return (RideControlsOverlay)((Object)lazy.getValue());
    }

    public final void onLogin() {
        clientPlayerData = new ClientGeneralPlayerData(null, false, false, false, null, false, null, 127, null);
        requests = new ClientPlayerActionRequests();
        teamData = new ClientPlayerTeamData();
        clientPokedexData = new ClientPokedexManager(new LinkedHashMap());
        storage.onLogin();
    }

    public final void onLogout() {
        storage.onLogout();
        battle = null;
        this.getBattleOverlay().onLogout();
        ClientTaskTracker.INSTANCE.clear();
        checkedStarterScreen = false;
        DeferredRenderer.INSTANCE.clearAll();
        ClientPlayerIcon.Companion.clear();
    }

    public final void initialize(@NotNull CobblemonClientImplementation implementation) {
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        Cobblemon.LOGGER.info("Initializing Cobblemon client");
        this.setImplementation(implementation);
        Observable.subscribe$default(PlatformEvents.CLIENT_PLAYER_LOGIN, null, CobblemonClient::initialize$lambda$0, 1, null);
        Observable.subscribe$default(PlatformEvents.CLIENT_PLAYER_LOGOUT, null, CobblemonClient::initialize$lambda$1, 1, null);
        this.registerBlockEntityRenderers();
        this.registerBlockRenderTypes();
        this.registerColors();
        this.registerFlywheelRenderers();
        this.registerEntityRenderers();
        this.registerItemColors();
        Observable.subscribe$default(Berries.INSTANCE.getObservable(), null, CobblemonClient::initialize$lambda$2, 1, null);
        this.registerTooltipManagers();
        this.registerMenuScreens();
        Cobblemon.LOGGER.info("Registering custom BuiltinItemRenderers");
        CobblemonBuiltinItemRendererRegistry.INSTANCE.register(CobblemonItems.POKEMON_MODEL, new PokemonItemRenderer());
        Observable.subscribe$default(PlatformEvents.CLIENT_ITEM_TOOLTIP, null, CobblemonClient::initialize$lambda$3, 1, null);
        Observable.subscribe$default(PlatformEvents.CLIENT_ENTITY_UNLOAD, null, CobblemonClient::initialize$lambda$4, 1, null);
        Observable.subscribe$default(PlatformEvents.CLIENT_TICK_POST, null, CobblemonClient::initialize$lambda$5, 1, null);
    }

    private final void registerTooltipManagers() {
        TooltipManager.INSTANCE.registerTooltipGenerator(CobblemonTooltipGenerator.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator(RecipeSeasoningAbsorptionTooltipGenerator.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator(FishingBaitTooltipGenerator.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator(SeasoningTooltipGenerator.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator(FishingRodTooltipGenerator.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator(AprijuiceTooltipGenerator.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator(PokePuffTooltipGenerator.INSTANCE);
    }

    public final void registerFlywheelRenderers() {
    }

    public final void registerColors() {
        Block[] blockArray = new Block[]{CobblemonBlocks.POKE_SNACK, CobblemonBlocks.POKE_CAKE};
        this.getImplementation().registerBlockColors(CobblemonClient::registerColors$lambda$0, blockArray);
    }

    private final void registerBlockRenderTypes() {
        CobblemonClientImplementation cobblemonClientImplementation = this.getImplementation();
        RenderType renderType = RenderType.cutoutMipped();
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"cutoutMipped(...)");
        SpreadBuilder spreadBuilder = new SpreadBuilder[]{CobblemonBlocks.APRICORN_LEAVES, CobblemonBlocks.SACCHARINE_LEAVES, CobblemonBlocks.POKE_CAKE};
        cobblemonClientImplementation.registerBlockRenderType(renderType, (Block[])spreadBuilder);
        CobblemonClientImplementation cobblemonClientImplementation2 = this.getImplementation();
        RenderType renderType2 = RenderType.cutout();
        Intrinsics.checkNotNullExpressionValue((Object)renderType2, (String)"cutout(...)");
        spreadBuilder = new SpreadBuilder(83);
        spreadBuilder.add((Object)CobblemonBlocks.GILDED_CHEST);
        spreadBuilder.add((Object)CobblemonBlocks.FOSSIL_ANALYZER);
        DoorBlock doorBlock = CobblemonBlocks.APRICORN_DOOR;
        Intrinsics.checkNotNullExpressionValue((Object)doorBlock, (String)"APRICORN_DOOR");
        spreadBuilder.add((Object)doorBlock);
        TrapDoorBlock trapDoorBlock = CobblemonBlocks.APRICORN_TRAPDOOR;
        Intrinsics.checkNotNullExpressionValue((Object)trapDoorBlock, (String)"APRICORN_TRAPDOOR");
        spreadBuilder.add((Object)trapDoorBlock);
        spreadBuilder.add((Object)CobblemonBlocks.APRICORN_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.APRICORN_WALL_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.APRICORN_HANGING_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.APRICORN_WALL_HANGING_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.BLACK_APRICORN_SAPLING);
        spreadBuilder.add((Object)CobblemonBlocks.BLUE_APRICORN_SAPLING);
        spreadBuilder.add((Object)CobblemonBlocks.GREEN_APRICORN_SAPLING);
        spreadBuilder.add((Object)CobblemonBlocks.PINK_APRICORN_SAPLING);
        spreadBuilder.add((Object)CobblemonBlocks.RED_APRICORN_SAPLING);
        spreadBuilder.add((Object)CobblemonBlocks.WHITE_APRICORN_SAPLING);
        spreadBuilder.add((Object)CobblemonBlocks.YELLOW_APRICORN_SAPLING);
        Block block = CobblemonBlocks.POTTED_BLACK_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"POTTED_BLACK_APRICORN_SAPLING");
        spreadBuilder.add((Object)block);
        Block block2 = CobblemonBlocks.POTTED_BLUE_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"POTTED_BLUE_APRICORN_SAPLING");
        spreadBuilder.add((Object)block2);
        Block block3 = CobblemonBlocks.POTTED_GREEN_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"POTTED_GREEN_APRICORN_SAPLING");
        spreadBuilder.add((Object)block3);
        Block block4 = CobblemonBlocks.POTTED_PINK_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"POTTED_PINK_APRICORN_SAPLING");
        spreadBuilder.add((Object)block4);
        Block block5 = CobblemonBlocks.POTTED_RED_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block5, (String)"POTTED_RED_APRICORN_SAPLING");
        spreadBuilder.add((Object)block5);
        Block block6 = CobblemonBlocks.POTTED_WHITE_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block6, (String)"POTTED_WHITE_APRICORN_SAPLING");
        spreadBuilder.add((Object)block6);
        Block block7 = CobblemonBlocks.POTTED_YELLOW_APRICORN_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block7, (String)"POTTED_YELLOW_APRICORN_SAPLING");
        spreadBuilder.add((Object)block7);
        spreadBuilder.add((Object)CobblemonBlocks.BLACK_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.BLUE_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.GREEN_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.PINK_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.RED_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.WHITE_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.YELLOW_APRICORN);
        spreadBuilder.add((Object)CobblemonBlocks.HEALING_MACHINE);
        spreadBuilder.add((Object)CobblemonBlocks.MEDICINAL_LEEK);
        spreadBuilder.add((Object)CobblemonBlocks.HEALING_MACHINE);
        spreadBuilder.add((Object)CobblemonBlocks.INSTANCE.getRED_MINT());
        spreadBuilder.add((Object)CobblemonBlocks.BLUE_MINT);
        spreadBuilder.add((Object)CobblemonBlocks.CYAN_MINT);
        spreadBuilder.add((Object)CobblemonBlocks.PINK_MINT);
        spreadBuilder.add((Object)CobblemonBlocks.GREEN_MINT);
        spreadBuilder.add((Object)CobblemonBlocks.WHITE_MINT);
        spreadBuilder.add((Object)CobblemonBlocks.PASTURE);
        spreadBuilder.add((Object)CobblemonBlocks.ENERGY_ROOT);
        spreadBuilder.add((Object)CobblemonBlocks.BIG_ROOT);
        spreadBuilder.add((Object)CobblemonBlocks.REVIVAL_HERB);
        spreadBuilder.add((Object)CobblemonBlocks.VIVICHOKE_SEEDS);
        spreadBuilder.add((Object)CobblemonBlocks.HEARTY_GRAINS);
        spreadBuilder.add((Object)CobblemonBlocks.PEP_UP_FLOWER);
        Block block8 = CobblemonBlocks.POTTED_PEP_UP_FLOWER;
        Intrinsics.checkNotNullExpressionValue((Object)block8, (String)"POTTED_PEP_UP_FLOWER");
        spreadBuilder.add((Object)block8);
        spreadBuilder.add((Object)CobblemonBlocks.REVIVAL_HERB);
        Collection<BerryBlock> $this$toTypedArray$iv = CobblemonBlocks.INSTANCE.berries().values();
        boolean $i$f$toTypedArray = false;
        Collection<BerryBlock> thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new BerryBlock[0]));
        spreadBuilder.add((Object)CobblemonBlocks.GALARICA_NUT_BUSH);
        spreadBuilder.add((Object)CobblemonBlocks.RESTORATION_TANK);
        spreadBuilder.add((Object)CobblemonBlocks.SMALL_BUDDING_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.MEDIUM_BUDDING_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.LARGE_BUDDING_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.TUMBLESTONE_CLUSTER);
        spreadBuilder.add((Object)CobblemonBlocks.SMALL_BUDDING_BLACK_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.MEDIUM_BUDDING_BLACK_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.LARGE_BUDDING_BLACK_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.BLACK_TUMBLESTONE_CLUSTER);
        spreadBuilder.add((Object)CobblemonBlocks.SMALL_BUDDING_SKY_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.MEDIUM_BUDDING_SKY_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.LARGE_BUDDING_SKY_TUMBLESTONE);
        spreadBuilder.add((Object)CobblemonBlocks.SKY_TUMBLESTONE_CLUSTER);
        spreadBuilder.add((Object)CobblemonBlocks.GIMMIGHOUL_CHEST);
        spreadBuilder.add((Object)CobblemonBlocks.DISPLAY_CASE);
        DoorBlock doorBlock2 = CobblemonBlocks.SACCHARINE_DOOR;
        Intrinsics.checkNotNullExpressionValue((Object)doorBlock2, (String)"SACCHARINE_DOOR");
        spreadBuilder.add((Object)doorBlock2);
        TrapDoorBlock trapDoorBlock2 = CobblemonBlocks.SACCHARINE_TRAPDOOR;
        Intrinsics.checkNotNullExpressionValue((Object)trapDoorBlock2, (String)"SACCHARINE_TRAPDOOR");
        spreadBuilder.add((Object)trapDoorBlock2);
        spreadBuilder.add((Object)CobblemonBlocks.SACCHARINE_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.SACCHARINE_WALL_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.SACCHARINE_HANGING_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.SACCHARINE_WALL_HANGING_SIGN);
        spreadBuilder.add((Object)CobblemonBlocks.SACCHARINE_SAPLING);
        Block block9 = CobblemonBlocks.POTTED_SACCHARINE_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)block9, (String)"POTTED_SACCHARINE_SAPLING");
        spreadBuilder.add((Object)block9);
        spreadBuilder.add((Object)CobblemonBlocks.POKE_SNACK);
        spreadBuilder.add((Object)CobblemonBlocks.LECTERN);
        spreadBuilder.add((Object)CobblemonBlocks.CAMPFIRE);
        spreadBuilder.add((Object)CobblemonBlocks.SOUL_CAMPFIRE);
        spreadBuilder.add((Object)CobblemonBlocks.BLACK_CAMPFIRE_POT);
        spreadBuilder.add((Object)CobblemonBlocks.BLUE_CAMPFIRE_POT);
        spreadBuilder.add((Object)CobblemonBlocks.GREEN_CAMPFIRE_POT);
        spreadBuilder.add((Object)CobblemonBlocks.PINK_CAMPFIRE_POT);
        spreadBuilder.add((Object)CobblemonBlocks.RED_CAMPFIRE_POT);
        spreadBuilder.add((Object)CobblemonBlocks.WHITE_CAMPFIRE_POT);
        spreadBuilder.add((Object)CobblemonBlocks.YELLOW_CAMPFIRE_POT);
        cobblemonClientImplementation2.registerBlockRenderType(renderType2, (Block[])spreadBuilder.toArray((Object[])new Block[spreadBuilder.size()]));
        this.createBoatModelLayers();
    }

    public final void beforeChatRender(@NotNull GuiGraphics context, float partialDeltaTicks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DeltaTracker partialDeltaTicks2 = Minecraft.getInstance().getTimer();
        if (battle == null) {
            PartyOverlay partyOverlay = this.getOverlay();
            Intrinsics.checkNotNull((Object)partialDeltaTicks2);
            partyOverlay.render(context, partialDeltaTicks2);
        } else {
            BattleOverlay battleOverlay = this.getBattleOverlay();
            Intrinsics.checkNotNull((Object)partialDeltaTicks2);
            battleOverlay.render(context, partialDeltaTicks2);
        }
        this.getRideControlsOverlay().render(context, partialDeltaTicks2);
    }

    public final void onAddLayer(@Nullable Map<PlayerSkin.Model, ? extends EntityRenderer<? extends Player>> skinMap) {
        block0: {
            Map<PlayerSkin.Model, ? extends EntityRenderer<? extends Player>> map = skinMap;
            EntityRenderer<? extends Player> entityRenderer = map != null ? map.get(PlayerSkin.Model.WIDE) : null;
            Intrinsics.checkNotNull(entityRenderer, (String)"null cannot be cast to non-null type net.minecraft.client.renderer.entity.LivingEntityRenderer<net.minecraft.world.entity.player.Player, net.minecraft.client.model.PlayerModel<net.minecraft.world.entity.player.Player>>");
            LivingEntityRenderer renderer = (LivingEntityRenderer)entityRenderer;
            renderer.addLayer((RenderLayer)new PokemonOnShoulderRenderer((RenderLayerParent)renderer));
            LivingEntityRenderer livingEntityRenderer = renderer = (LivingEntityRenderer)skinMap.get(PlayerSkin.Model.SLIM);
            if (livingEntityRenderer == null) break block0;
            livingEntityRenderer.addLayer((RenderLayer)new PokemonOnShoulderRenderer((RenderLayerParent)renderer));
        }
    }

    private final void registerMenuScreens() {
        MenuScreens.register(CobblemonMenuType.INSTANCE.getCOOKING_POT(), CookingPotScreen::new);
    }

    private final void registerBlockEntityRenderers() {
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.HEALING_MACHINE, HealingMachineRenderer::new);
        CobblemonClientImplementation cobblemonClientImplementation = this.getImplementation();
        BlockEntityType<BerryBlockEntity> blockEntityType = CobblemonBlockEntities.BERRY;
        Intrinsics.checkNotNullExpressionValue(blockEntityType, (String)"BERRY");
        cobblemonClientImplementation.registerBlockEntityRenderer(blockEntityType, BerryBlockRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.SIGN, SignRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.HANGING_SIGN, HangingSignRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.FOSSIL_ANALYZER, FossilAnalyzerRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.RESTORATION_TANK, RestorationTankRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.GILDED_CHEST, GildedChestBlockRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.DISPLAY_CASE, DisplayCaseRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.LECTERN, LecternBlockEntityRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.CAMPFIRE, CampfireBlockEntityRenderer::new);
        this.getImplementation().registerBlockEntityRenderer(CobblemonBlockEntities.POKE_SNACK, PokeSnackBlockEntityRenderer::new);
    }

    private final void registerEntityRenderers() {
        Cobblemon.LOGGER.info("Registering Pok\u00e9mon renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.POKEMON, PokemonRenderer::new);
        Cobblemon.LOGGER.info("Registering Pok\u00e9Ball renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.EMPTY_POKEBALL, PokeBallRenderer::new);
        Cobblemon.LOGGER.info("Registering Boat renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.BOAT, CobblemonClient::registerEntityRenderers$lambda$0);
        Cobblemon.LOGGER.info("Registering Boat with Chest renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.CHEST_BOAT, CobblemonClient::registerEntityRenderers$lambda$1);
        Cobblemon.LOGGER.info("Registering Generic Bedrock renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.GENERIC_BEDROCK_ENTITY, GenericBedrockRenderer::new);
        Cobblemon.LOGGER.info("Registering Generic Bedrock Entity renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.GENERIC_BEDROCK_ENTITY, GenericBedrockRenderer::new);
        Cobblemon.LOGGER.info("Registering PokeRod Bobber renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.POKE_BOBBER, CobblemonClient::registerEntityRenderers$lambda$2);
        Cobblemon.LOGGER.info("Registering NPC renderer");
        this.getImplementation().registerEntityRenderer(CobblemonEntities.NPC, NPCRenderer::new);
    }

    private final void registerItemColors() {
        Collection $this$toTypedArray$iv = CobblemonItems.INSTANCE.getAprijuices();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Item[] itemArray = thisCollection$iv.toArray(new AprijuiceItem[0]);
        this.getImplementation().registerItemColors(AprijuiceItemColorProvider.INSTANCE, Arrays.copyOf(itemArray, itemArray.length));
        itemArray = new Item[]{CobblemonItems.POKE_SNACK, CobblemonItems.POKE_CAKE};
        this.getImplementation().registerItemColors(PokeSnackItemColorProvider.INSTANCE, itemArray);
        itemArray = new Item[]{CobblemonItems.POKE_BAIT};
        this.getImplementation().registerItemColors(PokeBaitItemColorProvider.INSTANCE, itemArray);
        itemArray = new Item[]{CobblemonItems.PONIGIRI};
        this.getImplementation().registerItemColors(PonigiriItemColorProvider.INSTANCE, itemArray);
        itemArray = new Item[]{CobblemonItems.SINISTER_TEA};
        this.getImplementation().registerItemColors(SinisterTeaItemColorProvider.INSTANCE, itemArray);
    }

    public final void reloadCodedAssets(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Cobblemon.LOGGER.info("Loading assets...");
        BedrockParticleOptionsRepository.INSTANCE.loadEffects(resourceManager);
        BedrockAnimationRepository.INSTANCE.loadAnimations(resourceManager, VaryingModelRepository.INSTANCE.getAnimationDirectories());
        VaryingModelRepository.INSTANCE.reload(resourceManager);
        BerryModelRepository.INSTANCE.reload(resourceManager);
        MiscModelRepository.INSTANCE.reload(resourceManager);
        Cobblemon.LOGGER.info("Loaded assets");
    }

    public final void endBattle() {
        battle = null;
        this.getBattleOverlay().setLastKnownBattle(null);
        BattleMusicController.INSTANCE.endMusic();
    }

    private final void createBoatModelLayers() {
        Iterable $this$forEach$iv = (Iterable)CobblemonBoatType.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CobblemonBoatType type = (CobblemonBoatType)((Object)element$iv);
            boolean bl = false;
            INSTANCE.getImplementation().registerLayer(CobblemonBoatRenderer.Companion.createBoatModelLayer$common(type, false), BoatModel::createBodyModel);
            INSTANCE.getImplementation().registerLayer(CobblemonBoatRenderer.Companion.createBoatModelLayer$common(type, true), ChestBoatModel::createBodyModel);
        }
    }

    private static final PartyOverlay overlay_delegate$lambda$0() {
        return new PartyOverlay();
    }

    private static final BattleOverlay battleOverlay_delegate$lambda$0() {
        return new BattleOverlay();
    }

    private static final PokedexUsageContext pokedexUsageContext_delegate$lambda$0() {
        return new PokedexUsageContext();
    }

    private static final RideControlsOverlay rideControlsOverlay_delegate$lambda$0() {
        return new RideControlsOverlay();
    }

    private static final Unit initialize$lambda$0(ClientPlayerEvent.Login it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.onLogin();
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(ClientPlayerEvent.Logout it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.onLogout();
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(Berries it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BerryModelRepository.INSTANCE.patchModels();
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3(ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack stack = event.getStack();
        List<Component> lines = event.getLines();
        TooltipManager.INSTANCE.generateTooltips(stack, lines, Screen.hasShiftDown());
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$4(ClientEntityEvent.Unload event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EntitySoundTracker.INSTANCE.clear(event.getEntity().getId());
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$5(ClientTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LocalPlayer player = event.getClient().player;
        if (player != null) {
            List nearbyPokemon;
            ItemStack selectedItem = player.getInventory().getItem(player.getInventory().selected);
            if (!(!INSTANCE.getPokedexUsageContext().getScanningGuiOpen() || selectedItem.is(CobblemonItemTags.POKEDEX) || player.getOffhandItem().is(CobblemonItemTags.POKEDEX) && player.isUsingItem() && player.getUsedItemHand() == InteractionHand.OFF_HAND)) {
                PokedexUsageContext.stopUsing$default(INSTANCE.getPokedexUsageContext(), 6, null, 2, null);
            }
            if (event.getClient().isPaused()) {
                return Unit.INSTANCE;
            }
            List list = nearbyPokemon = player.level().getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)16.0, (double)16.0, (double)16.0), arg_0 -> CobblemonClient.initialize$lambda$5$1(CobblemonClient::initialize$lambda$5$0, arg_0));
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity entity = (Entity)element$iv;
                    boolean bl = false;
                    if (!(entity instanceof PokemonEntity) || ((PokemonEntity)entity).isSilent()) continue;
                    if (PlayerExtensionsKt.isLookingAt$default((Entity)player, entity, 0.0f, 0.0f, 6, null) && !player.isSpectator() && ((PokemonEntity)entity).getPokemon().getShiny()) {
                        ((PokemonEntity)entity).getDelegate().spawnShinyParticle((Player)player);
                    }
                    ((PokemonEntity)entity).getDelegate().spawnAspectParticle();
                }
            }
        }
        ClientPlayerIcon.Companion.onTick();
        PartyOverlayDataControl.INSTANCE.tick(event.getClient().isPaused());
        return Unit.INSTANCE;
    }

    private static final boolean initialize$lambda$5$0(Entity it) {
        return it instanceof PokemonEntity;
    }

    private static final boolean initialize$lambda$5$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int registerColors$lambda$0(BlockState blockState, BlockAndTintGetter view, BlockPos blockPos, int tintIndex) {
        BlockPos blockPos2 = blockPos;
        if (blockPos2 != null) {
            BlockPos pos = blockPos2;
            boolean bl = false;
            BlockAndTintGetter blockAndTintGetter = view;
            if (blockAndTintGetter != null && (blockAndTintGetter = blockAndTintGetter.getBlockEntity(pos)) != null) {
                BlockAndTintGetter blockEntity = blockAndTintGetter;
                boolean bl2 = false;
                if (blockEntity instanceof TintBlockEntity) {
                    return ((TintBlockEntity)blockEntity).getTint();
                }
            }
        }
        return 0xFFFFFF;
    }

    private static final EntityRenderer registerEntityRenderers$lambda$0(EntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return new CobblemonBoatRenderer(ctx, false);
    }

    private static final EntityRenderer registerEntityRenderers$lambda$1(EntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return new CobblemonBoatRenderer(ctx, true);
    }

    private static final EntityRenderer registerEntityRenderers$lambda$2(EntityRendererProvider.Context ctx) {
        return new PokeBobberEntityRenderer(ctx);
    }

    static {
        storage = new ClientStorageManager();
        clientPlayerData = new ClientGeneralPlayerData(null, false, false, false, null, false, null, 127, null);
        clientPokedexData = new ClientPokedexManager(new LinkedHashMap());
        requests = new ClientPlayerActionRequests();
        teamData = new ClientPlayerTeamData();
        overlay$delegate = LazyKt.lazy(CobblemonClient::overlay_delegate$lambda$0);
        battleOverlay$delegate = LazyKt.lazy(CobblemonClient::battleOverlay_delegate$lambda$0);
        pokedexUsageContext$delegate = LazyKt.lazy(CobblemonClient::pokedexUsageContext_delegate$lambda$0);
        rideControlsOverlay$delegate = LazyKt.lazy(CobblemonClient::rideControlsOverlay_delegate$lambda$0);
    }
}

