/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.client.persisted.ClientPersistedData;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ%\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/client/MountedCameraTypeHandler;", "", "<init>", "()V", "Lnet/minecraft/world/entity/Entity;", "passenger", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "handleMount", "(Lnet/minecraft/world/entity/Entity;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleDismount", "Lnet/minecraft/resources/ResourceLocation;", "fromKey", "toKey", "handleTransition", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/client/CameraType;", "unmountedCameraType", "Lnet/minecraft/client/CameraType;", "getUnmountedCameraType", "()Lnet/minecraft/client/CameraType;", "setUnmountedCameraType", "(Lnet/minecraft/client/CameraType;)V", "common"})
public final class MountedCameraTypeHandler {
    @NotNull
    public static final MountedCameraTypeHandler INSTANCE = new MountedCameraTypeHandler();
    @NotNull
    private static CameraType unmountedCameraType = CameraType.FIRST_PERSON;

    private MountedCameraTypeHandler() {
    }

    @NotNull
    public final CameraType getUnmountedCameraType() {
        return unmountedCameraType;
    }

    public final void setUnmountedCameraType(@NotNull CameraType cameraType) {
        Intrinsics.checkNotNullParameter((Object)cameraType, (String)"<set-?>");
        unmountedCameraType = cameraType;
    }

    public final void handleMount(@NotNull Entity passenger, @NotNull PokemonEntity vehicle) {
        CameraType lastCameraTypeForKey;
        ResourceLocation key;
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Minecraft mc = Minecraft.getInstance();
        Object object = vehicle.getRidingController();
        ResourceLocation resourceLocation = object != null && (object = ((RidingController)object).getContext()) != null && (object = ((ActiveRidingContext)object).getSettings()) != null ? object.getKey() : (key = null);
        if (!Intrinsics.areEqual((Object)passenger, (Object)mc.player) || key == null) {
            return;
        }
        CameraType cameraType = mc.options.getCameraType();
        Intrinsics.checkNotNullExpressionValue((Object)cameraType, (String)"getCameraType(...)");
        unmountedCameraType = cameraType;
        ClientPersistedData.RidingPerspectiveData data = ClientPersistedData.INSTANCE.getRidingPerspectives();
        if (Cobblemon.INSTANCE.getConfig().getRememberRidingCamera() && (lastCameraTypeForKey = data.getPerspectives().get(key)) != null) {
            mc.options.setCameraType(lastCameraTypeForKey);
        }
    }

    public final void handleDismount(@NotNull Entity passenger, @NotNull PokemonEntity vehicle) {
        ResourceLocation key;
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Minecraft mc = Minecraft.getInstance();
        Object object = vehicle.getRidingController();
        ResourceLocation resourceLocation = object != null && (object = ((RidingController)object).getContext()) != null && (object = ((ActiveRidingContext)object).getSettings()) != null ? object.getKey() : (key = null);
        if (!Intrinsics.areEqual((Object)passenger, (Object)mc.player) || key == null) {
            return;
        }
        CameraType currentCameraType = mc.options.getCameraType();
        if (currentCameraType != unmountedCameraType) {
            mc.options.setCameraType(unmountedCameraType);
        }
        ClientPersistedData.RidingPerspectiveData data = ClientPersistedData.INSTANCE.getRidingPerspectives();
        Intrinsics.checkNotNull((Object)currentCameraType);
        data.updatePerspective(key, currentCameraType);
    }

    public final void handleTransition(@NotNull Entity passenger, @NotNull ResourceLocation fromKey, @NotNull ResourceLocation toKey) {
        CameraType lastCameraTypeForKey;
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)fromKey, (String)"fromKey");
        Intrinsics.checkNotNullParameter((Object)toKey, (String)"toKey");
        Minecraft mc = Minecraft.getInstance();
        if (!Intrinsics.areEqual((Object)passenger, (Object)mc.player)) {
            return;
        }
        CameraType currentCameraType = mc.options.getCameraType();
        ClientPersistedData.RidingPerspectiveData data = ClientPersistedData.INSTANCE.getRidingPerspectives();
        Intrinsics.checkNotNull((Object)currentCameraType);
        data.updatePerspective(fromKey, currentCameraType);
        if (Cobblemon.INSTANCE.getConfig().getRememberRidingCamera() && (lastCameraTypeForKey = data.getPerspectives().get(toKey)) != null) {
            mc.options.setCameraType(lastCameraTypeForKey);
        }
    }
}

