/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.dialogue.widgets;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.gui.ScrollingWidget;
import com.cobblemon.mod.common.client.gui.dialogue.DialogueScreen;
import com.cobblemon.mod.common.client.gui.dialogue.widgets.DialoguePortraitWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.render.TextClipping;
import com.cobblemon.mod.common.net.messages.client.dialogue.dto.DialogueDTO;
import com.cobblemon.mod.common.net.messages.client.dialogue.dto.DialogueGibberDTO;
import com.cobblemon.mod.common.net.messages.client.dialogue.dto.DialogueInputDTO;
import com.cobblemon.mod.common.net.messages.server.dialogue.InputToDialoguePacket;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002=>BU\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b#\u0010\"J\u000f\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b$\u0010\"J/\u0010&\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b&\u0010\u001bJ\u0017\u0010'\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b'\u0010(J'\u0010,\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b,\u0010-R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00101\u001a\u0004\b2\u0010\"R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u00101\u001a\u0004\b3\u0010\"R\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u00101\u001a\u0004\b4\u0010\"R\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00105\u001a\u0004\b6\u00107R\u0017\u00109\u001a\u0002088\u0006\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\u00a8\u0006?"}, d2={"Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox;", "Lcom/cobblemon/mod/common/client/gui/ScrollingWidget;", "Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox$DialogueLine;", "Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "dialogueScreen", "", "listX", "listY", "frameWidth", "height", "Lnet/minecraft/resources/ResourceLocation;", "background", "", "Lnet/minecraft/network/chat/MutableComponent;", "messages", "", "textColor", "<init>", "(Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;IIIILnet/minecraft/resources/ResourceLocation;Ljava/util/List;Ljava/lang/String;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "", "renderScrollbar", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "correctSize", "()V", "entry", "addEntry", "(Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox$DialogueLine;)I", "getRowWidth", "()I", "getScrollbarPosition", "getBottom", "partialTicks", "renderWidget", "enableScissor", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "", "button", "", "mouseClicked", "(DDI)Z", "Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "getDialogueScreen", "()Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "I", "getListX", "getListY", "getFrameWidth", "Lnet/minecraft/resources/ResourceLocation;", "getBackground", "()Lnet/minecraft/resources/ResourceLocation;", "Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueDTO;", "dialogue", "Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueDTO;", "getDialogue", "()Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueDTO;", "Companion", "DialogueLine", "common"})
@SourceDebugExtension(value={"SMAP\nDialogueBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogueBox.kt\ncom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1374#2:223\n1460#2,5:224\n1869#2,2:229\n*S KotlinDebug\n*F\n+ 1 DialogueBox.kt\ncom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox\n*L\n68#1:223\n68#1:224,5\n69#1:229,2\n*E\n"})
public final class DialogueBox
extends ScrollingWidget<DialogueLine> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DialogueScreen dialogueScreen;
    private final int listX;
    private final int listY;
    private final int frameWidth;
    @Nullable
    private final ResourceLocation background;
    @NotNull
    private final DialogueDTO dialogue;
    public static final int SCROLL_TRACK_WIDTH = 2;
    public static final int SCROLL_BAR_WIDTH = 4;
    public static final int LINE_HEIGHT = 12;
    public static final int LINE_WIDTH = 168;
    @NotNull
    private static final ResourceLocation boxResource = MiscUtilsKt.cobblemonResource("textures/gui/dialogue/dialogue_box.png");

    /*
     * WARNING - void declaration
     */
    public DialogueBox(@NotNull DialogueScreen dialogueScreen, int listX, int listY, int frameWidth, int height, @Nullable ResourceLocation background, @NotNull List<MutableComponent> messages, @Nullable String textColor) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dialogueScreen, (String)"dialogueScreen");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        super(listY, listX, frameWidth, height, 12, 4);
        this.dialogueScreen = dialogueScreen;
        this.listX = listX;
        this.listY = listY;
        this.frameWidth = frameWidth;
        this.background = background;
        this.dialogue = this.dialogueScreen.getDialogueDTO();
        this.correctSize();
        String string = textColor;
        int lineColor = string != null ? Integer.parseInt(string, CharsKt.checkRadix((int)16)) : 0x4C4C4C;
        Font textRenderer = Minecraft.getInstance().font;
        Iterable $this$flatMap$iv = messages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MutableComponent it = (MutableComponent)element$iv$iv;
            boolean bl = false;
            List list = Language.getInstance().getVisualOrder(textRenderer.getSplitter().splitLines((FormattedText)it, 168, it.getStyle()));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVisualOrder(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FormattedCharSequence it = (FormattedCharSequence)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.addEntry(new DialogueLine(it, lineColor));
        }
        if (this.getMaxPosition() > height - 2) {
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)formattedCharSequence, (String)"EMPTY");
            this.addEntry(new DialogueLine(formattedCharSequence, lineColor));
        }
    }

    public /* synthetic */ DialogueBox(DialogueScreen dialogueScreen, int n, int n2, int n3, int n4, ResourceLocation resourceLocation, List list, String string, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = 0;
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        this(dialogueScreen, n, n2, n3, n4, resourceLocation, list, string);
    }

    @NotNull
    public final DialogueScreen getDialogueScreen() {
        return this.dialogueScreen;
    }

    public final int getListX() {
        return this.listX;
    }

    public final int getListY() {
        return this.listY;
    }

    public final int getFrameWidth() {
        return this.frameWidth;
    }

    @Nullable
    public final ResourceLocation getBackground() {
        return this.background;
    }

    @NotNull
    public final DialogueDTO getDialogue() {
        return this.dialogue;
    }

    @Override
    public void renderScrollbar(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        ResourceLocation resourceLocation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int xLeft = this.getScrollbarPosition();
        int yStart = this.getY() + 2;
        int barHeight = this.getBottom() - yStart;
        int yBottom = (int)((float)(barHeight * barHeight) / (float)this.getMaxPosition());
        yBottom = Mth.clamp((int)yBottom, (int)32, (int)(barHeight - 8));
        int yTop = (int)this.getScrollAmount() * (barHeight - yBottom) / this.getMaxScroll() + yStart;
        if (yTop < yStart) {
            yTop = yStart;
        }
        if ((resourceLocation = this.background) == null) {
            resourceLocation = boxResource;
        }
        ResourceLocation resourceLocation2 = resourceLocation;
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        PoseStack poseStack2 = poseStack;
        int n = xLeft + 1;
        int n2 = this.height - 4;
        int n3 = 196 + DialoguePortraitWidget.Companion.getDIALOGUE_ARROW_WIDTH();
        int n4 = this.frameWidth + DialoguePortraitWidget.Companion.getDIALOGUE_ARROW_WIDTH() + 4 + 2;
        GuiUtilsKt.blitk$default(poseStack2, resourceLocation2, n, yStart, n2, 2, n3, null, n4, 74, null, null, null, null, null, false, 0.0f, 130176, null);
        ResourceLocation resourceLocation3 = this.background;
        if (resourceLocation3 == null) {
            resourceLocation3 = boxResource;
        }
        resourceLocation2 = resourceLocation3;
        PoseStack poseStack3 = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
        poseStack2 = poseStack3;
        n = yTop;
        n2 = yBottom;
        n3 = 196 + DialoguePortraitWidget.Companion.getDIALOGUE_ARROW_WIDTH() + 2;
        n4 = this.frameWidth + DialoguePortraitWidget.Companion.getDIALOGUE_ARROW_WIDTH() + 4 + 2;
        GuiUtilsKt.blitk$default(poseStack2, resourceLocation2, xLeft, n, n2, 4, n3, null, n4, 74, null, null, null, null, null, false, 0.0f, 130176, null);
    }

    private final void correctSize() {
        this.setSize(this.width, this.height);
        this.setX(this.listX);
        this.setY(this.listY);
    }

    protected int addEntry(@NotNull DialogueLine entry) {
        Intrinsics.checkNotNullParameter((Object)((Object)entry), (String)"entry");
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    @Override
    public int getRowWidth() {
        return 168;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.getX() + 186;
    }

    public int getBottom() {
        return this.getY() + this.height - 2;
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DialogueGibberDTO gibber = this.dialogueScreen.getGibber();
        this.correctSize();
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        ResourceLocation resourceLocation = this.background;
        if (resourceLocation == null) {
            resourceLocation = boxResource;
        }
        GuiUtilsKt.blitk$default(poseStack, resourceLocation, this.getX(), this.getY(), this.height, this.frameWidth, null, null, this.frameWidth + DialoguePortraitWidget.Companion.getDIALOGUE_ARROW_WIDTH() + 4 + 2, null, null, null, null, null, null, false, 0.0f, 130752, null);
        DialogueGibberDTO dialogueGibberDTO = gibber;
        TextClipping.doWithMaxCharacters((dialogueGibberDTO != null ? dialogueGibberDTO.getGraduallyShowText() : false) && !this.dialogueScreen.getGibberDone() ? this.dialogueScreen.getGibberIndex() : -1, () -> DialogueBox.renderWidget$lambda$0(this, context, mouseX, mouseY, partialTicks));
    }

    protected void enableScissor(@NotNull GuiGraphics context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int textBoxHeight = this.height;
        context.enableScissor(this.getX(), this.getY() + 1, this.getX() + this.width - 1, this.getY() + textBoxHeight - 1);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        DialogueInputDTO.InputType[] inputTypeArray;
        if (!this.dialogueScreen.getWaitingForServerUpdate() && mouseX > (double)this.getX() && mouseX < (double)this.getScrollbarPosition() && mouseY > (double)this.getY() && mouseY < (double)this.getBottom() && this.dialogue.getDialogueInput().getAllowSkip() && CollectionsKt.listOf((Object[])(inputTypeArray = new DialogueInputDTO.InputType[]{DialogueInputDTO.InputType.NONE, DialogueInputDTO.InputType.AUTO_CONTINUE})).contains((Object)this.dialogue.getDialogueInput().getInputType())) {
            DialogueGibberDTO gibber = this.dialogueScreen.getGibber();
            if (gibber != null && gibber.getGraduallyShowText() && !this.dialogueScreen.getGibberDone()) {
                if (gibber.getAllowSkip()) {
                    this.dialogueScreen.setGibberDone(true);
                }
                return true;
            }
            this.dialogueScreen.sendToServer(new InputToDialoguePacket(this.dialogue.getDialogueInput().getInputId(), "skip!"));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private static final void renderWidget$lambda$0(DialogueBox this$0, GuiGraphics $context, int $mouseX, int $mouseY, float $partialTicks) {
        super.renderWidget($context, $mouseX, $mouseY, $partialTicks);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox$Companion;", "", "<init>", "()V", "", "SCROLL_TRACK_WIDTH", "I", "SCROLL_BAR_WIDTH", "LINE_HEIGHT", "LINE_WIDTH", "Lnet/minecraft/resources/ResourceLocation;", "boxResource", "Lnet/minecraft/resources/ResourceLocation;", "getBoxResource", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getBoxResource() {
            return boxResource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ_\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ_\u0010!\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b!\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueBox$DialogueLine;", "Lnet/minecraft/client/gui/components/ObjectSelectionList$Entry;", "Lnet/minecraft/util/FormattedCharSequence;", "line", "", "lineColor", "<init>", "(Lnet/minecraft/util/FormattedCharSequence;I)V", "Lnet/minecraft/network/chat/MutableComponent;", "getNarration", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "index", "y", "x", "entryWidth", "entryHeight", "mouseX", "mouseY", "", "hovered", "", "tickDelta", "", "renderBack", "(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V", "rowTop", "rowLeft", "rowWidth", "rowHeight", "isHovered", "partialTicks", "render", "Lnet/minecraft/util/FormattedCharSequence;", "getLine", "()Lnet/minecraft/util/FormattedCharSequence;", "I", "getLineColor", "()I", "common"})
    public static final class DialogueLine
    extends ObjectSelectionList.Entry<DialogueLine> {
        @NotNull
        private final FormattedCharSequence line;
        private final int lineColor;

        public DialogueLine(@NotNull FormattedCharSequence line, int lineColor) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.line = line;
            this.lineColor = lineColor;
        }

        @NotNull
        public final FormattedCharSequence getLine() {
            return this.line;
        }

        public final int getLineColor() {
            return this.lineColor;
        }

        @NotNull
        public MutableComponent getNarration() {
            return TextKt.text("");
        }

        public void renderBack(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        }

        public void render(@NotNull GuiGraphics context, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            RenderHelperKt.drawScaledText$default(context, this.line, rowLeft + 14, rowTop + 7, 0.0f, 0.0f, null, this.lineColor, false, false, 880, null);
        }
    }
}

