/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.dialogue.widgets;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.gui.ParentWidget;
import com.cobblemon.mod.common.client.gui.dialogue.DialogueScreen;
import com.cobblemon.mod.common.net.messages.server.dialogue.InputToDialoguePacket;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0015\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010 \u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010.\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueOptionWidget;", "Lcom/cobblemon/mod/common/api/gui/ParentWidget;", "Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "dialogueScreen", "Lnet/minecraft/network/chat/MutableComponent;", "text", "", "value", "", "selectable", "", "x", "y", "width", "height", "Lnet/minecraft/resources/ResourceLocation;", "texture", "<init>", "(Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;Lnet/minecraft/network/chat/MutableComponent;Ljava/lang/String;ZIIIILnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "", "pMouseX", "pMouseY", "pButton", "mouseClicked", "(DDI)Z", "Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "getDialogueScreen", "()Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "Lnet/minecraft/network/chat/MutableComponent;", "getText", "()Lnet/minecraft/network/chat/MutableComponent;", "Ljava/lang/String;", "getValue", "()Ljava/lang/String;", "Z", "getSelectable", "()Z", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
public final class DialogueOptionWidget
extends ParentWidget {
    @NotNull
    private final DialogueScreen dialogueScreen;
    @NotNull
    private final MutableComponent text;
    @NotNull
    private final String value;
    private final boolean selectable;
    @NotNull
    private final ResourceLocation texture;

    public DialogueOptionWidget(@NotNull DialogueScreen dialogueScreen, @NotNull MutableComponent text, @NotNull String value, boolean selectable, int x, int y, int width, int height, @NotNull ResourceLocation texture) {
        Intrinsics.checkNotNullParameter((Object)dialogueScreen, (String)"dialogueScreen");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        super(x, y, width, height, (Component)text);
        this.dialogueScreen = dialogueScreen;
        this.text = text;
        this.value = value;
        this.selectable = selectable;
        this.texture = texture;
    }

    @NotNull
    public final DialogueScreen getDialogueScreen() {
        return this.dialogueScreen;
    }

    @NotNull
    public final MutableComponent getText() {
        return this.text;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final boolean getSelectable() {
        return this.selectable;
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    protected void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.dialogueScreen.renderInput()) {
            return;
        }
        ResourceLocation resourceLocation = this.texture;
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        PoseStack poseStack2 = poseStack;
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.width;
        int n4 = this.height;
        int n5 = this.selectable ? (this.isHovered ? this.height : 0) : this.height * 2;
        int n6 = this.height * 3;
        GuiUtilsKt.blitk$default(poseStack2, resourceLocation, n, n2, n4, n3, null, n5, null, n6, null, null, null, null, null, false, 0.0f, 130368, null);
        resourceLocation = this.text;
        int n7 = this.getX() + this.width / 2;
        n = this.getY() + this.height / 2 - 3;
        n2 = this.selectable ? 0xFFFFFF : 0x8D8D8D;
        GuiUtilsKt.drawCenteredText$default(context, null, (Component)resourceLocation, n7, n, n2, true, 2, null);
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.dialogueScreen.renderInput()) {
            return false;
        }
        if (!this.isHovered) {
            return false;
        }
        if (!this.selectable || this.dialogueScreen.getWaitingForServerUpdate()) {
            return true;
        }
        this.dialogueScreen.sendToServer(new InputToDialoguePacket(this.dialogueScreen.getDialogueDTO().getDialogueInput().getInputId(), this.value));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CobblemonSounds.GUI_CLICK, (float)1.0f));
        return true;
    }
}

