/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.pc;

import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.gui.pc.StorageWidget;
import com.cobblemon.mod.common.client.gui.pc.TextWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.storage.ClientBox;
import com.cobblemon.mod.common.net.messages.server.storage.pc.RequestRenamePCBoxPacket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J\r\u0010%\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010'R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010(\u00a8\u0006)"}, d2={"Lcom/cobblemon/mod/common/client/gui/pc/BoxNameWidget;", "Lcom/cobblemon/mod/common/client/gui/pc/TextWidget;", "", "pX", "pY", "Lnet/minecraft/network/chat/Component;", "text", "Lcom/cobblemon/mod/common/client/gui/pc/PCGUI;", "pcGui", "Lcom/cobblemon/mod/common/client/gui/pc/StorageWidget;", "storageWidget", "<init>", "(IILnet/minecraft/network/chat/Component;Lcom/cobblemon/mod/common/client/gui/pc/PCGUI;Lcom/cobblemon/mod/common/client/gui/pc/StorageWidget;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "", "focused", "setFocused", "(Z)V", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "unfocused", "()V", "Lcom/cobblemon/mod/common/client/storage/ClientBox;", "getBox", "()Lcom/cobblemon/mod/common/client/storage/ClientBox;", "Lnet/minecraft/network/chat/MutableComponent;", "defaultBoxLabel", "()Lnet/minecraft/network/chat/MutableComponent;", "Lcom/cobblemon/mod/common/client/gui/pc/PCGUI;", "Lcom/cobblemon/mod/common/client/gui/pc/StorageWidget;", "common"})
public final class BoxNameWidget
extends TextWidget {
    @NotNull
    private final PCGUI pcGui;
    @NotNull
    private final StorageWidget storageWidget;

    public BoxNameWidget(int pX, int pY, @NotNull Component text, @NotNull PCGUI pcGui, @NotNull StorageWidget storageWidget) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)pcGui, (String)"pcGui");
        Intrinsics.checkNotNullParameter((Object)storageWidget, (String)"storageWidget");
        super(pX, pY, 0, 0, 0, text, BoxNameWidget::_init_$lambda$0, 28, null);
        this.pcGui = pcGui;
        this.storageWidget = storageWidget;
    }

    public /* synthetic */ BoxNameWidget(int n, int n2, Component component, PCGUI pCGUI, StorageWidget storageWidget, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            component = (Component)TextKt.text("BoxNameWidget");
        }
        this(n, n2, component, pCGUI, storageWidget);
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        MutableComponent mutableComponent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MutableComponent mutableComponent2 = this.getBox().getName();
        if (mutableComponent2 == null) {
            mutableComponent2 = this.defaultBoxLabel();
        }
        MutableComponent label = mutableComponent2;
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        MutableComponent input = TextKt.bold(this.applyTextCursor(string, label));
        Font font = Minecraft.getInstance().font;
        if (this.isFocused()) {
            String string2 = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            mutableComponent = TextKt.text(string2);
        } else {
            mutableComponent = label;
        }
        MutableComponent mutableComponent3 = TextKt.bold(mutableComponent);
        ResourceLocation resourceLocation = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-DEFAULT_LARGE>(...)");
        int textWidth = font.width((FormattedText)TextKt.font(mutableComponent3, resourceLocation));
        int centerX = this.getX() + this.width / 2 - textWidth / 2;
        if (this.getStartPosX() != centerX) {
            this.setStartPosX(centerX);
        }
        ResourceLocation resourceLocation2 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
        int n = this.getStartPosX();
        int n2 = this.getY() + 3;
        RenderHelperKt.drawScaledText$default(context, resourceLocation2, input, n, n2, 0.0f, null, 0, 0, false, false, null, null, 8160, null);
        this.renderCursor(context, label);
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (focused) {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0 && this.getBox().getName() != null) {
                Object object = this.getBox().getName();
                if (object == null || (object = object.getString()) == null) {
                    object = "";
                }
                this.setValue((String)object);
            }
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFocused() && keyCode == 256) {
            Object object = this.getBox().getName();
            if (object == null || (object = object.getString()) == null) {
                object = "";
            }
            this.setValue((String)object);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void unfocused() {
        MutableComponent mutableComponent;
        super.unfocused();
        new RequestRenamePCBoxPacket(this.pcGui.getPc().getUuid(), this.storageWidget.getBox(), this.getValue()).sendToServer();
        ClientBox clientBox = this.getBox();
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            mutableComponent = null;
        } else {
            MutableComponent mutableComponent2 = Component.literal((String)this.getValue());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
            mutableComponent = TextKt.bold(mutableComponent2);
        }
        clientBox.setName(mutableComponent);
        this.setValue("");
    }

    @NotNull
    public final ClientBox getBox() {
        return this.pcGui.getPc().getBoxes().get(this.storageWidget.getBox());
    }

    @NotNull
    public final MutableComponent defaultBoxLabel() {
        Object[] objectArray = new Object[]{this.storageWidget.getBox() + 1};
        MutableComponent mutableComponent = Component.translatable((String)"cobblemon.ui.pc.box.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return mutableComponent;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

