/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.pokedex.widgets;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B?\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b#\u0010\"R\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010$\u001a\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/SearchWidget;", "Lnet/minecraft/client/gui/components/EditBox;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "", "posX", "posY", "", "width", "height", "Lnet/minecraft/network/chat/Component;", "text", "Lkotlin/Function0;", "", "update", "<init>", "(Ljava/lang/Number;Ljava/lang/Number;IILnet/minecraft/network/chat/Component;Lkotlin/jvm/functions/Function0;)V", "", "focused", "setFocused", "(Z)V", "", "mouseX", "mouseY", "button", "mouseClicked", "(DDI)Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "delta", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Ljava/lang/Number;", "getPosX", "()Ljava/lang/Number;", "getPosY", "Lkotlin/jvm/functions/Function0;", "getUpdate", "()Lkotlin/jvm/functions/Function0;", "", "focusedTime", "J", "getFocusedTime", "()J", "setFocusedTime", "(J)V", "Companion", "common"})
public final class SearchWidget
extends EditBox
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number posX;
    @NotNull
    private final Number posY;
    @NotNull
    private final Function0<Unit> update;
    private long focusedTime;
    @NotNull
    private static final ResourceLocation backgroundOverlay = MiscUtilsKt.cobblemonResource("textures/gui/pokedex/pokedex_screen_search_overlay.png");
    @NotNull
    private static final ResourceLocation searchIcon = MiscUtilsKt.cobblemonResource("textures/gui/pokedex/search_icon.png");

    public SearchWidget(@NotNull Number posX, @NotNull Number posY, int width, int height, @NotNull Component text, @NotNull Function0<Unit> update) {
        Intrinsics.checkNotNullParameter((Object)posX, (String)"posX");
        Intrinsics.checkNotNullParameter((Object)posY, (String)"posY");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        super(Minecraft.getInstance().font, posX.intValue(), posY.intValue(), width, height, text);
        this.posX = posX;
        this.posY = posY;
        this.update = update;
        this.setMaxLength(23);
        this.setResponder(arg_0 -> SearchWidget._init_$lambda$0(this, arg_0));
        this.focusedTime = Util.getMillis();
    }

    public /* synthetic */ SearchWidget(Number number, Number number2, int n, int n2, Component component, Function0 function0, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            component = (Component)TextKt.text("Search");
        }
        this(number, number2, n, n2, component, (Function0<Unit>)function0);
    }

    @NotNull
    public final Number getPosX() {
        return this.posX;
    }

    @NotNull
    public final Number getPosY() {
        return this.posY;
    }

    @NotNull
    public final Function0<Unit> getUpdate() {
        return this.update;
    }

    public final long getFocusedTime() {
        return this.focusedTime;
    }

    public final void setFocusedTime(long l) {
        this.focusedTime = l;
    }

    public void setFocused(boolean focused) {
        if (focused) {
            this.focusedTime = Util.getMillis();
        }
        super.setFocused(focused);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int n = this.getX();
        int n2 = this.getX() + this.width;
        int n3 = (int)mouseX;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            n = this.getY();
            n2 = this.getY() + this.height;
            n3 = (int)mouseY;
            boolean bl2 = n <= n3 ? n3 <= n2 : false;
            if (bl2) {
                this.setFocused(true);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        MutableComponent mutableComponent;
        boolean showCursor;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PoseStack matrices = context.pose();
        Intrinsics.checkNotNull((Object)matrices);
        PoseStack poseStack = matrices;
        ResourceLocation resourceLocation = backgroundOverlay;
        Number number = this.posX;
        Number number2 = this.posY;
        GuiUtilsKt.blitk$default(poseStack, resourceLocation, number, number2, 163, 139, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        poseStack = matrices;
        resourceLocation = searchIcon;
        float f = (float)(this.posX.intValue() + 3) / 0.5f;
        float f2 = (float)(this.posY.intValue() + 2) / 0.5f;
        GuiUtilsKt.blitk$default(poseStack, resourceLocation, Float.valueOf(f), Float.valueOf(f2), 14, 14, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
        boolean bl = showCursor = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
        if (this.isFocused()) {
            mutableComponent = TextKt.text(this.getValue() + (this.getCursorPosition() == this.getValue().length() && showCursor ? "_" : ""));
        } else {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                mutableComponent = LocalizationUtilsKt.lang("ui.pokedex.search", new Object[0]);
            } else {
                String string2 = this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                mutableComponent = TextKt.text(string2);
            }
        }
        MutableComponent input = mutableComponent;
        int startX = this.posX.intValue() + 13;
        int startY = this.posY.intValue() + 1;
        ResourceLocation resourceLocation2 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
        Intrinsics.checkNotNull((Object)input);
        RenderHelperKt.drawScaledText$default(context, resourceLocation2, TextKt.bold(input), startX, startY, 0.0f, null, 0, 0, false, true, null, null, 7136, null);
        if (showCursor) {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (!(((CharSequence)string).length() == 0) && this.getCursorPosition() != this.getValue().length()) {
                Font font = Minecraft.getInstance().font;
                String string3 = input.getString(this.getCursorPosition());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                MutableComponent mutableComponent2 = TextKt.bold(TextKt.text(string3));
                ResourceLocation resourceLocation3 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"<get-DEFAULT_LARGE>(...)");
                int startToCursorWidth = font.width((FormattedText)TextKt.font(mutableComponent2, resourceLocation3));
                context.fill(RenderType.guiTextHighlight(), startX + startToCursorWidth - 1, startY, startX + startToCursorWidth, startY + 9, -3092272);
            }
        }
    }

    private static final void _init_$lambda$0(SearchWidget this$0, String it) {
        this$0.update.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/SearchWidget$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "backgroundOverlay", "Lnet/minecraft/resources/ResourceLocation;", "searchIcon", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

