/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.toast;

import com.cobblemon.mod.common.net.messages.client.toast.ToastPacket;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b*\b\u0007\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000f\u0010\u0013J'\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u0013J\u000f\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010#\u001a\u0004\b$\u0010%R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010+\u001a\u0004\b0\u0010-\"\u0004\b1\u0010/R\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0016\u0010A\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u00107R\u0016\u0010B\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\"\u0010D\u001a\u00020\u001a8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010I\u00a8\u0006J"}, d2={"Lcom/cobblemon/mod/common/client/gui/toast/CobblemonToast;", "Lnet/minecraft/client/gui/components/toasts/Toast;", "Ljava/util/UUID;", "id", "Lnet/minecraft/world/item/ItemStack;", "icon", "Lnet/minecraft/network/chat/Component;", "title", "description", "Lnet/minecraft/resources/ResourceLocation;", "frameTexture", "", "progress", "", "progressColor", "<init>", "(Ljava/util/UUID;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/Component;Lnet/minecraft/resources/ResourceLocation;FI)V", "Lcom/cobblemon/mod/common/net/messages/client/toast/ToastPacket;", "packet", "(Lcom/cobblemon/mod/common/net/messages/client/toast/ToastPacket;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "Lnet/minecraft/client/gui/components/toasts/ToastComponent;", "manager", "", "startTime", "Lnet/minecraft/client/gui/components/toasts/Toast$Visibility;", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/components/toasts/ToastComponent;J)Lnet/minecraft/client/gui/components/toasts/Toast$Visibility;", "", "updateFrom$common", "updateFrom", "", "hasProgressBar", "()Z", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "Lnet/minecraft/world/item/ItemStack;", "getIcon", "()Lnet/minecraft/world/item/ItemStack;", "setIcon", "(Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/network/chat/Component;", "getTitle", "()Lnet/minecraft/network/chat/Component;", "setTitle", "(Lnet/minecraft/network/chat/Component;)V", "getDescription", "setDescription", "Lnet/minecraft/resources/ResourceLocation;", "getFrameTexture", "()Lnet/minecraft/resources/ResourceLocation;", "setFrameTexture", "(Lnet/minecraft/resources/ResourceLocation;)V", "F", "getProgress", "()F", "setProgress", "(F)V", "I", "getProgressColor", "()I", "setProgressColor", "(I)V", "lastProgress", "lastTime", "J", "nextVisibility", "Lnet/minecraft/client/gui/components/toasts/Toast$Visibility;", "getNextVisibility$common", "()Lnet/minecraft/client/gui/components/toasts/Toast$Visibility;", "setNextVisibility$common", "(Lnet/minecraft/client/gui/components/toasts/Toast$Visibility;)V", "common"})
@OnlyIn(value=Dist.CLIENT)
public final class CobblemonToast
implements Toast {
    @NotNull
    private final UUID id;
    @NotNull
    private ItemStack icon;
    @NotNull
    private Component title;
    @NotNull
    private Component description;
    @NotNull
    private ResourceLocation frameTexture;
    private float progress;
    private int progressColor;
    private float lastProgress;
    private long lastTime;
    @NotNull
    private Toast.Visibility nextVisibility;

    public CobblemonToast(@NotNull UUID id, @NotNull ItemStack icon, @NotNull Component title, @NotNull Component description, @NotNull ResourceLocation frameTexture, float progress, int progressColor) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)frameTexture, (String)"frameTexture");
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.description = description;
        this.frameTexture = frameTexture;
        this.progress = progress;
        this.progressColor = progressColor;
        this.nextVisibility = Toast.Visibility.SHOW;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final ItemStack getIcon() {
        return this.icon;
    }

    public final void setIcon(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.icon = itemStack;
    }

    @NotNull
    public final Component getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
        this.title = component;
    }

    @NotNull
    public final Component getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
        this.description = component;
    }

    @NotNull
    public final ResourceLocation getFrameTexture() {
        return this.frameTexture;
    }

    public final void setFrameTexture(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.frameTexture = resourceLocation;
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float f) {
        this.progress = f;
    }

    public final int getProgressColor() {
        return this.progressColor;
    }

    public final void setProgressColor(int n) {
        this.progressColor = n;
    }

    public CobblemonToast(@NotNull ToastPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this(packet.getUuid(), packet.getIcon(), packet.getTitle(), packet.getDescription(), packet.getFrameTexture(), packet.getProgress(), packet.getProgressColor());
    }

    @NotNull
    public final Toast.Visibility getNextVisibility$common() {
        return this.nextVisibility;
    }

    public final void setNextVisibility$common(@NotNull Toast.Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"<set-?>");
        this.nextVisibility = visibility;
    }

    @NotNull
    public Toast.Visibility render(@NotNull GuiGraphics context, @NotNull ToastComponent manager, long startTime) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        context.blitSprite(this.frameTexture, 0, 0, this.width(), this.height());
        Font textRenderer = manager.getMinecraft().font;
        TextColor textColor = this.title.getStyle().getColor();
        context.drawString(textRenderer, this.title, 30, 7, textColor != null ? textColor.getValue() : -1, false);
        TextColor textColor2 = this.description.getStyle().getColor();
        context.drawString(textRenderer, this.description, 30, 18, textColor2 != null ? textColor2.getValue() : -1, false);
        context.renderFakeItem(this.icon, 8, 8);
        if (this.hasProgressBar()) {
            context.fill(3, 28, 157, 29, -1);
            float f = Mth.clampedLerp((float)this.lastProgress, (float)this.progress, (float)((float)(startTime - this.lastTime) / 100.0f));
            context.fill(3, 28, (int)(3.0f + 154.0f * f), 29, this.progressColor);
            this.lastProgress = f;
        }
        this.lastTime = startTime;
        return this.nextVisibility;
    }

    public final void updateFrom$common(@NotNull ToastPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.icon = packet.getIcon();
        this.title = packet.getTitle();
        this.description = packet.getDescription();
        this.frameTexture = packet.getFrameTexture();
        this.progress = packet.getProgress();
        this.progressColor = packet.getProgressColor();
        this.lastProgress = Math.min(this.progress, this.lastProgress);
        this.nextVisibility = switch (WhenMappings.$EnumSwitchMapping$0[packet.getBehaviour().ordinal()]) {
            case 1 -> Toast.Visibility.SHOW;
            case 2 -> Toast.Visibility.HIDE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean hasProgressBar() {
        float f = this.progress;
        return 0.0f <= f ? f <= 1.0f : false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToastPacket.Behaviour.values().length];
            try {
                nArray[ToastPacket.Behaviour.SHOW_OR_UPDATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToastPacket.Behaviour.HIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

