/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.trade;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.PokemonGuiUtilsKt;
import com.cobblemon.mod.common.client.gui.trade.TradeGUI;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.net.messages.client.trade.TradeStartedPacket;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B;\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001f\u0010 R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010!R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\"R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R\u0017\u0010%\u001a\u00020$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/client/gui/trade/PartySlot;", "Lnet/minecraft/client/gui/components/Button;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "", "x", "y", "Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;", "pokemon", "Lcom/cobblemon/mod/common/client/gui/trade/TradeGUI;", "parent", "", "isOpposing", "Lnet/minecraft/client/gui/components/Button$OnPress;", "onPress", "<init>", "(IILcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;Lcom/cobblemon/mod/common/client/gui/trade/TradeGUI;ZLnet/minecraft/client/gui/components/Button$OnPress;)V", "Lnet/minecraft/client/sounds/SoundManager;", "soundManager", "", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "hasSelected", "()Z", "isHovered", "(II)Z", "Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;", "Lcom/cobblemon/mod/common/client/gui/trade/TradeGUI;", "Z", "Lcom/cobblemon/mod/common/client/render/models/blockbench/FloatingState;", "state", "Lcom/cobblemon/mod/common/client/render/models/blockbench/FloatingState;", "getState", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/FloatingState;", "Companion", "common"})
public class PartySlot
extends Button
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TradeStartedPacket.TradeablePokemon pokemon;
    @NotNull
    private final TradeGUI parent;
    private final boolean isOpposing;
    @NotNull
    private final FloatingState state;
    public static final int SIZE = 25;
    @NotNull
    private static final ResourceLocation hoverBackgroundResource = MiscUtilsKt.cobblemonResource("textures/gui/trade/trade_party_slot_hover.png");
    @NotNull
    private static final ResourceLocation genderIconMale = MiscUtilsKt.cobblemonResource("textures/gui/pc/gender_icon_male.png");
    @NotNull
    private static final ResourceLocation genderIconFemale = MiscUtilsKt.cobblemonResource("textures/gui/pc/gender_icon_female.png");
    @NotNull
    private static final ResourceLocation selectPointerResource = MiscUtilsKt.cobblemonResource("textures/gui/pc/pc_pointer.png");
    @NotNull
    private static final ResourceLocation untradeableResource = MiscUtilsKt.cobblemonResource("textures/gui/trade/trade_slot_icon_locked.png");

    public PartySlot(int x, int y, @Nullable TradeStartedPacket.TradeablePokemon pokemon, @NotNull TradeGUI parent, boolean isOpposing, @NotNull Button.OnPress onPress) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)onPress, (String)"onPress");
        super(x, y, 25, 25, (Component)Component.literal((String)"PartySlot"), onPress, Button.DEFAULT_NARRATION);
        this.pokemon = pokemon;
        this.parent = parent;
        this.isOpposing = isOpposing;
        this.state = new FloatingState();
    }

    public /* synthetic */ PartySlot(int n, int n2, TradeStartedPacket.TradeablePokemon tradeablePokemon, TradeGUI tradeGUI, boolean bl, Button.OnPress onPress, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, tradeablePokemon, tradeGUI, bl, onPress);
    }

    @NotNull
    public final FloatingState getState() {
        return this.state;
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
    }

    protected void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        ResourceLocation resourceLocation;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PoseStack matrices = context.pose();
        if (!this.isOpposing && this.isHovered(mouseX, mouseY)) {
            Intrinsics.checkNotNull((Object)matrices);
            object = matrices;
            resourceLocation = hoverBackgroundResource;
            int n = this.getX();
            int n2 = this.getY();
            GuiUtilsKt.blitk$default(object, resourceLocation, n, n2, 25, 25, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        }
        if (this.pokemon != null) {
            ItemStack heldItem;
            matrices.pushPose();
            matrices.translate((double)this.getX() + 12.5, (double)this.getY() + 1.0, 0.0);
            matrices.scale(2.5f, 2.5f, 1.0f);
            object = this.pokemon.asRenderablePokemon();
            Intrinsics.checkNotNull((Object)matrices);
            resourceLocation = matrices;
            Object[] objectArray = QuaternionUtilsKt.fromEulerXYZDegrees(new Quaternionf(), new Vector3f(13.0f, 35.0f, 0.0f));
            FloatingState floatingState = this.state;
            PokemonGuiUtilsKt.drawProfilePokemon$default((RenderablePokemon)object, (PoseStack)resourceLocation, (Quaternionf)objectArray, null, floatingState, delta, 4.5f, false, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 32648, null);
            matrices.popPose();
            matrices.pushPose();
            matrices.translate(0.0, 0.0, 100.0);
            objectArray = new Object[]{this.pokemon.getLevel()};
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("ui.lv.number", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            object = mutableComponent;
            int n = this.getX() + 1;
            int n3 = this.getY() + 1;
            RenderHelperKt.drawScaledText$default(context, null, (MutableComponent)object, n, n3, 0.5f, null, 0, 0, false, true, null, null, 7106, null);
            if (this.pokemon.getGender() != Gender.GENDERLESS) {
                object = matrices;
                ResourceLocation resourceLocation2 = this.pokemon.getGender() == Gender.MALE ? genderIconMale : genderIconFemale;
                float f = (float)(this.getX() + 21) / 0.5f;
                float f2 = (float)(this.getY() + 1) / 0.5f;
                GuiUtilsKt.blitk$default(object, resourceLocation2, Float.valueOf(f), Float.valueOf(f2), 8, 6, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
            }
            if (!this.pokemon.getTradeable()) {
                matrices.pushPose();
                matrices.translate(0.0f, 0.0f, 10.0f);
                object = matrices;
                ResourceLocation resourceLocation3 = untradeableResource;
                float f = (float)(this.getX() + 8) / 0.5f;
                float f3 = (float)(this.getY() + 8) / 0.5f;
                GuiUtilsKt.blitk$default(object, resourceLocation3, Float.valueOf(f), Float.valueOf(f3), 20, 20, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
                matrices.popPose();
            }
            matrices.popPose();
            if (this.hasSelected()) {
                object = matrices;
                ResourceLocation resourceLocation4 = selectPointerResource;
                float f = (float)(this.getX() + 10) / 0.5f;
                float f4 = (float)(this.getY() - 3) / 0.5f - (float)this.parent.getSelectPointerOffsetY();
                GuiUtilsKt.blitk$default(object, resourceLocation4, Float.valueOf(f), Float.valueOf(f4), 8, 11, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
            }
            if (!(heldItem = this.pokemon.getHeldItem()).isEmpty()) {
                RenderHelperKt.renderScaledGuiItemIcon$default(heldItem, (double)this.getX() + 16.0, (double)this.getY() + 16.0, 0.5, 0.0f, matrices, 16, null);
            }
        }
    }

    public boolean hasSelected() {
        Pokemon offeredPokemon = this.isOpposing ? this.parent.getTrade().getOppositeOffer().get() : this.parent.getTrade().getMyOffer().get();
        TradeStartedPacket.TradeablePokemon tradeablePokemon = this.pokemon;
        Pokemon pokemon = offeredPokemon;
        return Intrinsics.areEqual((Object)(tradeablePokemon != null ? tradeablePokemon.getPokemonId() : null), (Object)(pokemon != null ? pokemon.getUuid() : null)) && this.pokemon != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isHovered(int mouseX, int mouseY) {
        boolean bl;
        TradeStartedPacket.TradeablePokemon tradeablePokemon = this.pokemon;
        if (tradeablePokemon != null) {
            if (!tradeablePokemon.getTradeable()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        float f = this.getX();
        float f2 = (float)this.getX() + (float)25;
        float f3 = mouseX;
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        f = this.getY();
        f2 = (float)this.getY() + (float)25;
        f3 = mouseY;
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/client/gui/trade/PartySlot$Companion;", "", "<init>", "()V", "", "SIZE", "I", "Lnet/minecraft/resources/ResourceLocation;", "hoverBackgroundResource", "Lnet/minecraft/resources/ResourceLocation;", "genderIconMale", "genderIconFemale", "selectPointerResource", "untradeableResource", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

