/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.camera;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.client.MountedPokemonAnimationRenderController;
import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.duck.CameraDuck;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import com.mojang.blaze3d.Blaze3D;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001a\u0010\u001bJ=\u0010!\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001f\u001a\u00020\u001d2\b\b\u0002\u0010 \u001a\u00020\tH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010%\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b%\u0010&J/\u0010*\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b*\u0010+J'\u00100\u001a\u00020\u00132\u0006\u0010-\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00106R\u0016\u00108\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00104R$\u00109\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lcom/cobblemon/mod/common/client/render/camera/MountedCameraRenderer;", "", "<init>", "()V", "Lnet/minecraft/client/Camera;", "instance", "Lnet/minecraft/world/entity/Entity;", "driver", "vehicle", "", "thirdPersonReverse", "", "eyeHeight", "eyeHeightOld", "Lnet/minecraft/world/phys/Vec3;", "getCameraPosition", "(Lnet/minecraft/client/Camera;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;ZDD)Lnet/minecraft/world/phys/Vec3;", "setRotation", "(Lnet/minecraft/client/Camera;)Z", "", "applyCameraRotation", "(Lnet/minecraft/client/Camera;)V", "Lcom/cobblemon/mod/common/api/orientation/OrientationController;", "vehicleController", "applyTransitionRotation", "(Lcom/cobblemon/mod/common/api/orientation/OrientationController;Lnet/minecraft/client/Camera;)Z", "resetDriverRotations", "(Lnet/minecraft/client/Camera;Lnet/minecraft/world/entity/Entity;)V", "", "", "cameraOffsets", "locatorName", "shouldFlip", "getThirdPersonOffset", "(ZLjava/util/Map;Ljava/lang/String;Z)Lnet/minecraft/world/phys/Vec3;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "model", "getFirstPersonOffset", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;Ljava/lang/String;)Lnet/minecraft/world/phys/Vec3;", "maxZoom", "directionVector", "positionVector", "getMaxZoom", "(DLnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/client/Camera;)D", "Lorg/joml/Quaternionf;", "rotation", "Lcom/cobblemon/mod/common/duck/CameraDuck;", "duck", "setCameraRotations", "(Lorg/joml/Quaternionf;Lnet/minecraft/client/Camera;Lcom/cobblemon/mod/common/duck/CameraDuck;)V", "", "returnTimer", "F", "lastHandledRotationTime", "D", "frameTime", "rollAngleStart", "smoothRotation", "Lorg/joml/Quaternionf;", "getSmoothRotation", "()Lorg/joml/Quaternionf;", "setSmoothRotation", "(Lorg/joml/Quaternionf;)V", "common"})
public final class MountedCameraRenderer {
    @NotNull
    public static final MountedCameraRenderer INSTANCE = new MountedCameraRenderer();
    private static float returnTimer;
    private static double lastHandledRotationTime;
    private static double frameTime;
    private static float rollAngleStart;
    @Nullable
    private static Quaternionf smoothRotation;

    private MountedCameraRenderer() {
    }

    @Nullable
    public final Quaternionf getSmoothRotation() {
        return smoothRotation;
    }

    public final void setSmoothRotation(@Nullable Quaternionf quaternionf) {
        smoothRotation = quaternionf;
    }

    @Nullable
    public final Vec3 getCameraPosition(@NotNull Camera instance, @NotNull Entity driver, @NotNull Entity vehicle, boolean thirdPersonReverse, double eyeHeight, double eyeHeightOld) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        if (!(vehicle instanceof PokemonEntity)) {
            return null;
        }
        PokemonSideDelegate pokemonSideDelegate = ((PokemonEntity)vehicle).getDelegate();
        PokemonClientDelegate pokemonClientDelegate = pokemonSideDelegate instanceof PokemonClientDelegate ? (PokemonClientDelegate)pokemonSideDelegate : null;
        if (pokemonClientDelegate == null) {
            return null;
        }
        PokemonClientDelegate delegate = pokemonClientDelegate;
        Vec3 entityPos = new Vec3(Mth.lerp((double)instance.getPartialTickTime(), (double)vehicle.xOld, (double)((PokemonEntity)vehicle).getX()), Mth.lerp((double)instance.getPartialTickTime(), (double)vehicle.yOld, (double)((PokemonEntity)vehicle).getY()), Mth.lerp((double)instance.getPartialTickTime(), (double)vehicle.zOld, (double)((PokemonEntity)vehicle).getZ()));
        MountedPokemonAnimationRenderController.INSTANCE.setup((PokemonEntity)vehicle, instance.getPartialTickTime());
        OrientationControllable rollable = (OrientationControllable)vehicle;
        OrientationController vehicleController = rollable.getOrientationController();
        PosableModel model = VaryingModelRepository.INSTANCE.getPoser(((PokemonEntity)vehicle).getPokemon().getSpecies().getResourceIdentifier(), new FloatingState());
        String locatorName = delegate.getSeatLocator(driver);
        MatrixWrapper matrixWrapper = delegate.getLocatorStates().get(locatorName);
        if (matrixWrapper == null) {
            return null;
        }
        MatrixWrapper locator = matrixWrapper;
        double currEyeHeight = Mth.lerp((double)instance.getPartialTickTime(), (double)eyeHeight, (double)eyeHeightOld);
        Vec3 offset = new Vec3(0.0, currEyeHeight - (double)(driver.getBbHeight() / (float)2), 0.0);
        Vec3 eyeOffset = new Vec3(0.0, currEyeHeight - (double)(driver.getBbHeight() / (float)2), 0.0);
        boolean shouldFlip = !vehicleController.getActive() || vehicleController.getOrientation() == null;
        boolean isFirstPerson = Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON;
        eyeOffset.add(this.getFirstPersonOffset(model, locatorName));
        offset.add(isFirstPerson ? this.getFirstPersonOffset(model, locatorName) : this.getThirdPersonOffset(thirdPersonReverse, model.getThirdPersonCameraOffset(), locatorName, shouldFlip));
        Quaternionf rotation = vehicleController.isActive() ? vehicleController.getRenderOrientation(instance.getPartialTickTime()) : new Quaternionf().rotateY((float)Math.PI - AngleExtensionsKt.toRadians(Float.valueOf(Mth.lerp((float)instance.getPartialTickTime(), (float)vehicle.yRotO, (float)vehicle.getYRot()))));
        rotation.transform(offset.toVector3f());
        rotation.transform(eyeOffset.toVector3f());
        Vec3 eyeLocatorOffset = new Vec3(locator.getMatrix().getTranslation(new Vector3f()));
        Vec3 eyePos = eyeLocatorOffset.add(entityPos);
        Vec3 pos = new Vec3(locator.getMatrix().getTranslation(new Vector3f())).add(entityPos);
        double offsetDistance = offset.length();
        Vec3 offsetDirection = offset.scale(1.0 / offsetDistance);
        double eyeOffsetDistance = eyeOffset.length();
        Vec3 eyeOffsetDirection = eyeOffset.scale(1.0 / eyeOffsetDistance);
        Intrinsics.checkNotNull((Object)offsetDirection);
        Intrinsics.checkNotNull((Object)pos);
        double maxZoom = this.getMaxZoom(offsetDistance, offsetDirection, pos, instance);
        Intrinsics.checkNotNull((Object)eyeOffsetDirection);
        Intrinsics.checkNotNull((Object)eyePos);
        double eyeMaxZoom = this.getMaxZoom(eyeOffsetDistance, eyeOffsetDirection, eyePos, instance);
        RidePassenger playerRotater = (RidePassenger)driver;
        playerRotater.cobblemon$setRideEyePos(eyeOffsetDirection.scale(eyeMaxZoom).add(eyePos));
        return offsetDirection.scale(maxZoom).add(pos);
    }

    public final boolean setRotation(@NotNull Camera instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        CameraDuck cameraDuck = (CameraDuck)instance;
        double d = Blaze3D.getTime();
        frameTime = !(lastHandledRotationTime == Double.MIN_VALUE) ? d - lastHandledRotationTime : 0.0;
        lastHandledRotationTime = d;
        Entity entity = cameraDuck.cobblemon$getEntity();
        if (entity == null || (entity = entity.getVehicle()) == null) {
            return false;
        }
        Entity vehicle = entity;
        if (!(vehicle instanceof OrientationControllable)) {
            return false;
        }
        OrientationController vehicleController = ((OrientationControllable)vehicle).getOrientationController();
        if (vehicleController.getOrientation() == null) {
            return false;
        }
        if (!vehicleController.isActive() && vehicleController.getOrientation() != null) {
            Intrinsics.checkNotNull((Object)vehicleController);
            return this.applyTransitionRotation(vehicleController, instance);
        }
        this.applyCameraRotation(instance);
        returnTimer = 0.0f;
        rollAngleStart = instance.rotation().getEulerAnglesYXZ(new Vector3f()).z();
        return true;
    }

    public final void applyCameraRotation(@NotNull Camera instance) {
        Quaternionf newRotation;
        boolean isDriving;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        CameraDuck cameraDuck = (CameraDuck)instance;
        Entity entity = cameraDuck.cobblemon$getEntity();
        if (entity == null) {
            return;
        }
        Entity driver = entity;
        Entity entity2 = driver.getVehicle();
        if (entity2 == null) {
            return;
        }
        Entity vehicle = entity2;
        OrientationControllable orientationControllable = vehicle instanceof OrientationControllable ? (OrientationControllable)vehicle : null;
        if (orientationControllable == null) {
            return;
        }
        OrientationControllable controllableVehicle = orientationControllable;
        if (((OrientationControllable)vehicle).getOrientationController().getOrientation() == null || !controllableVehicle.getOrientationController().getActive()) {
            return;
        }
        OrientationController orientationController = controllableVehicle.getOrientationController();
        Intrinsics.checkNotNullExpressionValue((Object)orientationController, (String)"getOrientationController(...)");
        OrientationController vehicleController = orientationController;
        boolean bl = isDriving = driver.getControlledVehicle() != null;
        if (isDriving) {
            Matrix3f matrix3f = vehicleController.getOrientation();
            Intrinsics.checkNotNull((Object)matrix3f);
            v6 = matrix3f.normal(new Matrix3f()).getNormalizedRotation(new Quaternionf());
        } else {
            v6 = newRotation = vehicleController.getRenderOrientation(instance.getPartialTickTime());
        }
        if (Cobblemon.INSTANCE.getConfig().getDisableRoll()) {
            if (smoothRotation == null) {
                smoothRotation = new Quaternionf().set((Quaternionfc)instance.rotation());
            }
            Vector3f rideAngs = newRotation.getEulerAnglesYXZ(new Vector3f());
            Quaternionf quaternionf = smoothRotation;
            Intrinsics.checkNotNull((Object)quaternionf);
            Vector3f cameraAngs = quaternionf.getEulerAnglesYXZ(new Vector3f());
            float degDiff = Mth.degreesDifference((float)((float)Math.toDegrees(cameraAngs.y())), (float)((float)Math.toDegrees(rideAngs.y())));
            double pitchDeadzoneDeg = 15.0;
            float pitchDeg = vehicleController.getPitch();
            double cutoffPitch = Math.min(1.0, (double)Mth.abs((float)pitchDeg) / ((double)90.0f - pitchDeadzoneDeg)) * (double)90.0f * (double)Math.signum(pitchDeg);
            float lerpRateMod = Mth.cos((float)((float)Math.toRadians(cutoffPitch)));
            float k = Minecraft.getInstance().isPaused() ? 0.0f : 10.0f;
            double smoothingFactor = (double)lerpRateMod * frameTime * (double)k;
            double newYaw = (double)cameraAngs.y() + Math.toRadians(degDiff) * smoothingFactor;
            double newPitch = Mth.lerp((double)(frameTime * (double)k), (double)cameraAngs.x(), (double)rideAngs.x());
            double maxRoll = Math.toRadians(0.0);
            float newRoll = (float)Mth.lerp((double)(frameTime * (double)k / 2.0), (double)cameraAngs.z(), (double)0.0);
            Quaternionf smoothedRot = new Quaternionf().rotateYXZ((float)newYaw, (float)newPitch, newRoll);
            Quaternionf quaternionf2 = smoothRotation;
            if (quaternionf2 != null) {
                quaternionf2.set((Quaternionfc)smoothedRot);
            }
            newRotation.set((Quaternionfc)smoothedRot);
        }
        int rotationOffset = 0;
        if (Minecraft.getInstance().options.getCameraType().isMirrored()) {
            newRotation.rotateY((float)Math.toRadians(180.0));
            rotationOffset = 180;
        }
        if (vehicleController.getActive()) {
            Matrix3f vehicleMatrix = new Matrix3f().set((Quaternionfc)newRotation);
            Matrix3f driverMatrix = new Matrix3f();
            RidePassenger playerRotater = (RidePassenger)driver;
            newRotation = vehicleMatrix.mul((Matrix3fc)driverMatrix.rotateYXZ((float)(-Math.PI) / 180 * playerRotater.cobblemon$getRideYRot(), (float)(-Math.PI) / 180 * playerRotater.cobblemon$getRideXRot(), 0.0f)).normal(new Matrix3f()).getNormalizedRotation(new Quaternionf());
        }
        Vector3f eulerAngs = newRotation.getEulerAnglesYXZ(new Vector3f());
        Quaternionf quaternionf = newRotation;
        Intrinsics.checkNotNull((Object)quaternionf);
        this.setCameraRotations(quaternionf, instance, cameraDuck);
        driver.setXRot(-eulerAngs.x() * 57.295776f + (float)rotationOffset);
        driver.setYRot(180.0f - eulerAngs.y() * 57.295776f);
    }

    private final boolean applyTransitionRotation(OrientationController vehicleController, Camera instance) {
        Intrinsics.checkNotNull((Object)instance, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.duck.CameraDuck");
        CameraDuck cameraDuck = (CameraDuck)instance;
        Entity entity = cameraDuck.cobblemon$getEntity();
        Intrinsics.checkNotNull((Object)entity);
        Entity entity2 = entity;
        if (returnTimer == 0.0f) {
            this.resetDriverRotations(instance, entity2);
        }
        if (returnTimer < 1.0f) {
            float interpolatedRoll = Mth.lerp((float)returnTimer, (float)rollAngleStart, (float)0.0f);
            float pitch = (float)Math.toRadians(-((double)entity2.getXRot()));
            float yaw = (float)Math.toRadians((float)180 - entity2.getYRot());
            Quaternionf interRot = new Quaternionf();
            interRot.rotationYXZ(yaw, pitch, interpolatedRoll);
            this.setCameraRotations(interRot, instance, cameraDuck);
            if (rollAngleStart == 0.0f) {
                rollAngleStart = 1.0f;
                vehicleController.reset();
                this.resetDriverRotations(instance, entity2);
                return false;
            }
            returnTimer += instance.getPartialTickTime() * 0.05f;
            return true;
        }
        returnTimer = 1.0f;
        vehicleController.reset();
        this.resetDriverRotations(instance, entity2);
        return false;
    }

    public final void resetDriverRotations(@NotNull Camera instance, @NotNull Entity driver) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vector3f eulerAngs = new Quaternionf((Quaternionfc)instance.rotation()).getEulerAnglesYXZ(new Vector3f());
        RidePassenger playerRotater = (RidePassenger)driver;
        playerRotater.cobblemon$setRideXRot(-eulerAngs.x() * 57.295776f);
        playerRotater.cobblemon$setRideYRot(180.0f - eulerAngs.y() * 57.295776f);
    }

    private final Vec3 getThirdPersonOffset(boolean thirdPersonReverse, Map<String, ? extends Vec3> cameraOffsets, String locatorName, boolean shouldFlip) {
        Vec3 vec3;
        Vec3 offset;
        if (thirdPersonReverse && cameraOffsets.containsKey(locatorName + "_reverse")) {
            Vec3 vec32 = cameraOffsets.get(locatorName + "_reverse");
            Intrinsics.checkNotNull((Object)vec32);
            v1 = vec32;
        } else if (cameraOffsets.containsKey(locatorName)) {
            Vec3 vec33 = cameraOffsets.get(locatorName);
            Intrinsics.checkNotNull((Object)vec33);
            v1 = vec33;
        } else {
            v1 = offset = Vec3.ZERO;
        }
        if (thirdPersonReverse && shouldFlip) {
            Vec3 vec34 = offset.multiply(1.0, 1.0, -1.0);
            vec3 = vec34;
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"multiply(...)");
        } else {
            Intrinsics.checkNotNull((Object)offset);
            vec3 = offset;
        }
        return vec3;
    }

    static /* synthetic */ Vec3 getThirdPersonOffset$default(MountedCameraRenderer mountedCameraRenderer, boolean bl, Map map, String string, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return mountedCameraRenderer.getThirdPersonOffset(bl, map, string, bl2);
    }

    private final Vec3 getFirstPersonOffset(PosableModel model, String locatorName) {
        Vec3 vec3;
        Map<String, Vec3> cameraOffsets = model.getFirstPersonCameraOffset();
        if (cameraOffsets.containsKey(locatorName)) {
            Vec3 vec32 = cameraOffsets.get(locatorName);
            Intrinsics.checkNotNull((Object)vec32);
            vec3 = vec32;
        } else {
            Vec3 vec33 = Vec3.ZERO;
            Intrinsics.checkNotNull((Object)vec33);
            vec3 = vec33;
        }
        return vec3;
    }

    private final double getMaxZoom(double maxZoom, Vec3 directionVector, Vec3 positionVector, Camera instance) {
        double maxZoom2 = maxZoom;
        for (int i = 0; i < 8; ++i) {
            double k;
            float g = (i & 1) * 2 - 1;
            float h = (i >> 1 & 1) * 2 - 1;
            float j = (i >> 2 & 1) * 2 - 1;
            Vec3 vec3 = positionVector.add((double)(g * 0.1f), (double)(h * 0.1f), (double)(j * 0.1f));
            Vec3 vec32 = vec3.add(directionVector.scale(maxZoom2));
            Intrinsics.checkNotNull((Object)instance, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.duck.CameraDuck");
            BlockGetter level = ((CameraDuck)instance).cobblemon$getLevel();
            BlockHitResult blockHitResult = level.clip(new ClipContext(vec3, vec32, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, instance.getEntity()));
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
            HitResult hitResult = (HitResult)blockHitResult;
            if (hitResult.getType() == HitResult.Type.MISS || !((k = hitResult.getLocation().distanceToSqr(positionVector)) < Mth.square((double)maxZoom2))) continue;
            maxZoom2 = Math.sqrt(k);
        }
        return maxZoom2;
    }

    private final void setCameraRotations(Quaternionf rotation, Camera instance, CameraDuck duck) {
        Vector3f eulerAngs = rotation.getEulerAnglesYXZ(new Vector3f());
        Quaternionf cameraRotation = instance.rotation();
        cameraRotation.rotationYXZ(eulerAngs.y, eulerAngs.x, eulerAngs.z);
        duck.cobblemon$setXRot(eulerAngs.x() * 57.295776f);
        duck.cobblemon$setYRot(eulerAngs.y() * 57.295776f);
        OrientationController.Companion.getFORWARDS().rotate((Quaternionfc)rotation, duck.cobblemon$getForwards());
        OrientationController.Companion.getUP().rotate((Quaternionfc)rotation, duck.cobblemon$getUp());
        OrientationController.Companion.getLEFT().rotate((Quaternionfc)cameraRotation, duck.cobblemon$getLeft());
    }

    static {
        lastHandledRotationTime = Double.MIN_VALUE;
    }
}

