/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/command/HealPokemonCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "source", "Lnet/minecraft/server/level/ServerPlayer;", "target", "", "execute", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/server/level/ServerPlayer;)I", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BATTLE_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "common"})
public final class HealPokemonCommand {
    @NotNull
    public static final HealPokemonCommand INSTANCE = new HealPokemonCommand();
    @NotNull
    private static final SimpleCommandExceptionType IN_BATTLE_EXCEPTION;

    private HealPokemonCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"healpokemon");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder2 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getHEAL_POKEMON_SELF(), false, 2, null)).executes(HealPokemonCommand::register$lambda$0);
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player()));
        Intrinsics.checkNotNullExpressionValue((Object)requiredArgumentBuilder, (String)"argument(...)");
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)literalArgumentBuilder2.then(((RequiredArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)requiredArgumentBuilder, CobblemonPermissions.getHEAL_POKEMON_OTHER(), false, 2, null)).executes(HealPokemonCommand::register$lambda$1)));
        Intrinsics.checkNotNull((Object)command);
        dispatcher.register(CommandUtilsKt.alias(command, "pokeheal"));
    }

    private final int execute(CommandSourceStack source, ServerPlayer target) {
        if (PlayerExtensionsKt.isInBattle(target)) {
            CommandSyntaxException commandSyntaxException = IN_BATTLE_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        if (!target.level().isClientSide) {
            PlayerPartyStore party = PlayerExtensionsKt.party(target);
            party.heal();
            source.sendSuccess(() -> HealPokemonCommand.execute$lambda$0(target), true);
        }
        return 1;
    }

    private static final int register$lambda$0(CommandContext it) {
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute(commandSourceStack, serverPlayer);
    }

    private static final int register$lambda$1(CommandContext it) {
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = CommandContextExtensionsKt.player((CommandContext<CommandSourceStack>)it, "player");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"player(...)");
        return INSTANCE.execute(commandSourceStack, serverPlayer);
    }

    private static final Component execute$lambda$0(ServerPlayer $target) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)$target.getName(), (String)"getName(...)");
        return (Component)LocalizationUtilsKt.commandLang("healpokemon.heal", objectArray);
    }

    static {
        MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("pokeheal.in_battle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
        IN_BATTLE_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent));
    }
}

