/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.storage.RenamePCBoxEvent;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.net.messages.client.storage.pc.RenamePCBoxPacket;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R(\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/command/RenameBoxCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "box", "", "name", "execute", "(Lnet/minecraft/server/level/ServerPlayer;ILjava/lang/String;)I", "Lkotlin/Function1;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "BOX_DOES_NOT_EXIST", "Lkotlin/jvm/functions/Function1;", "CANNOT_RENAME_BOX", "common"})
@SourceDebugExtension(value={"SMAP\nRenameBoxCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameBoxCommand.kt\ncom/cobblemon/mod/common/command/RenameBoxCommand\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,76:1\n40#2:77\n41#2,4:81\n46#2:94\n47#2:97\n17#3,2:78\n14#3,5:85\n19#3:93\n19#3:96\n13805#4:80\n13805#4:90\n13806#4:92\n13806#4:95\n14#5:91\n*S KotlinDebug\n*F\n+ 1 RenameBoxCommand.kt\ncom/cobblemon/mod/common/command/RenameBoxCommand\n*L\n62#1:77\n62#1:81,4\n62#1:94\n62#1:97\n62#1:78,2\n66#1:85,5\n66#1:93\n62#1:96\n62#1:80\n66#1:90\n66#1:92\n62#1:95\n66#1:91\n*E\n"})
public final class RenameBoxCommand {
    @NotNull
    public static final RenameBoxCommand INSTANCE = new RenameBoxCommand();
    @NotNull
    private static final Function1<Integer, MutableComponent> BOX_DOES_NOT_EXIST = RenameBoxCommand::BOX_DOES_NOT_EXIST$lambda$0;
    @NotNull
    private static final Function1<String, MutableComponent> CANNOT_RENAME_BOX = RenameBoxCommand::CANNOT_RENAME_BOX$lambda$0;

    private RenameBoxCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"renamebox");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getRENAMEBOX(), false, 2, null)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).then(Commands.argument((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(RenameBoxCommand::register$lambda$0)))));
    }

    /*
     * WARNING - void declaration
     */
    private final int execute(ServerPlayer player, int box, String name) {
        void this_$iv$iv;
        void event$iv;
        void this_$iv;
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        if (playerPc.getBoxes().size() < box) {
            Object object = BOX_DOES_NOT_EXIST.invoke((Object)box);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        PCBox pcBox = playerPc.getBoxes().get(box - 1);
        CancelableObservable<RenamePCBoxEvent.Pre> cancelableObservable = CobblemonEvents.RENAME_PC_BOX_EVENT_PRE;
        RenamePCBoxEvent.Pre pre = new RenamePCBoxEvent.Pre(player, pcBox, name);
        CancelableObservable<RenamePCBoxEvent.Pre> cancelableObservable2 = cancelableObservable;
        Cancelable cancelable = pre;
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$iv;
            RenamePCBoxEvent.Pre it;
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                it = (RenamePCBoxEvent.Pre)it$iv;
                boolean bl2 = false;
                Object object = CANNOT_RENAME_BOX.invoke((Object)name);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            it = (RenamePCBoxEvent.Pre)it$iv;
            boolean bl3 = false;
            pcBox.setName(it.getName());
            EventObservable<RenamePCBoxEvent.Post> eventObservable2 = CobblemonEvents.RENAME_PC_BOX_EVENT_POST;
            RenamePCBoxEvent.Post[] postArray = new RenamePCBoxEvent.Post[]{new RenamePCBoxEvent.Post(player, pcBox, it.getName())};
            RenamePCBoxEvent.Post[] events$iv = postArray;
            boolean $i$f$post2 = false;
            $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
            RenamePCBoxEvent.Post[] $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv$iv.length;
            for (int j = 0; j < n2; ++j) {
                RenamePCBoxEvent.Post element$iv$iv;
                RenamePCBoxEvent.Post post2 = element$iv$iv = $this$forEach$iv$iv[j];
                boolean bl4 = false;
                RenamePCBoxEvent.Post it2 = post2;
            }
            new RenamePCBoxPacket(playerPc.getUuid(), pcBox.getBoxNumber(), it.getName()).sendToPlayer(player);
        }
        return 1;
    }

    private static final MutableComponent BOX_DOES_NOT_EXIST$lambda$0(int boxNo) {
        Object[] objectArray = new Object[]{boxNo};
        return LocalizationUtilsKt.commandLang("pokebox.box_does_not_exist", objectArray);
    }

    private static final MutableComponent CANNOT_RENAME_BOX$lambda$0(String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new Object[]{name};
        return LocalizationUtilsKt.commandLang("renamebox.cannot_rename_box", objectArray);
    }

    private static final int register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        ServerPlayer player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        String name = StringArgumentType.getString((CommandContext)context, (String)"name");
        Intrinsics.checkNotNull((Object)player);
        Intrinsics.checkNotNull((Object)name);
        return INSTANCE.execute(player, box, name);
    }
}

