/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.datafixer;

import com.cobblemon.mod.common.datafixer.CobblemonSchemas;
import com.cobblemon.mod.common.datafixer.CobblemonTypeReferences;
import com.cobblemon.mod.common.datafixer.fix.BlockPosUpdateFix;
import com.cobblemon.mod.common.datafixer.fix.EvolutionProxyNestingFix;
import com.cobblemon.mod.common.datafixer.fix.FeatureFix;
import com.cobblemon.mod.common.datafixer.fix.HypertrainIVFix;
import com.cobblemon.mod.common.datafixer.fix.IvEvToIdentifierFix;
import com.cobblemon.mod.common.datafixer.fix.MovesetJsonFix;
import com.cobblemon.mod.common.datafixer.fix.NicknameFix;
import com.cobblemon.mod.common.datafixer.fix.RaisedPPStagesFix;
import com.cobblemon.mod.common.datafixer.fix.ShoulderStateJsonFix;
import com.cobblemon.mod.common.datafixer.fix.TeraTypeFix;
import com.cobblemon.mod.common.datafixer.fix.TradeableMissingFix;
import com.cobblemon.mod.common.datafixer.schema.CobblemonRootSchema;
import com.cobblemon.mod.common.datafixer.schema.CobblemonSchemaV2;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\"\u0004\b\u0000\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00060\u000bR\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R&\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u000bR\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00148\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010 \u001a\u00020\u001c8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020!8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/datafixer/CobblemonSchemas;", "", "<init>", "()V", "T", "Lcom/mojang/serialization/Codec;", "codec", "Lcom/mojang/datafixers/DSL$TypeReference;", "typeReference", "wrapCodec", "(Lcom/mojang/serialization/Codec;Lcom/mojang/datafixers/DSL$TypeReference;)Lcom/mojang/serialization/Codec;", "Lcom/mojang/datafixers/DataFixerBuilder$Result;", "Lcom/mojang/datafixers/DataFixerBuilder;", "create", "()Lcom/mojang/datafixers/DataFixerBuilder$Result;", "builder", "", "appendSchemas", "(Lcom/mojang/datafixers/DataFixerBuilder;)V", "Lkotlin/Function2;", "", "Lcom/mojang/datafixers/schemas/Schema;", "SAME", "Lkotlin/jvm/functions/Function2;", "RESULT", "Lcom/mojang/datafixers/DataFixerBuilder$Result;", "DATA_VERSION", "I", "Lcom/mojang/datafixers/DataFixer;", "getDATA_FIXER", "()Lcom/mojang/datafixers/DataFixer;", "getDATA_FIXER$annotations", "DATA_FIXER", "", "VERSION_KEY", "Ljava/lang/String;", "CobblemonDataFixerCodec", "common"})
public final class CobblemonSchemas {
    @NotNull
    public static final CobblemonSchemas INSTANCE = new CobblemonSchemas();
    @NotNull
    private static final Function2<Integer, Schema, Schema> SAME = SAME.1.INSTANCE;
    @NotNull
    private static final DataFixerBuilder.Result RESULT = INSTANCE.create();
    public static final int DATA_VERSION = 2;
    @NotNull
    public static final String VERSION_KEY = "cobblemon:data_version";

    private CobblemonSchemas() {
    }

    @NotNull
    public static final DataFixer getDATA_FIXER() {
        DataFixer dataFixer = RESULT.fixer();
        Intrinsics.checkNotNullExpressionValue((Object)dataFixer, (String)"fixer(...)");
        return dataFixer;
    }

    @JvmStatic
    public static /* synthetic */ void getDATA_FIXER$annotations() {
    }

    @NotNull
    public final <T> Codec<T> wrapCodec(@NotNull Codec<T> codec, @NotNull DSL.TypeReference typeReference) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        return new CobblemonDataFixerCodec<T>(codec, typeReference);
    }

    private final DataFixerBuilder.Result create() {
        DataFixerBuilder builder = new DataFixerBuilder(2);
        this.appendSchemas(builder);
        Set<DSL.TypeReference> types = CobblemonTypeReferences.INSTANCE.types();
        DataFixerBuilder.Result result = builder.build();
        if (types.isEmpty()) {
            Intrinsics.checkNotNull((Object)result);
            return result;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("cobblemon Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        result.optimize(types, (Executor)executor).join();
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private final void appendSchemas(DataFixerBuilder builder) {
        builder.addSchema(0, CobblemonRootSchema::new);
        Schema schema1 = builder.addSchema(1, CobblemonSchemaV2::new);
        Intrinsics.checkNotNull((Object)schema1);
        builder.addFixer((DataFix)new EvolutionProxyNestingFix(schema1));
        builder.addFixer((DataFix)new IvEvToIdentifierFix(schema1));
        builder.addFixer((DataFix)new TeraTypeFix(schema1));
        builder.addFixer((DataFix)new TradeableMissingFix(schema1));
        builder.addFixer((DataFix)new ItemStackComponentizationFix(schema1));
        builder.addFixer((DataFix)new BlockPosUpdateFix(schema1));
        builder.addFixer((DataFix)new FeatureFix(schema1));
        builder.addFixer((DataFix)new MovesetJsonFix(schema1));
        builder.addFixer((DataFix)new ShoulderStateJsonFix(schema1));
        builder.addFixer((DataFix)new NicknameFix(schema1));
        builder.addFixer((DataFix)new RaisedPPStagesFix(schema1));
        Schema schema2 = builder.addSchema(2, (arg_0, arg_1) -> CobblemonSchemas.appendSchemas$lambda$0(SAME, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)schema2);
        builder.addFixer((DataFix)new HypertrainIVFix(schema2));
    }

    private static final Schema appendSchemas$lambda$0(Function2 $tmp0, Integer p0, Schema p1) {
        return (Schema)$tmp0.invoke((Object)p0, (Object)p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J9\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\"\u0004\b\u0001\u0010\b2\u0006\u0010\t\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ=\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\r\"\u0004\b\u0001\u0010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/datafixer/CobblemonSchemas$CobblemonDataFixerCodec;", "R", "Lcom/mojang/serialization/Codec;", "baseCodec", "Lcom/mojang/datafixers/DSL$TypeReference;", "typeReference", "<init>", "(Lcom/mojang/serialization/Codec;Lcom/mojang/datafixers/DSL$TypeReference;)V", "T", "input", "Lcom/mojang/serialization/DynamicOps;", "ops", "prefix", "Lcom/mojang/serialization/DataResult;", "encode", "(Ljava/lang/Object;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "Lcom/mojang/datafixers/util/Pair;", "decode", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "Lcom/mojang/serialization/Codec;", "Lcom/mojang/datafixers/DSL$TypeReference;", "common"})
    private static final class CobblemonDataFixerCodec<R>
    implements Codec<R> {
        @NotNull
        private final Codec<R> baseCodec;
        @NotNull
        private final DSL.TypeReference typeReference;

        public CobblemonDataFixerCodec(@NotNull Codec<R> baseCodec, @NotNull DSL.TypeReference typeReference) {
            Intrinsics.checkNotNullParameter(baseCodec, (String)"baseCodec");
            Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
            this.baseCodec = baseCodec;
            this.typeReference = typeReference;
        }

        @NotNull
        public <T> DataResult<T> encode(R input, @NotNull DynamicOps<T> ops, T prefix) {
            Intrinsics.checkNotNullParameter(ops, (String)"ops");
            DataResult dataResult = this.baseCodec.encode(input, ops, prefix).flatMap(arg_0 -> CobblemonDataFixerCodec.encode$lambda$1(arg_0 -> CobblemonDataFixerCodec.encode$lambda$0(ops, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"flatMap(...)");
            return dataResult;
        }

        @NotNull
        public <T> DataResult<Pair<R, T>> decode(@NotNull DynamicOps<T> ops, T input) {
            Intrinsics.checkNotNullParameter(ops, (String)"ops");
            Integer inputVersion2 = ops.get(input, CobblemonSchemas.VERSION_KEY).flatMap(arg_0 -> CobblemonDataFixerCodec.decode$lambda$0((Function1)new Function1<T, DataResult<Number>>(ops){

                public final DataResult<Number> invoke(T p0) {
                    return ((DynamicOps)this.receiver).getNumberValue(p0);
                }
            }, arg_0)).map(arg_0 -> CobblemonDataFixerCodec.decode$lambda$1(decode.inputVersion.2.INSTANCE, arg_0)).result().orElse(0);
            Dynamic dynamicWithoutVersion = new Dynamic(ops, ops.remove(input, CobblemonSchemas.VERSION_KEY));
            DataFixer dataFixer = CobblemonSchemas.getDATA_FIXER();
            Intrinsics.checkNotNull((Object)inputVersion2);
            Dynamic dataFixedDynamic = dataFixer.update(this.typeReference, dynamicWithoutVersion, inputVersion2.intValue(), 2);
            DataResult dataResult = this.baseCodec.decode(dataFixedDynamic);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"decode(...)");
            return dataResult;
        }

        private static final DataResult encode$lambda$0(DynamicOps $ops, Object encoded) {
            return $ops.mergeToMap(encoded, $ops.createString(CobblemonSchemas.VERSION_KEY), $ops.createInt(2));
        }

        private static final DataResult encode$lambda$1(Function1 $tmp0, Object p0) {
            return (DataResult)$tmp0.invoke(p0);
        }

        private static final DataResult decode$lambda$0(Function1 $tmp0, Object p0) {
            return (DataResult)$tmp0.invoke(p0);
        }

        private static final Integer decode$lambda$1(Function1 $tmp0, Object p0) {
            return (Integer)$tmp0.invoke(p0);
        }
    }
}

