/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.ai;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001b\u0010\u001aR\u0017\u0010\u0006\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/entity/ai/LookInDirectionTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lnet/minecraft/world/entity/LivingEntity;", "Lcom/bedrockk/molang/Expression;", "shouldLock", "yaw", "pitch", "<init>", "(Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "entity", "", "gameTime", "", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)Z", "owner", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)Z", "", "stop", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)V", "tick", "Lcom/bedrockk/molang/Expression;", "getShouldLock", "()Lcom/bedrockk/molang/Expression;", "getYaw", "getPitch", "common"})
public final class LookInDirectionTask
extends Behavior<LivingEntity> {
    @NotNull
    private final Expression shouldLock;
    @NotNull
    private final Expression yaw;
    @NotNull
    private final Expression pitch;

    public LookInDirectionTask(@NotNull Expression shouldLock, @NotNull Expression yaw, @NotNull Expression pitch) {
        Intrinsics.checkNotNullParameter((Object)shouldLock, (String)"shouldLock");
        Intrinsics.checkNotNullParameter((Object)yaw, (String)"yaw");
        Intrinsics.checkNotNullParameter((Object)pitch, (String)"pitch");
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 0, 0);
        this.shouldLock = shouldLock;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public /* synthetic */ LookInDirectionTask(Expression expression, Expression expression2, Expression expression3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Expression expression4 = MoLangExtensionsKt.asExpression("true");
            Intrinsics.checkNotNullExpressionValue((Object)expression4, (String)"asExpression(...)");
            expression = expression4;
        }
        if ((n & 2) != 0) {
            Expression expression5 = MoLangExtensionsKt.asExpression("0");
            Intrinsics.checkNotNullExpressionValue((Object)expression5, (String)"asExpression(...)");
            expression2 = expression5;
        }
        if ((n & 4) != 0) {
            Expression expression6 = MoLangExtensionsKt.asExpression("0");
            Intrinsics.checkNotNullExpressionValue((Object)expression6, (String)"asExpression(...)");
            expression3 = expression6;
        }
        this(expression, expression2, expression3);
    }

    @NotNull
    public final Expression getShouldLock() {
        return this.shouldLock;
    }

    @NotNull
    public final Expression getYaw() {
        return this.yaw;
    }

    @NotNull
    public final Expression getPitch() {
        return this.pitch;
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull LivingEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !entity.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).isPresent() && MoLangExtensionsKt.resolveBoolean$default(MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity)), this.shouldLock, null, 2, null);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull LivingEntity owner) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return owner instanceof PathfinderMob && !((PathfinderMob)owner).getBrain().getMemory(MemoryModuleType.LOOK_TARGET).isPresent() && MoLangExtensionsKt.resolveBoolean$default(MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)owner)), this.shouldLock, null, 2, null);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull LivingEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }

    protected void tick(@NotNull ServerLevel level, @NotNull LivingEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PathfinderMob cfr_ignored_0 = (PathfinderMob)entity;
        MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity));
        double yaw = (double)(MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getMainThreadRuntime(), this.yaw, null, 2, null) + (float)90) * Math.PI / 180.0;
        double pitch = (double)MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getMainThreadRuntime(), this.pitch, null, 2, null) * Math.PI / 180.0 * (double)-1;
        double xDisp = Math.cos(yaw);
        double zDisp = Math.sin(yaw);
        double yDisp = Math.sin(pitch);
        ((PathfinderMob)entity).getLookControl().setLookAt(((PathfinderMob)entity).getX() + xDisp, ((PathfinderMob)entity).getY() + (double)((PathfinderMob)entity).getEyeHeight() + yDisp, ((PathfinderMob)entity).getZ() + zDisp);
    }

    public LookInDirectionTask() {
        this(null, null, null, 7, null);
    }
}

