/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.boat;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.entity.boat.CobblemonBoatEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 `2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001`B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\nB)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010(\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b,\u0010\u0017J\u0017\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b/\u00100J\u001f\u00102\u001a\u00020.2\u0006\u0010-\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020.2\u0006\u0010-\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b4\u00100J\u001f\u00106\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00152\u0006\u00105\u001a\u00020.H\u0016\u00a2\u0006\u0004\b6\u00107J\u0019\u00109\u001a\u0004\u0018\u0001082\u0006\u0010-\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b;\u0010+J\u0017\u0010=\u001a\u00020<2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b=\u0010>J)\u0010C\u001a\u0004\u0018\u00010B2\u0006\u0010?\u001a\u00020\u00152\u0006\u0010A\u001a\u00020@2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\bC\u0010DJ\u0017\u0010G\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010EH\u0016\u00a2\u0006\u0004\bG\u0010HJ\u001f\u0010J\u001a\u00020\u00122\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010EH\u0016\u00a2\u0006\u0004\bJ\u0010KJ\u000f\u0010M\u001a\u00020LH\u0016\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010P\u001a\u00020\u00122\u0006\u0010O\u001a\u00020LH\u0016\u00a2\u0006\u0004\bP\u0010QJ\u0015\u0010S\u001a\b\u0012\u0004\u0012\u00020.0RH\u0016\u00a2\u0006\u0004\bS\u0010TJ\u000f\u0010U\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\bU\u0010+J\u000f\u0010W\u001a\u00020VH\u0016\u00a2\u0006\u0004\bW\u0010XJ\u0015\u0010Y\u001a\b\u0012\u0004\u0012\u00020.0RH\u0002\u00a2\u0006\u0004\bY\u0010TJ\u0017\u0010Z\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\bZ\u0010\u0014R\u001c\u0010[\u001a\b\u0012\u0004\u0012\u00020.0R8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u001e\u0010]\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010E8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0016\u0010O\u001a\u00020L8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010_\u00a8\u0006a"}, d2={"Lcom/cobblemon/mod/common/entity/boat/CobblemonChestBoatEntity;", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;", "Lnet/minecraft/world/entity/HasCustomInventoryScreen;", "Lnet/minecraft/world/entity/vehicle/ContainerEntity;", "Lnet/minecraft/world/entity/EntityType;", "entityType", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "", "x", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "openCustomInventoryScreen", "(Lnet/minecraft/world/entity/player/Player;)V", "", "getMaxPassengers", "()I", "Lnet/minecraft/nbt/CompoundTag;", "compound", "addAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "readAdditionalSaveData", "Lnet/minecraft/world/damagesource/DamageSource;", "source", "destroy", "(Lnet/minecraft/world/damagesource/DamageSource;)V", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "reason", "remove", "(Lnet/minecraft/world/entity/Entity$RemovalReason;)V", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResult;", "interact", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", "clearContent", "()V", "getContainerSize", "slot", "Lnet/minecraft/world/item/ItemStack;", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "stack", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/SlotAccess;", "getSlot", "(I)Lnet/minecraft/world/entity/SlotAccess;", "setChanged", "", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "syncId", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/storage/loot/LootTable;", "getLootTable", "()Lnet/minecraft/resources/ResourceKey;", "lootTable", "setLootTable", "(Lnet/minecraft/resources/ResourceKey;)V", "", "getLootTableSeed", "()J", "lootTableSeed", "setLootTableSeed", "(J)V", "Lnet/minecraft/core/NonNullList;", "getItemStacks", "()Lnet/minecraft/core/NonNullList;", "clearItemStacks", "Lnet/minecraft/world/item/Item;", "getDropItem", "()Lnet/minecraft/world/item/Item;", "emptyInventory", "stopOpen", "inventory", "Lnet/minecraft/core/NonNullList;", "lootTableId", "Lnet/minecraft/resources/ResourceKey;", "J", "Companion", "common"})
public final class CobblemonChestBoatEntity
extends CobblemonBoatEntity
implements HasCustomInventoryScreen,
ContainerEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> inventory;
    @Nullable
    private ResourceKey<LootTable> lootTableId;
    private long lootTableSeed;
    private static final int INVENTORY_SLOTS = 27;

    public CobblemonChestBoatEntity(@NotNull EntityType<CobblemonChestBoatEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.inventory = this.emptyInventory();
    }

    public CobblemonChestBoatEntity(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(CobblemonEntities.CHEST_BOAT, world);
    }

    public CobblemonChestBoatEntity(@NotNull Level world, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(CobblemonEntities.CHEST_BOAT, world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void openCustomInventoryScreen(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.openMenu((MenuProvider)this);
        if (!player.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        this.addChestVehicleSaveData(compound, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.readChestVehicleSaveData(compound, (HolderLookup.Provider)this.registryAccess());
    }

    public void destroy(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.destroy(this.getDropItem());
        this.chestVehicleDestroyed(source, this.level(), (Entity)this);
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)((Entity)this), (Container)((Container)this));
        }
        super.remove(reason);
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult interactionResult;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!player.isSecondaryUseActive() && (interactionResult = super.interact(player, hand)) != InteractionResult.PASS) {
            Intrinsics.checkNotNull((Object)interactionResult);
            return interactionResult;
        }
        if (this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        InteractionResult interactionResult2 = this.interactWithContainerVehicle(player);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"interactWithContainerVehicle(...)");
        interactionResult = interactionResult2;
        if (interactionResult.consumesAction()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return interactionResult;
    }

    public void clearContent() {
        this.clearItemStacks();
    }

    public int getContainerSize() {
        return 27;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack = this.getChestVehicleItem(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getChestVehicleItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = this.removeChestVehicleItem(slot, amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeChestVehicleItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = this.removeChestVehicleItemNoUpdate(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeChestVehicleItemNoUpdate(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.setChestVehicleItem(slot, stack);
    }

    @Nullable
    public SlotAccess getSlot(int slot) {
        return this.getChestVehicleSlot(slot);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.isChestVehicleStillValid(player);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.lootTableId != null && player.isSpectator()) {
            return null;
        }
        this.unpackChestVehicleLootTable(playerInventory.player);
        return (AbstractContainerMenu)ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)((Container)this));
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTableId;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.lootTableId = lootTable;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.inventory;
    }

    public void clearItemStacks() {
        this.inventory = this.emptyInventory();
    }

    @Override
    @NotNull
    public Item getDropItem() {
        return this.getBoatType().getChestBoatItem();
    }

    private final NonNullList<ItemStack> emptyInventory() {
        NonNullList nonNullList = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        return nonNullList;
    }

    public void stopOpen(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.level().gameEvent((Holder)GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.Context.of((Entity)((Entity)player)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/boat/CobblemonChestBoatEntity$Companion;", "", "<init>", "()V", "", "INVENTORY_SLOTS", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

