/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/SweetBerryBushSensor;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "Lnet/minecraft/world/entity/LivingEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "level", "entity", "", "doTick", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V", "", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "requires", "()Ljava/util/Set;", "Lnet/minecraft/core/BlockPos;", "origin", "Ljava/util/Optional;", "findNearestBush", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Ljava/util/Optional;", "Companion", "common"})
public final class SweetBerryBushSensor
extends Sensor<LivingEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int SCAN_RADIUS_HORIZONTAL = 10;
    public static final int SCAN_RADIUS_VERTICAL = 1;
    public static final int SCAN_INTERVAL = 40;

    public SweetBerryBushSensor() {
        super(40);
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockPos pos = entity.blockPosition();
        Boolean isDisabled = entity.getBrain().getMemory(CobblemonMemories.DISABLE_WALK_TO_BERRY_BUSH).orElse(false);
        if (isDisabled.booleanValue()) {
            return;
        }
        Intrinsics.checkNotNull((Object)pos);
        Optional<BlockPos> nearestBush = this.findNearestBush(level, pos);
        if (!nearestBush.isEmpty()) {
            entity.getBrain().setMemory(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH, nearestBush);
        } else {
            entity.getBrain().eraseMemory(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH);
        }
    }

    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return SetsKt.setOf(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH);
    }

    private final Optional<BlockPos> findNearestBush(ServerLevel level, BlockPos origin) {
        BlockPos closest = null;
        double closestDistSq = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.offset(-10, 0, -10), (BlockPos)origin.offset(10, 0, 10))) {
            double distSq;
            BlockState state;
            Intrinsics.checkNotNullExpressionValue((Object)level.getBlockState(pos), (String)"getBlockState(...)");
            if ((!state.is(Blocks.SWEET_BERRY_BUSH) || ((Number)((Object)state.getValue((Property)SweetBerryBushBlock.AGE))).intValue() < 2) && !CaveVines.hasGlowBerries((BlockState)state) || !((distSq = pos.distSqr((Vec3i)origin)) < closestDistSq)) continue;
            closest = pos.immutable();
            closestDistSq = distSq;
        }
        Optional<Object> optional = Optional.ofNullable(closest);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/SweetBerryBushSensor$Companion;", "", "<init>", "()V", "", "SCAN_RADIUS_HORIZONTAL", "I", "SCAN_RADIUS_VERTICAL", "SCAN_INTERVAL", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

