/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001b\u0010\u0018J'\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001c\u0010\u0018J\u000f\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R!\u0010\u0013\u001a\r\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b&0\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010'\u00a8\u0006)"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/IgniteTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "findIgnitionPos", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Ljava/util/Optional;", "pos", "canLight", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/server/level/ServerLevel;)Z", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "addLookWalkTargets", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "stop", "tick", "Lnet/minecraft/world/item/ItemStack;", "createBoneMealStack", "()Lnet/minecraft/world/item/ItemStack;", "startTime", "J", "lastEndEntityAge", "", "duration", "I", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/Optional;", "Companion", "common"})
public final class IgniteTask
extends Behavior<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long startTime;
    private long lastEndEntityAge;
    private int duration;
    @NotNull
    private Optional<BlockPos> pos;
    private static final int MAX_DURATION = 80;

    public IgniteTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.pos = optional;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.pos = this.findIgnitionPos(world, entity);
        return this.pos.isPresent();
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.duration < 80 && this.pos.isPresent();
    }

    private final Optional<BlockPos> findIgnitionPos(ServerLevel world, PokemonEntity entity) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Optional<BlockPos> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        Optional<BlockPos> optional2 = optional;
        int i = 0;
        for (int j = -1; j < 2; ++j) {
            for (int k = -1; k < 2; ++k) {
                for (int l = -1; l < 2; ++l) {
                    mutable.set(j, k, l);
                    if (!this.canLight((BlockPos)mutable, world) || world.random.nextInt(++i) != 0) continue;
                    Intrinsics.checkNotNullExpressionValue(Optional.of(mutable.immutable()), (String)"of(...)");
                }
            }
        }
        return optional2;
    }

    private final boolean canLight(BlockPos pos, ServerLevel world) {
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        return block instanceof CampfireBlock && (Boolean)blockState.getValue((Property)CampfireBlock.LIT) == false;
    }

    protected void start(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.addLookWalkTargets(entity);
        this.startTime = time;
        this.duration = 0;
    }

    private final void addLookWalkTargets(PokemonEntity entity) {
        this.pos.ifPresent(arg_0 -> IgniteTask.addLookWalkTargets$lambda$1(arg_0 -> IgniteTask.addLookWalkTargets$lambda$0(entity, arg_0), arg_0));
    }

    protected void stop(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.lastEndEntityAge = entity.getAge();
    }

    protected void tick(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockPos blockPos = this.pos.get();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"get(...)");
        BlockPos blockPos2 = blockPos;
        BlockState blockState = world.getBlockState(blockPos2);
        if (time >= this.startTime && blockPos2.closerToCenterThan((Position)entity.position(), 1.0)) {
            if (CampfireBlock.canLight((BlockState)blockState) || CandleBlock.canLight((BlockState)blockState) || CandleCakeBlock.canLight((BlockState)blockState) && !world.isRainingAt(blockPos2)) {
                world.playSound(null, blockPos2, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                world.gameEvent((Entity)entity, (Holder)GameEvent.BLOCK_CHANGE, blockPos2);
                world.setBlock(blockPos2, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
                this.pos = this.findIgnitionPos(world, entity);
                this.addLookWalkTargets(entity);
                this.startTime = time + 40L;
            }
            ++this.duration;
        }
    }

    private final ItemStack createBoneMealStack() {
        return new ItemStack((ItemLike)Items.BONE_MEAL, 1);
    }

    private static final Unit addLookWalkTargets$lambda$0(PokemonEntity $entity, BlockPos pos) {
        BlockPosTracker blockPosLookTarget = new BlockPosTracker(pos);
        $entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)blockPosLookTarget);
        $entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)blockPosLookTarget, 0.5f, 1));
        return Unit.INSTANCE;
    }

    private static final void addLookWalkTargets$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/IgniteTask$Companion;", "", "<init>", "()V", "", "MAX_DURATION", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

