/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.CobblemonSounds;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/item/TumblestoneItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "Lnet/minecraft/world/level/block/Block;", "block", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/level/block/Block;)V", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/Block;", "getBlock", "()Lnet/minecraft/world/level/block/Block;", "common"})
public final class TumblestoneItem
extends Item {
    @NotNull
    private final Block block;

    public TumblestoneItem(@NotNull Item.Properties settings, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super(settings);
        this.block = block;
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Direction direction;
        BlockPos pos;
        Level world;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.isFaceSturdy((BlockGetter)(world = context.getLevel()), pos = context.getClickedPos(), direction = context.getClickedFace())) {
            if (!world.getBlockState(pos.relative(direction)).isAir()) {
                return InteractionResult.FAIL;
            }
            context.getItemInHand().consume(1, (LivingEntity)context.getPlayer());
            world.setBlockAndUpdate(pos.relative(direction), (BlockState)this.block.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)direction));
            world.playSound(null, pos, CobblemonSounds.TUMBLESTONE_PLACE, SoundSource.BLOCKS);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

