/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.interactive.ReviveItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/item/interactive/ReviveItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "", "max", "<init>", "(Z)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Z", "getMax", "()Z", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nReviveItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviveItem.kt\ncom/cobblemon/mod/common/item/interactive/ReviveItem\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,111:1\n40#2:112\n41#2,6:116\n47#2:124\n17#3,2:113\n19#3:123\n13805#4:115\n13806#4:122\n*S KotlinDebug\n*F\n+ 1 ReviveItem.kt\ncom/cobblemon/mod/common/item/interactive/ReviveItem\n*L\n97#1:112\n97#1:116,6\n97#1:124\n97#1:113,2\n97#1:123\n97#1:115\n97#1:122\n*E\n"})
public final class ReviveItem
extends CobblemonItem
implements HealingSource {
    private final boolean max;
    @NotNull
    private final BagItem bagItem;

    /*
     * WARNING - void declaration
     */
    public ReviveItem(boolean max) {
        Item.Properties properties;
        Item.Properties properties2 = properties = new Item.Properties();
        ReviveItem reviveItem = this;
        boolean bl = false;
        if (max) {
            void $this$_init__u24lambda_u240;
            $this$_init__u24lambda_u240.rarity(Rarity.UNCOMMON);
        }
        super(properties);
        this.max = max;
        this.bagItem = new BagItem(this){
            private final String itemName;
            private final Item returnItem;
            final /* synthetic */ ReviveItem this$0;
            {
                this.this$0 = $receiver;
                this.itemName = "item.cobblemon." + ($receiver.getMax() ? "max_revive" : "revive");
                this.returnItem = Items.AIR;
            }

            public String getItemName() {
                return this.itemName;
            }

            public Item getReturnItem() {
                return this.returnItem;
            }

            public boolean canUse(ItemStack stack, PokemonBattle battle, BattlePokemon target) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return target.getHealth() <= 0;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                return "revive " + (this.this$0.getMax() ? "1" : "0.5");
            }
        };
    }

    public final boolean getMax() {
        return this.max;
    }

    @NotNull
    public final BagItem getBagItem() {
        return this.bagItem;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!(world instanceof ServerLevel)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)user.getItemInHand(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        ServerPlayer player = (ServerPlayer)user;
        ItemStack stack = user.getItemInHand(hand);
        PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer(player);
        if (battle != null) {
            BattleActor battleActor = battle.getActor(player);
            Intrinsics.checkNotNull((Object)battleActor);
            BattleActor actor = battleActor;
            List<BattlePokemon> battlePokemon = actor.getPokemonList();
            if (!actor.canFitForcedAction()) {
                MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.cannot", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
                player.sendSystemMessage((Component)TextKt.red(mutableComponent), true);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                return interactionResultHolder;
            }
            int turn = battle.getTurn();
            PartySelectCallbacks.createBattleSelect$default(PartySelectCallbacks.INSTANCE, player, null, battlePokemon, arg_0 -> ReviveItem.use$lambda$0(this, stack, battle, arg_0), null, arg_0 -> ReviveItem.use$lambda$1(actor, battle, turn, stack, player, this, arg_0), 18, null);
        } else {
            List pokemon = CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player));
            PartySelectCallbacks.createFromPokemon$default(PartySelectCallbacks.INSTANCE, player, null, pokemon, use.3.INSTANCE, null, arg_0 -> ReviveItem.use$lambda$2(player, stack, this, arg_0), 18, null);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    private static final boolean use$lambda$0(ReviveItem this$0, ItemStack $stack, PokemonBattle $battle, BattlePokemon it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BagItem bagItem2 = this$0.bagItem;
        Intrinsics.checkNotNull((Object)$stack);
        return bagItem2.canUse($stack, $battle, it);
    }

    private static final Unit use$lambda$1(BattleActor $actor, PokemonBattle $battle, int $turn, ItemStack $stack, ServerPlayer $player, ReviveItem this$0, BattlePokemon bp) {
        Intrinsics.checkNotNullParameter((Object)bp, (String)"bp");
        if ($actor.canFitForcedAction() && bp.getHealth() <= 0 && $battle.getTurn() == $turn) {
            Intrinsics.checkNotNull((Object)$stack);
            if (ItemStackExtensionsKt.isHeld($stack, $player)) {
                $player.playSound(CobblemonSounds.ITEM_USE, 1.0f, 1.0f);
                $actor.forceChoose(new BagItemActionResponse(this$0.bagItem, bp, bp.getUuid().toString()));
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)$stack.getItem());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                ResourceLocation stackName = resourceLocation;
                $stack.consume(1, (LivingEntity)$player);
                CobblemonCriteria.POKEMON_INTERACT.trigger($player, new PokemonInteractContext(bp.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit use$lambda$2(ServerPlayer $player, ItemStack $stack, ReviveItem this$0, Pokemon pk) {
        Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
        if (pk.isFainted() && !PlayerExtensionsKt.isInBattle($player)) {
            Intrinsics.checkNotNull((Object)$stack);
            if (ItemStackExtensionsKt.isHeld($stack, $player)) {
                void this_$iv$iv;
                void this_$iv;
                int amount = 0;
                amount = this$0.max ? pk.getMaxHealth() : (int)Math.ceil((float)pk.getMaxHealth() / 2.0f);
                CancelableObservable<PokemonHealedEvent> cancelableObservable = CobblemonEvents.POKEMON_HEALED;
                Cancelable event$iv = new PokemonHealedEvent(pk, amount, this$0);
                boolean $i$f$postThen = false;
                EventObservable eventObservable = (EventObservable)this_$iv;
                Cancelable[] cancelableArray = new Cancelable[]{event$iv};
                Cancelable[] events$iv$iv = cancelableArray;
                boolean $i$f$post = false;
                this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
                Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    Cancelable element$iv$iv$iv;
                    Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    if (it$iv.isCanceled()) {
                        PokemonHealedEvent cancelledEvent = (PokemonHealedEvent)it$iv;
                        boolean bl2 = false;
                        return Unit.INSTANCE;
                    }
                    PokemonHealedEvent event = (PokemonHealedEvent)it$iv;
                    boolean bl3 = false;
                    amount = event.getAmount();
                }
                pk.setCurrentHealth(amount);
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)$stack.getItem());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                ResourceLocation stackName = resourceLocation;
                $stack.consume(1, (LivingEntity)$player);
                CobblemonCriteria.POKEMON_INTERACT.trigger($player, new PokemonInteractContext(pk.getSpecies().getResourceIdentifier(), stackName));
            }
        }
        return Unit.INSTANCE;
    }
}

