/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin {
    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private void cobblemon$adjustSpawnPosition(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, CallbackInfo ci) {
        AbstractArrow arrow = (AbstractArrow)this;
        Entity entity = owner.getVehicle();
        if (!(entity instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable vehicle = (OrientationControllable)entity;
        if (!(vehicle instanceof PokemonEntity)) {
            return;
        }
        OrientationController vehicleController = vehicle.getOrientationController();
        if (owner instanceof RidePassenger) {
            RidePassenger ridePassenger = (RidePassenger)owner;
            if (vehicleController != null) {
                Vec3 eyePos = ridePassenger.cobblemon$getRideEyePos();
                arrow.setPos(eyePos);
            }
        }
    }
}

