/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeehiveBlockEntity.Occupant.class})
public abstract class BeeOccupantMixin {
    @Inject(method={"createEntity(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")}, cancellable=true)
    private void cobblemon$createEntity(Level level, BlockPos pos, CallbackInfoReturnable<Entity> cir) {
        BeehiveBlockEntity.Occupant occupant;
        CompoundTag compoundTag;
        Entity entity;
        if (cir.getReturnValue() == null && (entity = EntityType.loadEntityRecursive((CompoundTag)(compoundTag = (occupant = (BeehiveBlockEntity.Occupant)this).entityData().copyTag()), (Level)level, entityx -> entityx)) instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            BlockState state = level.getBlockState(pos);
            Vec3 newPos = Vec3.ZERO;
            float newYaw = 0.0f;
            Brain<PokemonEntity> brain = pokemonEntity.getBrain();
            if (state.is(BlockTags.BEEHIVES)) {
                Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
                newPos = pos.relative(facing).getCenter();
                newYaw = facing.toYRot();
                brain.setMemory(CobblemonMemories.HIVE_LOCATION, (Object)pos);
            } else {
                Vec3 center = pos.getCenter();
                newPos = new Vec3(center.x + (double)level.random.nextFloat() * 0.6 - 0.3, center.y + (double)level.random.nextFloat() * 0.6 - 0.3, center.z + (double)level.random.nextFloat() * 0.6 - 0.3);
                newYaw = level.random.nextFloat() * 360.0f;
                brain.eraseMemory(CobblemonMemories.HIVE_LOCATION);
            }
            entity.yRotO = newYaw;
            entity.setPos(newPos);
            Boolean hasNectar = brain.getMemory(CobblemonMemories.HAS_NECTAR).orElse(false);
            if (hasNectar.booleanValue()) {
                int i;
                brain.eraseMemory(CobblemonMemories.HAS_NECTAR);
                brain.setMemoryWithExpiry(CobblemonMemories.HIVE_COOLDOWN, (Object)true, 400L);
                if (state.is(BlockTags.BEEHIVES, blockStateBase -> blockStateBase.hasProperty((Property)BeehiveBlock.HONEY_LEVEL)) && (i = ((Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL)).intValue()) < 5) {
                    int j;
                    int n = j = level.random.nextInt(100) == 0 ? 2 : 1;
                    if (i + j > 5) {
                        --j;
                    }
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(i + j)));
                }
            }
            cir.setReturnValue((Object)entity);
        }
    }

    @Inject(method={"of(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/level/block/entity/BeehiveBlockEntity$Occupant;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cobblemon$of(Entity entity, CallbackInfoReturnable<BeehiveBlockEntity.Occupant> cir) {
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "Passengers", "leash", "UUID");
            CompoundTag compoundTag = new CompoundTag();
            entity.save(compoundTag);
            Objects.requireNonNull(compoundTag);
            IGNORED_BEE_TAGS.forEach(arg_0 -> ((CompoundTag)compoundTag).remove(arg_0));
            Boolean hasNectar = pokemonEntity.getBrain().getMemory(CobblemonMemories.HAS_NECTAR).orElse(false);
            cir.setReturnValue((Object)new BeehiveBlockEntity.Occupant(CustomData.of((CompoundTag)compoundTag), 0, hasNectar != false ? 2400 : 600));
            cir.cancel();
        }
    }
}

